/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.pairedData;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.io.PairedDataContainer;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.pairedData.SelectionType;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

public class PairedData
extends Data {
    @JsonProperty
    PairedDataContainer _pairedDataContainer;
    @JsonProperty
    int _curve = 0;
    public static final String TYPE = "PairedData";
    public static final String NAME = "Paired Data";

    public PairedData() {
        super(TYPE, NAME);
        this._pairedDataContainer = new PairedDataContainer();
    }

    public PairedData(PairedData dssData) {
        super(dssData);
        this._curve = dssData.getCurve();
        PairedDataContainer pdc = dssData.getPairedDataContainer();
        if (pdc != null) {
            this._pairedDataContainer = new PairedDataContainer();
            pdc.clone(this._pairedDataContainer);
        }
    }

    public PairedData(PairedDataContainer pdc, int curve) {
        super(TYPE, NAME);
        this._curve = curve;
        if (pdc != null) {
            this._pairedDataContainer = new PairedDataContainer();
            pdc.clone(this._pairedDataContainer);
        }
    }

    public PairedDataContainer getPairedDataContainer() {
        return this._pairedDataContainer;
    }

    public void setPairedDataContainer(PairedDataContainer pdc) {
        this._pairedDataContainer = pdc;
    }

    @Override
    public boolean isDefined() {
        if (!super.isDefined()) {
            return false;
        }
        return this._pairedDataContainer != null;
    }

    @Override
    public int getCompType() {
        return this._compType;
    }

    public void add(double x, double[] y) {
        int numXOrds = this._pairedDataContainer.getNumberOrdinates();
        PairedDataContainer.ensureCurveExists((PairedDataContainer)this._pairedDataContainer, (int)(y.length - 1));
        PairedDataContainer.ensureXOrdCapacity((PairedDataContainer)this._pairedDataContainer, (int)(numXOrds + 1));
        this._pairedDataContainer.xOrdinates[numXOrds] = x;
        for (int i = 0; i < y.length; ++i) {
            double val = y[i];
            PairedDataContainer.ensureCurveCapacity((PairedDataContainer)this._pairedDataContainer, (int)i, (int)(numXOrds + 1));
            this._pairedDataContainer.yOrdinates[i][numXOrds] = val;
        }
        this._pairedDataContainer.numberOrdinates = numXOrds + 1;
    }

    public int getCurve() {
        return this._curve;
    }

    @JsonIgnore
    public SelectionType getSelectionType() {
        return SelectionType.UseSelectedRecord;
    }

    public String toString() {
        return "PairedData{ curve:" + this.getCurve() + "pdc: " + this.getPairedDataContainer() + "}";
    }

    @Override
    public PairedData copy() {
        return new PairedData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(PairedData.class);
        }
    }
}

