/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

public class TableData
extends Data {
    @JsonProperty(value="dates")
    String[] _dates = new String[0];
    @JsonProperty(value="values")
    double[] _values = new double[0];
    @JsonIgnore
    String _variableName = "";
    public static final String TYPE = "TableData";
    public static final String NAME = "Table Data";

    public TableData() {
        super(TYPE, NAME);
    }

    public TableData(TableData tableData) {
        super(tableData);
        this.setVariableName(tableData.getVariableName());
        this.setDescription(tableData.getDescription());
        this.setAvailableUnits(tableData.getAvailableUnits());
        this.setTimeSeries(tableData.getDates(), tableData.getValues());
    }

    public String[] getDates() {
        return this._dates;
    }

    public double[] getValues() {
        return this._values;
    }

    @Override
    public boolean isDefined() {
        if (!super.isDefined()) {
            return false;
        }
        if (this._dates == null || this._dates.length == 0) {
            return false;
        }
        return this._values != null && this._values.length != 0;
    }

    public void setTimeSeries(String[] dates, double[] values) {
        if (dates == null) {
            dates = new String[]{};
        }
        if (values == null) {
            values = new double[]{};
        }
        if (dates.length != values.length) {
            throw new RuntimeException("Invalid Table Data Time Series: arrays must be of equals size");
        }
        this._dates = dates;
        this._values = values;
    }

    @JsonIgnore
    public String getVariableName() {
        return this._variableName;
    }

    public void setVariableName(String name) {
        this._variableName = name;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this._values == null || this._values.length == 0;
    }

    @Override
    @JsonIgnore
    public TableData copy() {
        return new TableData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class TableDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return TableData.class;
        }

        @Override
        public String getTypeId() {
            return TableData.class.getSimpleName();
        }
    }
}

