/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dataSource.timeSeries;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.jackson.TypeResolver;
import java.nio.file.Path;
import java.nio.file.Paths;
import rma.services.annotations.ServiceProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DssData
extends Data {
    public static final String TYPE = "DSSData";
    public static final String NAME = "DSS";
    @JsonProperty(value="HasInterpretedUnits")
    private boolean _hasInterpretedUnits = true;
    @JsonProperty(value="DSS Path")
    String _dssPath = "";
    @JsonProperty(value="DSS File Path")
    Path _dssFilePath = null;
    @JsonProperty(value="Interpreted Units")
    String _interpretedUnits = "";
    private boolean _isProfile = false;

    public DssData(boolean hasInterpUnits) {
        super(TYPE, NAME);
        this._hasInterpretedUnits = hasInterpUnits;
    }

    public DssData() {
        super(TYPE, NAME);
    }

    public DssData(DssData dssData) {
        super(dssData);
        this.setDssFilePath(dssData.getDssFilePath());
        this.setDssPath(dssData.getDssPath());
        this.setAvailableUnits(dssData.getAvailableUnits());
        this.setUnits(dssData.getUnits());
        this.setInterpretedUnits(dssData.getInterpretedUnits());
        this.setCompType(dssData.getCompType());
        this.setIsProfile(dssData.isProfileData());
        this.setHasInterpretedUnits(dssData.hasInterpretedUnits());
    }

    protected DssData(String type, String name) {
        super(type, name);
    }

    @Override
    public boolean isDefined() {
        if (!super.isDefined()) {
            return false;
        }
        if (this._dssPath == null || this._dssPath.isEmpty()) {
            return false;
        }
        return this._dssFilePath != null;
    }

    @JsonIgnore
    public String getDssPath() {
        return this._dssPath;
    }

    public void setDssPath(String dssPath) {
        this._dssPath = dssPath;
    }

    @JsonIgnore
    public String getDssFilePath() {
        return this._dssFilePath != null ? this._dssFilePath.toString() : "";
    }

    public void setDssFilePath(String dssFilePath) {
        this._dssFilePath = dssFilePath != null && !dssFilePath.isEmpty() ? Paths.get(dssFilePath, new String[0]) : null;
    }

    public String getInterpretedUnits() {
        return this._interpretedUnits;
    }

    public void setInterpretedUnits(String units) {
        this._interpretedUnits = units;
    }

    public boolean hasInterpretedUnits() {
        return this._hasInterpretedUnits;
    }

    public void setHasInterpretedUnits(boolean hasInterpUnits) {
        this._hasInterpretedUnits = hasInterpUnits;
    }

    @Override
    public int getCompType() {
        return this._compType;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        boolean hasData = this.getDssFilePath() != null && !this.getDssFilePath().isEmpty() || this.getDssPath() != null && !this.getDssPath().replace("/", "").isEmpty();
        return !hasData;
    }

    public void setIsProfile(boolean isProfile) {
        this._isProfile = isProfile;
    }

    public boolean isProfileData() {
        return this._isProfile;
    }

    @Override
    @JsonIgnore
    public DssData copy() {
        return new DssData(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class DssDataTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return DssData.class;
        }

        @Override
        public String getTypeId() {
            return DssData.class.getSimpleName();
        }
    }
}

