/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dispersion;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class MunkAndersonDispersionData {
    private double _ACoeff = 3.33;
    private double _BCoeff = 1.5;
    private double _CCoeff = 0.03;
    private double _Dzmin = 0.0;

    public MunkAndersonDispersionData() {
    }

    public MunkAndersonDispersionData(int unitSys) {
        if (unitSys == 1) {
            this.convertDefaultValsToEnglish();
        }
    }

    public double getACoeff() {
        return this._ACoeff;
    }

    public void setACoeff(double _ACoeff) {
        this._ACoeff = _ACoeff;
    }

    public double getBCoeff() {
        return this._BCoeff;
    }

    public void setBCoeff(double _BCoeff) {
        this._BCoeff = _BCoeff;
    }

    public double getCCoeff() {
        return this._CCoeff;
    }

    public void setCCoeff(double _CCoeff) {
        this._CCoeff = _CCoeff;
    }

    public double getDzmin() {
        return this._Dzmin;
    }

    public void setDzmin(double _Dzmin) {
        this._Dzmin = _Dzmin;
    }

    private void convertDefaultValsToEnglish() {
        double m2ft = 1.0;
        try {
            m2ft = Units.convertUnits((double)1.0, (String)"m", (String)"ft");
        }
        catch (UnitsConversionException e) {
            e.printStackTrace();
        }
        this._CCoeff *= m2ft;
        this._Dzmin = this._Dzmin * m2ft * m2ft;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
    }
}

