/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dispersion;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class StabilityDispersionData {
    private double _Ecrit = 2.0E-7;
    private double _A1 = 3.0E-6;
    private double _A3 = 0.7;

    public StabilityDispersionData() {
    }

    public StabilityDispersionData(int unitSys) {
        if (unitSys == 1) {
            this.convertDefaultValsToEnglish();
        }
    }

    public double getEcrit() {
        return this._Ecrit;
    }

    public void setEcrit(double ecrit) {
        this._Ecrit = ecrit;
    }

    public double getA1() {
        return this._A1;
    }

    public void setA1(double a1) {
        this._A1 = a1;
    }

    public double getA3() {
        return this._A3;
    }

    public void setA3(double a3) {
        this._A3 = a3;
    }

    private void convertDefaultValsToEnglish() {
        double m2ft = 1.0;
        try {
            m2ft = Units.convertUnits((double)1.0, (String)"m", (String)"ft");
        }
        catch (UnitsConversionException e) {
            e.printStackTrace();
        }
        this._Ecrit /= m2ft;
        this._A1 = this._A1 * m2ft * m2ft;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
    }
}

