/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.dispersion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.wqenginecore.jackson.TypeResolver;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WindDispersionData {
    private double _Dzmin = 1.0E-6;
    private double _A1 = 1.0E-5;
    private double _A2 = 4.6;
    private double _Dzmax = Double.NEGATIVE_INFINITY;
    @JsonProperty(value="useDzMax")
    private boolean _useDzMax = false;

    public WindDispersionData() {
    }

    public WindDispersionData(int unitSys) {
        if (unitSys == 1) {
            this.convertDefaultValsToEnglish();
        }
    }

    @JsonIgnore
    public boolean useDzMax() {
        return this._useDzMax;
    }

    public void setUseDzMax(boolean useDzMax) {
        this._useDzMax = useDzMax;
    }

    public double getDzmin() {
        return this._Dzmin;
    }

    public void setDzmin(double dzmin) {
        this._Dzmin = dzmin;
    }

    public double getA1() {
        return this._A1;
    }

    public void setA1(double a1) {
        this._A1 = a1;
    }

    public double getA2() {
        return this._A2;
    }

    public void setA2(double a2) {
        this._A2 = a2;
    }

    public double getDzmax() {
        return this._Dzmax;
    }

    public void setDzmax(double dzmax) {
        this._Dzmax = dzmax;
    }

    private void convertDefaultValsToEnglish() {
        double m2ft = 1.0;
        try {
            m2ft = Units.convertUnits((double)1.0, (String)"m", (String)"ft");
        }
        catch (UnitsConversionException e) {
            e.printStackTrace();
        }
        this._Dzmin = this._Dzmin * m2ft * m2ft;
        this._A1 *= m2ft;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
    }
}

