/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.flowtable;

import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.model.Interpolate;
import hec.wqenginecore.WQException;
import hec.wqenginecore.flowtable.ColumnDefinition;
import hec.wqenginecore.flowtable.DefaultFlowTableRowData;
import hec.wqenginecore.flowtable.FlowTableLocationTemplate;
import hec.wqenginecore.flowtable.FlowTableRowData;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class FlowTable {
    private String _planName = null;
    private List<String> _riverNames;
    private List<String> _reachNames;
    private List<String> _riverStations;
    private int _riverCount = -1;
    private int _reachesCount = -1;
    private int _riverStationsCount = -1;
    private int _plansCount = -1;
    private int _profilesCount = -1;
    private Map<FlowTableLocationTemplate, List<FlowTableRowData>> _rowDataMap = new HashMap<FlowTableLocationTemplate, List<FlowTableRowData>>();
    private ColumnDefinition _riverNameColumn;
    private ColumnDefinition _reachNameColumn;
    private ColumnDefinition _riverStationColumn;
    private ColumnDefinition _profileColumn;
    private ColumnDefinition _qLeftColumn;
    private ColumnDefinition _qChannelColumn;
    private ColumnDefinition _qRightColumn;
    private ColumnDefinition _flowAreaLeft;
    private ColumnDefinition _flowAreaChannel;
    private ColumnDefinition _flowAreaRight;
    private ColumnDefinition _velocityLeft;
    private ColumnDefinition _velocityChannel;
    private ColumnDefinition _velocityRight;
    private ColumnDefinition _topWLeft;
    private ColumnDefinition _topWChannel;
    private ColumnDefinition _topWRight;
    private static final String RIVER_HEADER_NAME_LOWERCASE = "river";
    private static final String SECOND_LINE_PLAN_STRING = "Plan: ";
    private static final String SECOND_LINE_RIVER_STRING = "River: ";
    private static final String SECOND_LINE_REACH_STRING = "Reach: ";

    private FlowTable() {
        this._riverNames = new ArrayList<String>();
        this._reachNames = new ArrayList<String>();
        this._riverStations = new ArrayList<String>();
    }

    public static FlowTable parseFromPath(Path location) throws IOException, WQException {
        FlowTable flowTable = new FlowTable();
        try (BufferedReader reader = new BufferedReader(new FileReader(location.toFile()));){
            String currentLineFromFile;
            String ignore = reader.readLine();
            flowTable.parsePlanRiverReachLine(reader.readLine());
            ignore = reader.readLine();
            flowTable._riverCount = flowTable.parseCountLine(reader.readLine());
            flowTable._reachesCount = flowTable.parseCountLine(reader.readLine());
            flowTable._riverStationsCount = flowTable.parseCountLine(reader.readLine());
            flowTable._plansCount = flowTable.parseCountLine(reader.readLine());
            flowTable._profilesCount = flowTable.parseCountLine(reader.readLine());
            ignore = reader.readLine();
            String headerRow = reader.readLine();
            String unitsRow = reader.readLine();
            flowTable.parseColumnHeaders(headerRow, unitsRow);
            FlowTable.checkUnits(flowTable);
            ignore = reader.readLine();
            while ((currentLineFromFile = reader.readLine()) != null) {
                flowTable.parseRowDataFromLine(currentLineFromFile);
            }
        }
        return flowTable;
    }

    private static void checkUnits(FlowTable flowTable) throws WQException {
        List<String> allowedLengthUnits = Arrays.asList("ft", "m");
        List<String> allowedAreaUnits = Arrays.asList("sq ft", "m2");
        List<String> allowedFlowUnits = Arrays.asList("cfs", "m3/s");
        List<String> allowedVelUnits = Arrays.asList("ft/s", "m/s");
        if (!allowedFlowUnits.contains(flowTable._qLeftColumn.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Q Left: " + flowTable._qLeftColumn.getColumnUnits());
        }
        if (!allowedFlowUnits.contains(flowTable._qChannelColumn.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Q Channel: " + flowTable._qChannelColumn.getColumnUnits());
        }
        if (!allowedFlowUnits.contains(flowTable._qRightColumn.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Q Right: " + flowTable._qRightColumn.getColumnUnits());
        }
        if (!allowedAreaUnits.contains(flowTable._flowAreaLeft.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Flow Area Left: " + flowTable._flowAreaLeft.getColumnUnits());
        }
        if (!allowedAreaUnits.contains(flowTable._flowAreaChannel.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Flow Area Channel: " + flowTable._flowAreaChannel.getColumnUnits());
        }
        if (!allowedAreaUnits.contains(flowTable._flowAreaRight.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Flow Area Right: " + flowTable._flowAreaRight.getColumnUnits());
        }
        if (!allowedVelUnits.contains(flowTable._velocityLeft.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Velocity Left: " + flowTable._velocityLeft.getColumnUnits());
        }
        if (!allowedVelUnits.contains(flowTable._velocityChannel.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Velocity Channel: " + flowTable._velocityChannel.getColumnUnits());
        }
        if (!allowedVelUnits.contains(flowTable._velocityRight.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Velocity Right: " + flowTable._velocityRight.getColumnUnits());
        }
        if (!allowedLengthUnits.contains(flowTable._topWLeft.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Top Width Left: " + flowTable._topWLeft.getColumnUnits());
        }
        if (!allowedLengthUnits.contains(flowTable._topWChannel.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Top Width Channel: " + flowTable._topWChannel.getColumnUnits());
        }
        if (!allowedLengthUnits.contains(flowTable._topWRight.getColumnUnits())) {
            throw new WQException("Unrecognized RAS steady flow table file units for Top Width Right: " + flowTable._topWRight.getColumnUnits());
        }
    }

    private int parseCountLine(String readLine) {
        int count = -1;
        int indexOfEquals = readLine.indexOf(61);
        if (indexOfEquals != -1) {
            String truncated = readLine.substring(indexOfEquals + 1);
            return RMAIO.parseInt((String)truncated, (int)-1);
        }
        return count;
    }

    private void parsePlanRiverReachLine(String lineFromTextfile) {
        if (lineFromTextfile != null && !lineFromTextfile.isEmpty()) {
            int indexOfPlan = lineFromTextfile.lastIndexOf(SECOND_LINE_PLAN_STRING);
            String truncatedLine = lineFromTextfile.substring(indexOfPlan + SECOND_LINE_PLAN_STRING.length());
            int firstIndexOfSpace = truncatedLine.indexOf(32);
            if (firstIndexOfSpace == -1) {
                firstIndexOfSpace = truncatedLine.length();
            }
            this._planName = truncatedLine.substring(0, firstIndexOfSpace);
            int indexOfRiver = truncatedLine.indexOf(SECOND_LINE_RIVER_STRING);
            if (indexOfRiver != -1) {
                truncatedLine = truncatedLine.substring(indexOfRiver + SECOND_LINE_RIVER_STRING.length());
                int indexOfReach = truncatedLine.indexOf(SECOND_LINE_REACH_STRING);
                String riverName = truncatedLine.substring(0, indexOfReach).trim();
                this._riverNames.add(riverName);
            }
        }
    }

    private void parseColumnHeaders(String headerRow, String unitsRow) {
        if (headerRow != null && !headerRow.isEmpty() && unitsRow != null && !unitsRow.isEmpty()) {
            this._riverNameColumn = new ColumnDefinition();
            this._riverNameColumn.findColumnStartBySpaces(headerRow);
            this._riverNameColumn.findColumnEndBySpaces(headerRow);
            String riverNameColumnTitle = this._riverNameColumn.parseValueForColumn(headerRow).toLowerCase();
            if (Objects.equals(RIVER_HEADER_NAME_LOWERCASE, riverNameColumnTitle)) {
                this._reachNameColumn = this._riverNameColumn.after();
                this._reachNameColumn.findColumnEndBySpaces(headerRow);
            } else {
                this._reachNameColumn = this._riverNameColumn;
                this._riverNameColumn = null;
            }
            this._riverStationColumn = this._reachNameColumn.after();
            this._riverStationColumn.findColumnEndBySpaces(headerRow);
            this._profileColumn = this._riverStationColumn.after();
            this._profileColumn.findColumnEndBySpaces(headerRow);
            this._qLeftColumn = this._profileColumn.after();
            this._qLeftColumn.findColumnEndByUnitsParens(unitsRow);
            this._qLeftColumn.findColumnUnits(unitsRow);
            this._qChannelColumn = this._qLeftColumn.after();
            this._qChannelColumn.findColumnEndByUnitsParens(unitsRow);
            this._qChannelColumn.findColumnUnits(unitsRow);
            this._qRightColumn = this._qChannelColumn.after();
            this._qRightColumn.findColumnEndByUnitsParens(unitsRow);
            this._qRightColumn.findColumnUnits(unitsRow);
            this._flowAreaLeft = this._qRightColumn.after();
            this._flowAreaLeft.findColumnEndByUnitsParens(unitsRow);
            this._flowAreaLeft.findColumnUnits(unitsRow);
            this._flowAreaChannel = this._flowAreaLeft.after();
            this._flowAreaChannel.findColumnEndByUnitsParens(unitsRow);
            this._flowAreaChannel.findColumnUnits(unitsRow);
            this._flowAreaRight = this._flowAreaChannel.after();
            this._flowAreaRight.findColumnEndByUnitsParens(unitsRow);
            this._flowAreaRight.findColumnUnits(unitsRow);
            this._velocityLeft = this._flowAreaRight.after();
            this._velocityLeft.findColumnEndByUnitsParens(unitsRow);
            this._velocityLeft.findColumnUnits(unitsRow);
            this._velocityChannel = this._velocityLeft.after();
            this._velocityChannel.findColumnEndByUnitsParens(unitsRow);
            this._velocityChannel.findColumnUnits(unitsRow);
            this._velocityRight = this._velocityChannel.after();
            this._velocityRight.findColumnEndByUnitsParens(unitsRow);
            this._velocityRight.findColumnUnits(unitsRow);
            this._topWLeft = this._velocityRight.after();
            this._topWLeft.findColumnEndByUnitsParens(unitsRow);
            this._topWLeft.findColumnUnits(unitsRow);
            this._topWChannel = this._topWLeft.after();
            this._topWChannel.findColumnEndByUnitsParens(unitsRow);
            this._topWChannel.findColumnUnits(unitsRow);
            this._topWRight = this._topWChannel.after();
            this._topWRight.findColumnEndByUnitsParens(unitsRow);
            this._topWRight.findColumnUnits(unitsRow);
        }
    }

    private void parseRowDataFromLine(String rowDataLineFromTextFile) {
        if (rowDataLineFromTextFile != null && !rowDataLineFromTextFile.trim().isEmpty()) {
            List<FlowTableRowData> rowDataForLocationTemplate;
            DefaultFlowTableRowData rowDataForLine = new DefaultFlowTableRowData();
            String reachName = this._reachNameColumn.parseValueForColumn(rowDataLineFromTextFile);
            String riverStation = this._riverStationColumn.parseValueForColumn(rowDataLineFromTextFile);
            String riverName = "";
            riverName = this._riverCount > 1 && this._riverNameColumn != null ? this._riverNameColumn.parseValueForColumn(rowDataLineFromTextFile) : this._riverNames.get(0);
            FlowTableLocationTemplate locationTemplateForRow = this.getLocationTemplateForRow(riverName, reachName, riverStation);
            if (locationTemplateForRow == null) {
                locationTemplateForRow = new FlowTableLocationTemplate(riverName, reachName, riverStation);
                this._rowDataMap.put(locationTemplateForRow, new ArrayList());
                if (!this._riverNames.contains(riverName)) {
                    this._riverNames.add(riverName);
                }
                if (!this._reachNames.contains(reachName)) {
                    this._reachNames.add(reachName);
                }
                if (!this._riverStations.contains(riverStation)) {
                    this._riverStations.add(riverStation);
                }
            }
            if ((rowDataForLocationTemplate = this._rowDataMap.get(locationTemplateForRow)) == null) {
                rowDataForLocationTemplate = new ArrayList<FlowTableRowData>();
            }
            rowDataForLine.setLocationInformation(locationTemplateForRow);
            rowDataForLine.setProfile(this._profileColumn.parseValueForColumn(rowDataLineFromTextFile));
            double temp = RMAIO.parseDouble((String)this._qLeftColumn.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowLeft(temp);
            temp = RMAIO.parseDouble((String)this._qChannelColumn.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowChannel(temp);
            temp = RMAIO.parseDouble((String)this._qRightColumn.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowRight(temp);
            temp = RMAIO.parseDouble((String)this._flowAreaLeft.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowAreaLeft(temp);
            temp = RMAIO.parseDouble((String)this._flowAreaChannel.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowAreaChannel(temp);
            temp = RMAIO.parseDouble((String)this._flowAreaRight.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setFlowAreaRight(temp);
            temp = RMAIO.parseDouble((String)this._velocityLeft.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setVelocityLeft(temp);
            temp = RMAIO.parseDouble((String)this._velocityChannel.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setVelocityChannel(temp);
            temp = RMAIO.parseDouble((String)this._velocityRight.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setVelocityRight(temp);
            temp = RMAIO.parseDouble((String)this._topWLeft.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setTopWidthLeft(temp);
            temp = RMAIO.parseDouble((String)this._topWChannel.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setTopWidthChannel(temp);
            temp = RMAIO.parseDouble((String)this._topWRight.parseValueForColumn(rowDataLineFromTextFile));
            rowDataForLine.setTopWidthRight(temp);
            rowDataForLocationTemplate.add(rowDataForLine);
        }
    }

    public double getFlowArea(String river, String reachName, String riverStation, double flow, Units areaUnits, Units flowUnits) throws WQException {
        double[] flowAreas;
        double[] flows;
        FlowTableLocationTemplate locationTemplateForRow = this.getLocationTemplateForRow(river, reachName, riverStation);
        if (locationTemplateForRow != null) {
            List<FlowTableRowData> rowDataForTemplate = this._rowDataMap.get(locationTemplateForRow);
            flows = new double[rowDataForTemplate.size() + 1];
            flowAreas = new double[rowDataForTemplate.size() + 1];
            flows[0] = 0.0;
            flowAreas[0] = 0.0;
            for (int rowDataIndex = 0; rowDataIndex < rowDataForTemplate.size(); ++rowDataIndex) {
                FlowTableRowData rowData = rowDataForTemplate.get(rowDataIndex);
                flows[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getFlowLeft(), rowData.getFlowChannel(), rowData.getFlowRight());
                flowAreas[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getFlowAreaLeft(), rowData.getFlowAreaChannel(), rowData.getFlowAreaRight());
                if (flowAreas[rowDataIndex + 1] != 0.0) continue;
                throw new WQException("RAS Steady Flow table entries for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + " has a row entry with zero flow area");
            }
        } else {
            throw new WQException("RAS Steady Flow area table entry not found for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + ", Flow: " + flow);
        }
        flow = this.convertFlowUnits(flow, flowUnits.toString(), this._qChannelColumn.getColumnUnits());
        double flowArea = Interpolate.linearInterpolate((double[])flows, (double[])flowAreas, (double)flow, (int)flows.length);
        try {
            flowArea = Units.convertUnits((double)flowArea, (String)this._flowAreaChannel.getColumnUnits(), (String)areaUnits.toString());
        }
        catch (UnitsConversionException uce) {
            throw new WQException("Error converting RAS cross sectional area table units", (Exception)((Object)uce));
        }
        FlowTable.checkRASTableValue(flowArea, "Flow Area", river, reachName, riverStation);
        return flowArea;
    }

    public double[] getFlows(String river, String reachName, String riverStation, Units units) throws WQException {
        FlowTableLocationTemplate locationTemplateForRow = this.getLocationTemplateForRow(river, reachName, riverStation);
        if (locationTemplateForRow != null) {
            List<FlowTableRowData> rowDataForTemplate = this._rowDataMap.get(locationTemplateForRow);
            double[] flows = new double[rowDataForTemplate.size() + 1];
            flows[0] = 0.0;
            for (int rowDataIndex = 0; rowDataIndex < rowDataForTemplate.size(); ++rowDataIndex) {
                FlowTableRowData rowData = rowDataForTemplate.get(rowDataIndex);
                double flow = this.sumDoublesRAS(rowData.getFlowLeft(), rowData.getFlowChannel(), rowData.getFlowRight());
                if (flow == 0.0) {
                    throw new WQException("RAS Steady Flow table entries for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + " has a row entry with zero flow");
                }
                flow = this.convertFlowUnits(flow, this._qChannelColumn.getColumnUnits(), units.toString());
                FlowTable.checkRASTableValue(flow, "Flow", river, reachName, riverStation);
                flows[rowDataIndex + 1] = flow;
            }
            return flows;
        }
        throw new WQException("RAS Steady Flow table entries not found for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation);
    }

    public double getTopWidth(String river, String reachName, String riverStation, double flow, Units topWidthUnits, Units flowUnits) throws WQException {
        double[] topWidths;
        double[] flows;
        FlowTableLocationTemplate locationTemplateForRow = this.getLocationTemplateForRow(river, reachName, riverStation);
        if (locationTemplateForRow != null) {
            List<FlowTableRowData> rowDataForTemplate = this._rowDataMap.get(locationTemplateForRow);
            flows = new double[rowDataForTemplate.size() + 1];
            topWidths = new double[rowDataForTemplate.size() + 1];
            flows[0] = 0.0;
            topWidths[0] = 0.0;
            for (int rowDataIndex = 0; rowDataIndex < rowDataForTemplate.size(); ++rowDataIndex) {
                FlowTableRowData rowData = rowDataForTemplate.get(rowDataIndex);
                flows[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getFlowLeft(), rowData.getFlowChannel(), rowData.getFlowRight());
                topWidths[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getTopWidthLeft(), rowData.getTopWidthChannel(), rowData.getTopWidthRight());
                if (topWidths[rowDataIndex + 1] != 0.0) continue;
                throw new WQException("RAS Steady Flow table entries for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + " has a row entry with zero top width");
            }
        } else {
            throw new WQException("RAS Steady Flow top width table entry not found for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + ", Flow: " + flow);
        }
        flow = this.convertFlowUnits(flow, flowUnits.toString(), this._qChannelColumn.getColumnUnits());
        double topWidth = Interpolate.linearInterpolate((double[])flows, (double[])topWidths, (double)flow, (int)flows.length);
        try {
            topWidth = Units.convertUnits((double)topWidth, (String)this._topWChannel.getColumnUnits(), (String)topWidthUnits.toString());
        }
        catch (UnitsConversionException uce) {
            throw new WQException("Error converting RAS top width table units", (Exception)((Object)uce));
        }
        FlowTable.checkRASTableValue(topWidth, "Top Width", river, reachName, riverStation);
        return topWidth;
    }

    private double convertFlowUnits(double flow, String flowUnits, String colUnits) throws WQException {
        try {
            flow = Units.convertUnits((double)flow, (String)flowUnits, (String)colUnits);
        }
        catch (UnitsConversionException uce) {
            throw new WQException("Error converting RAS flow table units", (Exception)((Object)uce));
        }
        return flow;
    }

    public double getVelocity(String river, String reachName, String riverStation, double flow, Units velocityUnits, Units flowUnits) throws WQException {
        double[] velocities;
        double[] flows;
        FlowTableLocationTemplate locationTemplateForRow = this.getLocationTemplateForRow(river, reachName, riverStation);
        if (locationTemplateForRow != null) {
            List<FlowTableRowData> rowDataForTemplate = this._rowDataMap.get(locationTemplateForRow);
            flows = new double[rowDataForTemplate.size() + 1];
            velocities = new double[rowDataForTemplate.size() + 1];
            flows[0] = 0.0;
            velocities[0] = 0.0;
            for (int rowDataIndex = 0; rowDataIndex < rowDataForTemplate.size(); ++rowDataIndex) {
                FlowTableRowData rowData = rowDataForTemplate.get(rowDataIndex);
                flows[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getFlowLeft(), rowData.getFlowChannel(), rowData.getFlowRight());
                velocities[rowDataIndex + 1] = this.sumDoublesRAS(rowData.getVelocityLeft(), rowData.getVelocityChannel(), rowData.getVelocityRight());
                if (velocities[rowDataIndex + 1] != 0.0) continue;
                throw new WQException("RAS Steady Flow table entries for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + " has a row entry with zero velocity");
            }
        } else {
            throw new WQException("RAS Steady Flow velocity table entry not found for River: " + river + ", Reach: " + reachName + ", Station: " + riverStation + ", Flow: " + flow);
        }
        flow = this.convertFlowUnits(flow, flowUnits.toString(), this._qChannelColumn.getColumnUnits());
        double totalVelocity = Interpolate.linearInterpolate((double[])flows, (double[])velocities, (double)flow, (int)flows.length);
        totalVelocity /= flow;
        try {
            totalVelocity = Units.convertUnits((double)totalVelocity, (String)this._velocityChannel.getColumnUnits(), (String)velocityUnits.toString());
        }
        catch (UnitsConversionException uce) {
            throw new WQException("Error converting RAS cross sectional velocity table units", (Exception)((Object)uce));
        }
        FlowTable.checkRASTableValue(totalVelocity, "Velocity", river, reachName, riverStation);
        return totalVelocity;
    }

    public FlowTableLocationTemplate getLocationTemplateForRow(String river, String reachName, String riverStation) {
        FlowTableLocationTemplate query = new FlowTableLocationTemplate(river, reachName, riverStation);
        if (this._rowDataMap.containsKey(query)) {
            return query;
        }
        return null;
    }

    private double sumDoubles(double ... doubles) {
        double sum = 0.0;
        for (double value : doubles) {
            if (!RMAConst.isValidValue((double)value)) continue;
            sum += value;
        }
        return sum;
    }

    private double sumDoublesRAS(double leftFP, double channel, double rightFP) {
        boolean useOnlyChannelVals = true;
        double sum = 0.0;
        if (!useOnlyChannelVals && RMAConst.isValidValue((double)leftFP)) {
            sum += leftFP;
        }
        if (RMAConst.isValidValue((double)channel)) {
            sum += channel;
        }
        if (!useOnlyChannelVals && RMAConst.isValidValue((double)rightFP)) {
            sum += rightFP;
        }
        if (useOnlyChannelVals && sum == 0.0) {
            if (RMAConst.isValidValue((double)leftFP)) {
                sum += leftFP;
            }
            if (RMAConst.isValidValue((double)rightFP)) {
                sum += rightFP;
            }
        }
        return sum;
    }

    public int getRiverCount() {
        return this._riverCount;
    }

    public int getReachesCount() {
        return this._reachesCount;
    }

    public int getRiverStationsCount() {
        return this._riverStationsCount;
    }

    public int getProfilesCount() {
        return this._profilesCount;
    }

    public List<String> getRiverNames() {
        return Collections.unmodifiableList(this._riverNames);
    }

    public List<String> getReachNames() {
        return Collections.unmodifiableList(this._reachNames);
    }

    public List<String> getRiverStations() {
        return Collections.unmodifiableList(this._riverStations);
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("Flow Table { Plan Name: \"");
        toReturn.append(this._planName);
        toReturn.append("\", River Name[s]: \"");
        toReturn.append(this._riverNames);
        toReturn.append("\", Reach Name[s]: \"");
        toReturn.append(this._reachNames);
        toReturn.append("\"");
        return toReturn.toString();
    }

    public static void checkRASTableValue(double val, String rasParam, String river, String reach, String station) throws WQException {
        if (RMAConst.isUndefinedValue((double)val) || val < 0.0) {
            throw new WQException("Undefined or negative cross-sectional " + rasParam + " at or near River: " + river + ", Reach: " + reach + ", Station:" + station);
        }
    }
}

