/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.flowtable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlowTableLocationTemplate {
    public static final String STRING_FORMAT = "FlowTableLocationTemplate{_riverName='%s', _reachName='%s', _riverStation='%s'}";
    private final String _riverName;
    private final String _reachName;
    private final String _riverStation;

    public FlowTableLocationTemplate(@JsonProperty(value="riverName") String riverName, @JsonProperty(value="reachName") String reachName, @JsonProperty(value="riverStation") String riverStation) {
        this._riverName = riverName;
        this._reachName = reachName;
        this._riverStation = riverStation;
    }

    FlowTableLocationTemplate(String fromString) {
        String regex = STRING_FORMAT.replace("{", "\\{").replace("}", "\\}").replace("%s", "(.*)");
        Matcher m = Pattern.compile(regex).matcher(fromString);
        boolean matches = m.matches();
        this._riverName = m.group(1);
        this._reachName = m.group(2);
        this._riverStation = m.group(3);
    }

    public String getReachName() {
        return this._reachName;
    }

    public String getRiverStation() {
        return this._riverStation;
    }

    public String getRiverName() {
        return this._riverName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowTableLocationTemplate that = (FlowTableLocationTemplate)o;
        return Objects.equals(this._reachName, that._reachName) && Objects.equals(this._riverStation, that._riverStation) && Objects.equals(this._riverName, that._riverName);
    }

    public int hashCode() {
        return Objects.hash(this._reachName, this._riverStation, this._riverName);
    }

    @JsonValue
    public String toString() {
        return String.format(STRING_FORMAT, this._riverName, this._reachName, this._riverStation);
    }

    public static class Deserializer
    extends KeyDeserializer {
        private ObjectMapper mapper = new ObjectMapper();

        public Object deserializeKey(String s, DeserializationContext deserializationContext) throws IOException {
            return new FlowTableLocationTemplate(s);
        }
    }

    public static class Serializer
    extends JsonSerializer<FlowTableLocationTemplate> {
        private ObjectMapper mapper = new ObjectMapper();

        public void serialize(FlowTableLocationTemplate value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            StringWriter writer = new StringWriter();
            this.mapper.writeValue((Writer)writer, (Object)value);
            gen.writeFieldName(writer.toString());
        }
    }
}

