/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.geometry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Arrays;
import rma.services.annotations.ServiceProvider;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQControlDevice {
    private int _id;
    private int _rssReleaseElemId;
    private int _numPortLevels;
    private double _bedElevation;
    private int[] _numPortsPerLevel;
    private double[] _portInvertElevation;
    private boolean[] _portGeomRectangular;
    private double[] _portHeight;
    private double[] _portWidth;
    private double[] _portDiameter;
    private int _parentOutletIdx;
    private int _childOutletIdx;

    @JsonCreator
    public WQControlDevice(@JsonProperty(value="id") int id, @JsonProperty(value="numPortLevels") int numPortLevels) {
        this._id = id;
        this._numPortLevels = numPortLevels;
        this._numPortsPerLevel = new int[numPortLevels];
        this._portInvertElevation = new double[numPortLevels];
        this._portGeomRectangular = new boolean[numPortLevels];
        this._portHeight = new double[numPortLevels];
        this._portWidth = new double[numPortLevels];
        this._portDiameter = new double[numPortLevels];
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getRssReleaseElemId() {
        return this._rssReleaseElemId;
    }

    public void setRssReleaseElemId(int _rssReleaseElemId) {
        this._rssReleaseElemId = _rssReleaseElemId;
    }

    public int getNumPortLevels() {
        return this._numPortLevels;
    }

    public void setNumPortLevels(int numPortLevels) {
        this._numPortLevels = numPortLevels;
    }

    public double getBedElevation() {
        return this._bedElevation;
    }

    public void setBedElevation(double bedElevation) {
        this._bedElevation = bedElevation;
    }

    public int[] getNumPortsPerLevel() {
        return this._numPortsPerLevel;
    }

    public void setNumPortsPerLevel(int[] numPortsPerLevel) {
        this._numPortsPerLevel = numPortsPerLevel;
    }

    public double[] getPortInvertElevation() {
        return this._portInvertElevation;
    }

    public void setPortInvertElevation(double[] portInvertElevation) {
        this._portInvertElevation = portInvertElevation;
    }

    public boolean[] getPortGeomRectangular() {
        return this._portGeomRectangular;
    }

    public void setPortGeomRectangular(boolean[] portGeomRectangular) {
        this._portGeomRectangular = portGeomRectangular;
    }

    public double[] getPortHeight() {
        return this._portHeight;
    }

    public void setPortHeight(double[] portHeight) {
        this._portHeight = portHeight;
    }

    public double[] getPortWidth() {
        return this._portWidth;
    }

    public void setPortWidth(double[] portWidth) {
        this._portWidth = portWidth;
    }

    public double[] getPortDiameter() {
        return this._portDiameter;
    }

    public void setPortDiameter(double[] portDiameter) {
        this._portDiameter = portDiameter;
    }

    public int getParentOutletIdx() {
        return this._parentOutletIdx;
    }

    public void setParentOutletIdx(int parentOutletIdx) {
        this._parentOutletIdx = parentOutletIdx;
    }

    public int getChildOutletIdx() {
        return this._childOutletIdx;
    }

    public void setChildOutletIdx(int childOutletIdx) {
        this._childOutletIdx = childOutletIdx;
    }

    @JsonIgnore
    public double[] getPortAreas() {
        double[] areas = new double[this._numPortLevels];
        for (int j = 0; j < this._numPortLevels; ++j) {
            areas[j] = this._portGeomRectangular[j] ? this._portHeight[j] * this._portWidth[j] : 0.7853981633974483 * this._portDiameter[j] * this._portDiameter[j];
        }
        return areas;
    }

    public double[] evenlyDistributeFlows(double totalFlow, int numInlets, int numSubmergedInlets) {
        double[] flows = new double[numInlets];
        double evenFlow = totalFlow / (double)numSubmergedInlets;
        Arrays.fill(flows, 0.0);
        for (int j = 0; j < numSubmergedInlets; ++j) {
            flows[j] = evenFlow;
        }
        return flows;
    }

    public double[] generateConstantFlows(double constantFlow, int numInlets, int numSubmergedInlets) {
        double[] flows = new double[numInlets];
        Arrays.fill(flows, 0.0);
        for (int j = 0; j < numSubmergedInlets; ++j) {
            flows[j] = constantFlow;
        }
        return flows;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQControlDevice.class);
        }
    }
}

