/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Entry<K, V> {
    private final K _key;
    private V _value = null;

    @JsonCreator
    public Entry(@JsonProperty(value="key") K key) {
        this._key = key;
    }

    public Entry(K key, V value) {
        this._key = key;
        this._value = value;
    }

    @JsonTypeIdResolver(value=TypeResolver.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    public K getKey() {
        return this._key;
    }

    @JsonTypeIdResolver(value=TypeResolver.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    public V getValue() {
        return this._value;
    }

    public V setValue(V value) {
        V old = this._value;
        this._value = value;
        return old;
    }

    public static <K, V> List<Entry<K, V>> fromMapEntries(Collection<Map.Entry<K, V>> mapEntries) {
        List<Entry<K, V>> retval = Collections.emptyList();
        if (mapEntries != null) {
            retval = mapEntries.stream().map(me -> new Entry(me.getKey(), me.getValue())).collect(Collectors.toList());
        }
        return retval;
    }

    public static <K, V> List<Entry<K, V>> fromMap(Map<K, V> map) {
        List<Entry<K, V>> retval = Collections.emptyList();
        if (map != null) {
            retval = Entry.fromMapEntries(map.entrySet());
        }
        return retval;
    }

    public static <K, V> void setEntries(Map<K, V> map, Collection<Entry<K, V>> entries) {
        map.clear();
        if (entries != null) {
            for (Entry<K, V> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

