/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MissingTypeHandler
extends DeserializationProblemHandler {
    public static final Logger logger = Logger.getLogger(MissingTypeHandler.class.getName());
    private List<Class<?>> ignore = null;

    public MissingTypeHandler() {
    }

    public MissingTypeHandler(List<Class<?>> toIgnore) {
        this.ignore = toIgnore;
    }

    public MissingTypeHandler(Class<?>[] toIgnore) {
        if (toIgnore != null && toIgnore.length > 0) {
            this.ignore = Arrays.asList(toIgnore);
        }
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) {
        if ("@type".equals(propertyName)) {
            if (this.ignore == null || !this.ignore.contains(beanOrClass.getClass())) {
                logger.log(Level.SEVERE, "A handler was not found for the {0} property while deserializing: {1}:{2}. This condition typically indicates that the serviceAnnotations.jar dependency is missing from the classpath or that annotation processing was not enabled during the build. ", new Object[]{propertyName, beanOrClass.getClass().getSimpleName(), beanOrClass});
            }
        } else {
            logger.log(Level.WARNING, "Ignoring unknown property {0} while deserializing: {1}:{2}", new Object[]{propertyName, beanOrClass.getClass().getSimpleName(), beanOrClass});
        }
        return true;
    }
}

