/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import hec.data.ParamDouble;
import hec.data.Units;
import hec.io.PairedDataContainer;
import hec.wqenginecore.jackson.MissingTypeHandler;
import hec.wqenginecore.jackson.PairedDataContainerMixin;
import hec.wqenginecore.jackson.ParamDoubleDeserializer;
import hec.wqenginecore.jackson.ParamDoubleSerializer;
import hec.wqenginecore.jackson.RelativePathDeserializer;
import hec.wqenginecore.jackson.RelativePathSerializer;
import hec.wqenginecore.jackson.UnderbarNamingStrategy;
import hec.wqenginecore.jackson.UnitsDeserializer;
import hec.wqenginecore.jackson.UnitsSerializer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;

public class ObjectMapperUtil {
    public static final Logger logger = Logger.getLogger(ObjectMapperUtil.class.getName());

    private ObjectMapperUtil() {
    }

    public static ObjectMapper getNewObjectMapper() {
        return ObjectMapperUtil.getNewObjectMapper(new MissingTypeHandler());
    }

    public static ObjectMapper getNewObjectMapper(String basePath) {
        return ObjectMapperUtil.getNewObjectMapper(basePath, null);
    }

    public static ObjectMapper getNewObjectMapper(String basePath, Class<?>[] toIgnore) {
        MissingTypeHandler handler = new MissingTypeHandler(toIgnore);
        ObjectMapper mapper = ObjectMapperUtil.getNewObjectMapper(handler);
        if (basePath != null && !basePath.isEmpty()) {
            Path basepath = Paths.get(basePath, new String[0]);
            SimpleModule module = ObjectMapperUtil.buildRelativePathModule(basepath);
            mapper.registerModule((Module)module);
        }
        return mapper;
    }

    private static ObjectMapper getNewObjectMapper(MissingTypeHandler missingTypeHandler) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setConfig(((SerializationConfig)mapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).with(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS));
        mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new UnderbarNamingStrategy());
        List foundModules = ObjectMapper.findModules();
        mapper.registerModules((Iterable)foundModules);
        mapper.registerModule((Module)ObjectMapperUtil.buildUnitsModule());
        if (missingTypeHandler != null) {
            mapper.addHandler((DeserializationProblemHandler)missingTypeHandler);
        }
        mapper.addMixIn(PairedDataContainer.class, PairedDataContainerMixin.class);
        return mapper;
    }

    protected static SimpleModule buildRelativePathModule(Path basepath) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Path.class, (JsonSerializer)new RelativePathSerializer(basepath));
        simpleModule.addDeserializer(Path.class, (JsonDeserializer)new RelativePathDeserializer(basepath));
        return simpleModule;
    }

    protected static SimpleModule buildUnitsModule() {
        SimpleModule unitsModule = new SimpleModule();
        unitsModule.addDeserializer(Units.class, (JsonDeserializer)new UnitsDeserializer());
        unitsModule.addSerializer(Units.class, (JsonSerializer)new UnitsSerializer());
        unitsModule.addDeserializer(ParamDouble.class, (JsonDeserializer)new ParamDoubleDeserializer());
        unitsModule.addSerializer(ParamDouble.class, (JsonSerializer)new ParamDoubleSerializer());
        return unitsModule;
    }
}

