/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public abstract class PairedDataContainerMixin {
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String watershed;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String fullName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    double[] xOrdinates;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    double[][] yOrdinates;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean storedAsdoubles;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean storeAsDoubles;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean modified;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean labelsUsed;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean switchXyAxis;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ValidFilter.class)
    double datum;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ValidFilter.class)
    double shift;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ValidFilter.class)
    double offset;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean xOrdinate;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean yOrdinate;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    boolean zOrdinate;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int dataType;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int lastWriteTimeMillis;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int coordinateSystem;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int coordinateID;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int horizontalUnits;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int numberCurves;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int numberOrdinates;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int fileLastWriteTimeMillis;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int startingCurve;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int endingCurve;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int startingOrdinate;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int endingOrdinate;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int xprecision;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int yprecision;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    int writeMethod;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ValidFilter.class)
    int transformType;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String location;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String version;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String subVersion;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String fileName;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NotSetFilter.class)
    String horizontalDatum;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NotSetFilter.class)
    String verticalUnits;
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NotSetFilter.class)
    String verticalDatum;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String locationTimezone;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String xunits;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String yunits;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String xtype;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String ytype;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String xparameter;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String yparameter;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String other;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    String date;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String name;

    @JsonIgnore
    public abstract double[] getXOridnates();

    @JsonIgnore
    public abstract double[][] getYOridnates();

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public abstract boolean getStoreAsDoubles();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract String getName();

    @JsonIgnore
    public String getAsString() {
        return null;
    }

    @JsonIgnore
    public String getAsXML() {
        return null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Map<String, String> getSupplementalInfo();

    public static class NotSetFilter {
        public boolean equals(Object o) {
            boolean retval = false;
            if (o == null) {
                retval = true;
            } else if (o instanceof String) {
                String input = (String)o;
                retval = input.isEmpty() || "NOT SET".equalsIgnoreCase(input);
            }
            return retval;
        }
    }

    public static class ValidFilter {
        public boolean equals(Object o) {
            boolean retval = false;
            if (o == null) {
                retval = true;
            } else if (o instanceof Integer) {
                retval = !NumericalConstants.isValidValue((double)((Integer)o).intValue());
            } else if (o instanceof Double) {
                retval = !NumericalConstants.isValidValue((Double)((Double)o));
            }
            return retval;
        }
    }
}

