/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import hec.data.ParamDouble;
import hec.wqenginecore.jackson.UnitsDeserializer;
import java.io.IOException;
import java.util.logging.Logger;

public class ParamDoubleDeserializer
extends StdDeserializer<ParamDouble> {
    public static final Logger logger = Logger.getLogger(UnitsDeserializer.class.getName());

    public ParamDoubleDeserializer() {
        this(ParamDouble.class);
    }

    protected ParamDoubleDeserializer(Class<?> vc) {
        super(vc);
    }

    public ParamDouble deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ParamDouble retval = new ParamDouble();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode unitNode = node.get("unitSystem");
        if (unitNode != null) {
            retval.setUnitSystem(unitNode.asInt());
        }
        JsonNode vNode = node.get("value");
        retval.setValue(vNode.doubleValue());
        JsonNode pNode = node.get("parameterId");
        retval.setParameterId(pNode.asInt());
        JsonNode preNode = node.get("precision");
        retval.setPrecision(preNode.intValue());
        return retval;
    }
}

