/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class RelativePathDeserializer
extends StdDeserializer<Path> {
    private Path _basePath;

    public RelativePathDeserializer(Path basePath) {
        super(Path.class);
        if (!Objects.nonNull(basePath)) {
            throw new IllegalArgumentException("Invalid base path in RelativePathDeserializer: Base Paths cannot be null");
        }
        if (!basePath.isAbsolute()) {
            throw new IllegalArgumentException("Invalid Path in RelativePathDeserializer: Base Paths must be absolute");
        }
        this._basePath = basePath;
    }

    private RelativePathDeserializer(Class<?> vc, Path basePath) {
        super(vc);
        if (!Objects.nonNull(basePath)) {
            throw new IllegalArgumentException("Invalid base path in RelativePathDeserializer: Base Paths cannot be null");
        }
        if (!basePath.isAbsolute()) {
            throw new IllegalArgumentException("Invalid Path in RelativePathDeserializer: Base Paths must be absolute");
        }
        this._basePath = basePath;
    }

    private RelativePathDeserializer(JavaType valueType, Path basePath) {
        super(valueType);
        if (!Objects.nonNull(basePath)) {
            throw new IllegalArgumentException("Invalid base path in RelativePathDeserializer: Base Paths cannot be null");
        }
        if (!basePath.isAbsolute()) {
            throw new IllegalArgumentException("Invalid Path in RelativePathDeserializer: Base Paths must be absolute");
        }
        this._basePath = basePath;
    }

    private RelativePathDeserializer(StdDeserializer<?> src, Path basePath) {
        super(src);
        if (!Objects.nonNull(basePath)) {
            throw new IllegalArgumentException("Invalid base path in RelativePathDeserializer: Base Paths cannot be null");
        }
        if (!basePath.isAbsolute()) {
            throw new IllegalArgumentException("Invalid Path in RelativePathDeserializer: Base Paths must be absolute");
        }
        this._basePath = basePath;
    }

    public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node == null) {
            return null;
        }
        String text = node.asText("");
        if (text.isEmpty()) {
            return null;
        }
        Path p = Paths.get(text, new String[0]);
        if (p.isAbsolute()) {
            return p;
        }
        return this._basePath.resolve(p).normalize();
    }
}

