/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

public class RelativePathSerializer
extends StdSerializer<Path> {
    private final Path _basePath;

    public RelativePathSerializer(Path basePath) {
        super(Path.class);
        if (!Objects.nonNull(basePath)) {
            throw new IllegalArgumentException("Invalid base path in RelativePathSerializer: Base Paths cannot be null");
        }
        if (!basePath.isAbsolute()) {
            throw new IllegalArgumentException("Invalid base path in RelativePathSerializer: Base Paths must be absolute");
        }
        this._basePath = basePath;
    }

    public void serialize(Path pathVariable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (pathVariable == null || pathVariable.toString().isEmpty()) {
            jsonGenerator.writeString("");
            return;
        }
        String relativePath = pathVariable.toString();
        if (pathVariable.isAbsolute() && pathVariable.startsWith(this._basePath)) {
            relativePath = this._basePath.relativize(pathVariable).toString();
        }
        jsonGenerator.writeString(relativePath);
    }
}

