/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class TypeResolver
extends TypeIdResolverBase {
    Map<String, Class<?>> _idToTypeMap = new HashMap();
    Map<Class<?>, String> _typeToId = new HashMap();
    JavaType _superType;

    public TypeResolver() {
        ServiceLoader<TypeResolverRegistration> load = ServiceLoader.load(TypeResolverRegistration.class);
        for (TypeResolverRegistration registration : load) {
            this._idToTypeMap.put(registration.getTypeId(), registration.getTypeClass());
            this._typeToId.put(registration.getTypeClass(), registration.getTypeId());
        }
    }

    public void init(JavaType baseType) {
        this._superType = baseType;
    }

    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    public String idFromValueAndType(Object o, Class<?> aClass) {
        return this._typeToId.get(aClass);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        Class<?> subType = this._idToTypeMap.get(id);
        return context.constructSpecializedType(this._superType, subType);
    }

    public boolean containsTypeId(String id) {
        return this._idToTypeMap.containsKey(id);
    }

    public boolean containsTypeIds(Collection<String> ids) {
        return this._idToTypeMap.keySet().containsAll(ids);
    }

    public boolean containsType(Class<?> clazz) {
        return this._typeToId.containsKey(clazz);
    }

    public Class<?> getType(String id) {
        return this._idToTypeMap.get(id);
    }

    public String getTypeId(Class<?> clazz) {
        return this._typeToId.get(clazz);
    }

    public static interface TypeResolverRegistration {
        public Class<?> getTypeClass();

        public String getTypeId();
    }

    public static abstract class BaseRegistration
    implements TypeResolverRegistration {
        private Class<?> _class;

        protected BaseRegistration() {
            this._class = this.getClass().getEnclosingClass();
        }

        protected BaseRegistration(Class<?> klass) {
            this._class = klass;
        }

        protected void setClass(Class<?> klass) {
            this._class = klass;
        }

        @Override
        public Class<?> getTypeClass() {
            return this._class;
        }

        @Override
        public String getTypeId() {
            return this._class.getSimpleName();
        }
    }
}

