/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import java.lang.reflect.Field;

public class UnderbarNamingStrategy
extends PropertyNamingStrategy {
    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        String retval = defaultName;
        Class declaringClass = field.getDeclaringClass();
        if (defaultName != null && defaultName.startsWith("_")) {
            try {
                Field field1 = declaringClass.getDeclaredField(defaultName);
                if (field1 != null) {
                    retval = this.removeBar(defaultName);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return retval;
    }

    private String removeBar(String defaultName) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(defaultName.charAt(1)));
        if (defaultName.length() > 2) {
            sb.append(defaultName.substring(2));
        }
        return sb.toString();
    }
}

