/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Units;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnitsDeserializer
extends StdDeserializer<Units> {
    public static final Logger logger = Logger.getLogger(UnitsDeserializer.class.getName());

    public UnitsDeserializer() {
        this(Units.class);
    }

    protected UnitsDeserializer(Class<?> vc) {
        super(vc);
    }

    public Units deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode unitNode = node.get("units");
        String units = unitNode.asText();
        Units retval = null;
        try {
            retval = new Units(units);
        }
        catch (DataSetIllegalArgumentException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Unexpected Exception", e);
        }
        return retval;
    }
}

