/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.utility;

import hec.wqenginecore.utility.CustomClassLoader;
import hec.wqenginecore.utility.Unloadable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderLibraryLoader
implements Unloadable {
    public static final Logger logger = Logger.getLogger(ClassLoaderLibraryLoader.class.getName());
    private Unloadable _delegate;

    @Override
    public Set<String> load(List<String> libs) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        CustomClassLoader classLoader = new CustomClassLoader();
        Class<?> libLoader = null;
        try {
            libLoader = classLoader.findClass("hec.wqenginecore.utility.TrackingLoader");
            this._delegate = (Unloadable)libLoader.newInstance();
            retval.addAll(this._delegate.load(libs));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.log(Level.WARNING, "Unexpected Exception", e);
        }
        return retval;
    }

    @Override
    public Set<String> unload() {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        if (this._delegate != null) {
            retval.addAll(this._delegate.unload());
            this._delegate = null;
        }
        return retval;
    }

    protected void finalize() {
        if (this._delegate != null) {
            logger.info("Finalize attempting to unload.");
            Set<String> unloaded = this.unload();
            logger.log(Level.INFO, "Finalize unloaded: {0}", unloaded);
        }
    }
}

