/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.utility;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CustomClassLoader
extends ClassLoader {
    private Map<String, Class<?>> classes = new HashMap();

    public String toString() {
        return CustomClassLoader.class.getName();
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classData;
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        try {
            classData = this.loadClassData(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Class [" + name + "] could not be found", e);
        }
        Class<?> c = this.defineClass(name, classData, 0, classData.length);
        this.resolveClass(c);
        this.classes.put(name, c);
        return c;
    }

    private byte[] loadClassData(String name) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            name = ((String)name).replace(".", "/") + ".class";
            try (BufferedInputStream in = new BufferedInputStream(ClassLoader.getSystemResourceAsStream((String)name));){
                int i;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

