/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.utility;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NativeLibraryLoader {
    public static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static final Field loadedLibraryNames = NativeLibraryLoader.getAccessibleField("loadedLibraryNames");
    private static final Field nativeLibraries = NativeLibraryLoader.getAccessibleField("nativeLibraries");
    private static final Class<?> nativeLibrary = NativeLibraryLoader.getNativeLibraryClass();
    private static final Field nativeLibraryName = NativeLibraryLoader.getAccessibleField("name", nativeLibrary);
    private static final Method nativeLibraryFinalize = NativeLibraryLoader.getAccessibleMethod("finalize", nativeLibrary);

    private static Method getAccessibleMethod(String name, Class<?> nativeLibrary) {
        Method retval = null;
        try {
            retval = nativeLibrary.getDeclaredMethod(name, new Class[0]);
            retval.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, "Unexpected Exception", e);
        }
        return retval;
    }

    private static Field getAccessibleField(String fieldName) {
        Class<ClassLoader> sourceClazz = ClassLoader.class;
        return NativeLibraryLoader.getAccessibleField(fieldName, sourceClazz);
    }

    private static Field getAccessibleField(String fieldName, Class sourceClazz) {
        Field loadedLibraryNamesTemp = null;
        if (sourceClazz != null) {
            try {
                loadedLibraryNamesTemp = sourceClazz.getDeclaredField(fieldName);
                loadedLibraryNamesTemp.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.WARNING, "Unexpected Exception", e);
            }
        }
        return loadedLibraryNamesTemp;
    }

    public static Class<?> getNativeLibraryClass() {
        Class<?> nativeLibrary = null;
        for (Class<?> nested : ClassLoader.class.getDeclaredClasses()) {
            if (!nested.getSimpleName().equals("NativeLibrary")) continue;
            nativeLibrary = nested;
            break;
        }
        return nativeLibrary;
    }

    public static void loadLibraries(String[] libnames) {
        for (String libname : libnames) {
            try {
                logger.log(Level.FINE, "Calling System.loadLibrary({0})", libname);
                System.loadLibrary(libname);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error attempting to load:{0} from {1}", new Object[]{libname, System.getProperty("java.library.path")});
                throw e;
            }
        }
    }

    public static void unloadAllLibraries(ClassLoader classLoader) {
        try {
            List<Object> nativeLibraries = NativeLibraryLoader.getNativeLibraries(classLoader);
            for (Object nativeLibrary : nativeLibraries) {
                NativeLibraryLoader.unloadLibrary(nativeLibrary);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error unloading native resources.", e);
        }
    }

    public void unloadLibraries() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.unloadLibraries(classLoader);
    }

    public void unloadLibraries(ClassLoader classLoader) {
        try {
            List<Object> classLibraries = NativeLibraryLoader.getNativeLibraries(classLoader);
            for (Object classLibrary : classLibraries) {
                NativeLibraryLoader.unloadLibrary(classLibrary);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error unloading native resources.", e);
        }
    }

    public static List<Object> getNativeLibraries(ClassLoader classLoader) throws IllegalAccessException {
        return (List)nativeLibraries.get(classLoader);
    }

    public static List<String> getLoadedLibraryNames() {
        Vector retval = Collections.emptyList();
        try {
            retval = (Vector)loadedLibraryNames.get(null);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Unexpected Exception", e);
        }
        return retval;
    }

    public static void unloadLibrary(Object nativeLibrary) throws InvocationTargetException, IllegalAccessException {
        String name = NativeLibraryLoader.getNativeLibraryName(nativeLibrary);
        if (name != null) {
            logger.log(Level.FINE, "Calling NativeLibrary.finalize({0})");
        }
        nativeLibraryFinalize.invoke(nativeLibrary, new Object[0]);
    }

    public static String getNativeLibraryName(Object nativeLibrary) {
        String name = null;
        if (nativeLibrary != null) {
            Object nameValue = null;
            try {
                nameValue = nativeLibraryName.get(nativeLibrary);
                if (nameValue instanceof String) {
                    name = (String)nameValue;
                }
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, "Unexpected Exception", e);
            }
        }
        return name;
    }

    public static List<String> getNativeLibraryNames(ClassLoader classLoader) {
        List<String> retval = Collections.emptyList();
        List<Object> nativeLibraries = null;
        try {
            nativeLibraries = NativeLibraryLoader.getNativeLibraries(classLoader);
            retval = NativeLibraryLoader.getNativeLibraryNames(nativeLibraries);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Unexpected Exception", e);
        }
        return retval;
    }

    public static List<String> getNativeLibraryNames(List<Object> nativeLibraries) {
        List<String> names = new ArrayList<String>();
        if (nativeLibraries != null) {
            names = nativeLibraries.stream().filter(Objects::nonNull).map(NativeLibraryLoader::getNativeLibraryName).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return names;
    }
}

