/*
 * Decompiled with CFR 0.152.
 */
package hec.wqenginecore.utility;

import hec.wqenginecore.utility.NativeLibraryLoader;
import hec.wqenginecore.utility.Unloadable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrackingLoader
implements Unloadable {
    public static final Logger logger = Logger.getLogger(TrackingLoader.class.getName());
    private Set<String> loaded = new LinkedHashSet<String>();
    private Map<String, Set<String>> nameMap = new LinkedHashMap<String, Set<String>>();
    private ClassLoader classLoader = TrackingLoader.class.getClassLoader();

    @Override
    public Set<String> load(List<String> libnames) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        if (libnames != null && !libnames.isEmpty()) {
            for (String libname : libnames) {
                Set<String> names = this.loadLibrary(libname);
                if (names == null || names.isEmpty()) {
                    this.loaded.addAll(names);
                    retval.addAll(names);
                }
                this.nameMap.putIfAbsent(libname, names);
                this.loaded.addAll(names);
                retval.addAll(names);
            }
        }
        return retval;
    }

    public Set<String> loadLibrary(String libname) {
        List<String> alreadyLoaded = NativeLibraryLoader.getNativeLibraryNames(this.classLoader);
        try {
            logger.log(Level.FINE, "Calling System.loadLibrary({0})", libname);
            System.loadLibrary(libname);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error attempting to load:{0} from {1}", new Object[]{libname, System.getProperty("java.library.path")});
            throw e;
        }
        List<String> after = NativeLibraryLoader.getNativeLibraryNames(this.classLoader);
        LinkedHashSet<String> justLoaded = new LinkedHashSet<String>(after);
        justLoaded.removeAll(alreadyLoaded);
        return justLoaded;
    }

    @Override
    public Set<String> unload() {
        return this.unloadLibraries(this.classLoader);
    }

    public Set<String> unloadLibraries(ClassLoader classLoader) {
        LinkedHashSet<String> unloaded = new LinkedHashSet<String>();
        List<Object> nativeLibraries = null;
        try {
            nativeLibraries = NativeLibraryLoader.getNativeLibraries(classLoader);
            for (int i = nativeLibraries.size() - 1; i >= 0; --i) {
                Object nativeLibrary = nativeLibraries.get(i);
                String name = NativeLibraryLoader.getNativeLibraryName(nativeLibrary);
                if (!this.loaded.contains(name)) continue;
                String unloadedName = this.unloadLibrary(nativeLibrary, name);
                unloaded.add(unloadedName);
            }
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception", e);
        }
        return unloaded;
    }

    public String unloadLibrary(Object nativeLibrary, String name) {
        try {
            NativeLibraryLoader.unloadLibrary(nativeLibrary);
            this.loaded.remove(name);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error unloading native resources.", e);
        }
        return name;
    }
}

