/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;

class DouglasPeuckerLineSimplifier {
    private Coordinate[] pts;
    private boolean[] usePt;
    private double distanceTolerance;
    private LineSegment seg = new LineSegment();

    public static Coordinate[] simplify(Coordinate[] pts, double distanceTolerance) {
        DouglasPeuckerLineSimplifier simp = new DouglasPeuckerLineSimplifier(pts);
        simp.setDistanceTolerance(distanceTolerance);
        return simp.simplify();
    }

    public DouglasPeuckerLineSimplifier(Coordinate[] pts) {
        this.pts = pts;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public Coordinate[] simplify() {
        this.usePt = new boolean[this.pts.length];
        for (int i = 0; i < this.pts.length; ++i) {
            this.usePt[i] = true;
        }
        this.simplifySection(0, this.pts.length - 1);
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < this.pts.length; ++i) {
            if (!this.usePt[i]) continue;
            coordList.add(new Coordinate(this.pts[i]));
        }
        return coordList.toCoordinateArray();
    }

    private void simplifySection(int i, int j) {
        int k;
        if (i + 1 == j) {
            return;
        }
        this.seg.p0 = this.pts[i];
        this.seg.p1 = this.pts[j];
        double maxDistance = -1.0;
        int maxIndex = i;
        for (k = i + 1; k < j; ++k) {
            double distance = this.seg.distance(this.pts[k]);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = k;
        }
        if (maxDistance <= this.distanceTolerance) {
            for (k = i + 1; k < j; ++k) {
                this.usePt[k] = false;
            }
        } else {
            this.simplifySection(i, maxIndex);
            this.simplifySection(maxIndex, j);
        }
    }
}

