/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.model.RunTimeWindow;
import hec.rss.client.RSimSimulationMode;
import hec.rss.plugins.w2.client.AltW2Panel;
import hec.rss.plugins.w2.client.DssOutEditor$1;
import hec.rss.plugins.w2.client.DssOutEditor$2;
import hec.rss.plugins.w2.client.DssOutEditor$3;
import hec.rss.plugins.w2.client.DssOutEditor$4;
import hec.rss.plugins.w2.client.DssOutEditor$5;
import hec.rss.plugins.w2.io.DssOutput;
import hec.rss.plugins.w2.model.DssOutData;
import hec.rss.plugins.w2.model.W2Model;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class DssOutEditor
extends RmaJDialog {
    private RmaJTextField _dssOutFileFld;
    private RmaJTextField _dssFileFld;
    private JLabel _dssFileLabel;
    private JLabel _startYrLabel;
    private RmaJIntegerField _startYearFld;
    private RmaJTable _mappingTable;
    private Identifier _id;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private DssOutput _dssOutput;
    private W2Model _model;
    private AltW2Panel _altPanel;
    private String _fpart = "";
    protected JMenu _editMenu;
    protected JMenuItem _insertRow;
    protected JMenuItem _deleteRow;
    protected JMenuItem _appendRow;

    public DssOutEditor(Dialog dialog, boolean bl, W2Model w2Model, AltW2Panel altW2Panel, Identifier identifier) {
        super(dialog, bl);
        this._id = identifier;
        this._model = w2Model;
        this._altPanel = altW2Panel;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(550, 280);
        DssOutEditor dssOutEditor = this;
        dssOutEditor.setLocationRelativeTo(dssOutEditor.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DssOut.npt Editor");
        new JLabel("Dssout.npt File:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._dssOutFileFld = new RmaJTextField();
        this._dssOutFileFld.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        Object[] objectArray = new JLabel("DSS File:");
        this._dssFileLabel = objectArray;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)objectArray, gridBagConstraints);
        this._dssFileFld = new RmaJTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._dssFileFld, gridBagConstraints);
        objectArray = new JLabel("Start Year:");
        this._startYrLabel = objectArray;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)objectArray, gridBagConstraints);
        this._startYearFld = new RmaJIntegerField();
        this._startYearFld.setMinValue(0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._startYearFld, gridBagConstraints);
        objectArray = new String[]{"", "W2 Output File", "ResSim Element/B Part", "Label"};
        DssOutEditor dssOutEditor = this;
        this._mappingTable = new DssOutEditor$1(dssOutEditor, (Component)((Object)dssOutEditor), objectArray);
        this._mappingTable.setColumnVisible(0, false, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._mappingTable.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.buildMenus();
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this._editMenu = new JMenu("Edit");
        this._insertRow = new JMenuItem("Insert Row(s)", 73);
        this._editMenu.add(this._insertRow);
        this._appendRow = new JMenuItem("Append Row", 65);
        this._editMenu.add(this._appendRow);
        this._deleteRow = new JMenuItem("Delete Row(s)", 68);
        this._editMenu.add(this._deleteRow);
        jMenuBar.add(this._editMenu);
        this.setJMenuBar(jMenuBar);
        this._insertRow.addActionListener(new DssOutEditor$2(this));
        this._appendRow.addActionListener(new DssOutEditor$3(this));
        this._deleteRow.addActionListener(new DssOutEditor$4(this));
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new DssOutEditor$5(this));
    }

    protected void saveForm() {
        this._mappingTable.commitEdit(true);
        int n = this._mappingTable.getRowCount();
        this._dssOutput.clearDssData();
        for (int i = 0; i < n; ++i) {
            Object object = this._mappingTable.getCell(i, 0);
            String string = (String)this._mappingTable.getCell(i, 1);
            String string2 = (String)this._mappingTable.getCell(i, 2);
            String string3 = (String)this._mappingTable.getCell(i, 3);
            if (!(object instanceof DssOutData)) {
                if (string.isEmpty()) continue;
                object = new DssOutData(string, string2, this._fpart, "deg-c");
            } else {
                object = (DssOutData)object;
                ((DssOutData)object).setOptFile(string);
                ((DssOutData)object).setBPart(string2);
                ((DssOutData)object).setUserLabel(string3);
            }
            this._dssOutput.add((DssOutData)object);
        }
        this._dssOutput.writeDssOutFile();
    }

    private void fillForm() {
        int n;
        Object object;
        this._mappingTable.deleteCells();
        this._dssOutput = new DssOutput(this._id);
        this._fpart = "";
        if (ClientApp.frame().getCurrentMode() instanceof RSimSimulationMode) {
            object = (RSimSimulationMode)ClientApp.frame().getCurrentMode();
            if ((object = object.getSimulation()) != null) {
                RunTimeWindow runTimeWindow = object.getRunTimeWindow();
                int n2 = runTimeWindow.getStartTime().year();
                this._startYearFld.setText(String.valueOf(n2));
                this._startYearFld.setEditable(false);
                if (this._dssOutput.getDssFile() == null) {
                    this._dssFileFld.setText(object.getOutputDSSFilePath());
                } else {
                    this._dssFileFld.setText(this._dssOutput.getDssFile());
                }
                this._dssFileFld.setEditable(false);
            } else {
                this._startYearFld.setEditable(true);
                this._dssFileFld.setEditable(true);
            }
            this._startYearFld.setVisible(false);
            this._startYrLabel.setVisible(false);
            this._dssFileFld.setVisible(false);
            this._dssFileLabel.setVisible(false);
            this._startYearFld.setEditable(false);
            this._dssFileFld.setEditable(false);
        } else {
            this._startYearFld.setVisible(false);
            this._startYrLabel.setVisible(false);
            this._dssFileFld.setVisible(false);
            this._dssFileLabel.setVisible(false);
            this._startYearFld.setEditable(false);
            this._dssFileFld.setEditable(false);
        }
        object = this._id.getPath();
        this._dssOutFileFld.setText((String)object);
        RMAIO.getDirectoryFromPath((String)object);
        this._altPanel.getExeDirectory();
        RmiFileManager cfr_ignored_0 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (!this._dssOutput.readDssOutFile()) {
            this._mappingTable.appendRow();
            return;
        }
        object = this._dssOutput.getDssOutData();
        if (object.size() == 0) {
            this._mappingTable.appendRow();
            return;
        }
        for (n = 0; n < object.size(); ++n) {
            Vector<Object> vector = new Vector<Object>(3);
            DssOutData dssOutData = (DssOutData)object.get(n);
            vector.add(dssOutData);
            vector.add(dssOutData.getOptFile());
            vector.add(dssOutData.getBPart());
            if (this._fpart.length() == 0 && dssOutData.getFPart() != null && dssOutData.getFPart().length() > 0) {
                this._fpart = dssOutData.getFPart();
            }
            vector.add(dssOutData.getUserLabel());
            this._mappingTable.appendRow(vector);
        }
        for (int i = n = this._mappingTable.getRowCount(); i < 3; ++i) {
            Vector<String> vector = new Vector<String>(3);
            vector.add("");
            vector.add("");
            vector.add("");
            this._mappingTable.appendRow(vector);
        }
    }
}

