/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.io.Identifier;
import hec.rss.plugins.w2.client.AltW2Panel;
import hec.rss.plugins.w2.client.HabitatVolumeEditor$1;
import hec.rss.plugins.w2.client.HabitatVolumeEditor$2;
import hec.rss.plugins.w2.client.HabitatVolumeEditor$3;
import hec.rss.plugins.w2.client.HabitatVolumeEditor$4;
import hec.rss.plugins.w2.io.HabitatControlFile;
import hec.rss.plugins.w2.model.FishGroup;
import hec.rss.plugins.w2.model.HabitatData;
import hec.rss.plugins.w2.model.W2Model;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class HabitatVolumeEditor
extends RmaJDialog {
    private RmaJTextField _w2OutputFileFld;
    private RmaJTable _habitatTable;
    protected JMenu _editMenu;
    protected JMenuItem _insertRow;
    protected JMenuItem _deleteRow;
    protected JMenuItem _appendRow;
    private Identifier _id;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private W2Model _model;
    private AltW2Panel _altPanel;
    private String _fpart = "";
    private HabitatData _habitatData;

    public HabitatVolumeEditor(Dialog dialog, boolean bl, W2Model w2Model, AltW2Panel altW2Panel) {
        super(dialog, bl);
        this._model = w2Model;
        this._altPanel = altW2Panel;
        this.buildControls();
        this.buildMenus();
        this.addListeners();
        this.fillForm(w2Model);
        this.pack();
        int cfr_ignored_0 = this.getPreferredSize().height;
        this.setSize(500, 300);
        HabitatVolumeEditor habitatVolumeEditor = this;
        habitatVolumeEditor.setLocationRelativeTo(habitatVolumeEditor.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Habitat Volume Editor");
        Object object = new JPanel(new GridBagLayout());
        Object object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 0;
        object2.weightx = 1.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 2;
        object2.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)object, object2);
        JLabel jLabel = new JLabel("W2 Habitat Output File:");
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 0;
        object2.weightx = 0.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 0;
        object2.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)jLabel, object2);
        this._w2OutputFileFld = new RmaJTextField();
        this._w2OutputFileFld.setEditable(true);
        object2.gridx = 1;
        object2.gridy = 0;
        object2.weightx = 1.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 2;
        object2.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._w2OutputFileFld, object2);
        object = new JPanel(new GridBagLayout());
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 1;
        object2.weightx = 1.0;
        object2.weighty = 1.0;
        object2.anchor = 18;
        object2.fill = 1;
        object2.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)object, object2);
        object2 = new String[]{"Fish Group", "Min Temperature\n(deg C)", "Max Temp\n(deg C)", "Min D.O.\n(mg/l)"};
        this._habitatTable = new RmaJTable((Component)((Object)this), object2);
        this._habitatTable.setMlHeaderRenderer();
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 0;
        object2.weightx = 1.0;
        object2.weighty = 1.0;
        object2.anchor = 18;
        object2.fill = 1;
        object2.insets = new Insets(15, 5, 5, 5);
        ((Container)object).add((Component)this._habitatTable.getScrollPane(), object2);
        this._habitatTable.setNumRows(3);
        object = new int[]{100, 50, 50, 50};
        this._habitatTable.setColumnWidths((int[])object);
        this._habitatTable.setDoubleCellEditor(1);
        this._habitatTable.setDoubleCellEditor(2);
        this._habitatTable.setDoubleCellEditor(3);
        this._habitatTable.setPrecision(1);
        this._cmdPanel = new ButtonCmdPanel(12);
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object2.gridy = 10;
        object2.weightx = 1.0;
        object2.weighty = 0.0;
        object2.anchor = 18;
        object2.fill = 2;
        object2.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, object2);
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new HabitatVolumeEditor$1(this));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this._editMenu = new JMenu("Edit");
        this._insertRow = new JMenuItem("Insert Row(s)", 73);
        this._editMenu.add(this._insertRow);
        this._appendRow = new JMenuItem("Append Row", 65);
        this._editMenu.add(this._appendRow);
        this._deleteRow = new JMenuItem("Delete Row(s)", 68);
        this._editMenu.add(this._deleteRow);
        jMenuBar.add(this._editMenu);
        this.setJMenuBar(jMenuBar);
        this._insertRow.addActionListener(new HabitatVolumeEditor$2(this));
        this._appendRow.addActionListener(new HabitatVolumeEditor$3(this));
        this._deleteRow.addActionListener(new HabitatVolumeEditor$4(this));
    }

    protected void saveForm() {
        this._habitatTable.commitEdit(true);
        int n = this._habitatTable.getRowCount();
        if (this._habitatData == null) {
            this._habitatData = new HabitatData("HabitatVolume");
        }
        ArrayList<FishGroup> arrayList = new ArrayList<FishGroup>();
        arrayList.clear();
        for (int i = 0; i < n; ++i) {
            Object object = (String)this._habitatTable.getValueAt(i, 0);
            if (((String)object).trim().length() <= 0) continue;
            FishGroup fishGroup = new FishGroup((String)object);
            object = this._habitatTable.getValueAt(i, 1);
            fishGroup.setMinTemp(RMAIO.parseDouble((Object)object));
            object = this._habitatTable.getValueAt(i, 2);
            fishGroup.setMaxTemp(RMAIO.parseDouble((Object)object));
            object = this._habitatTable.getValueAt(i, 3);
            fishGroup.setMinDO(RMAIO.parseDouble((Object)object));
            arrayList.add(fishGroup);
        }
        String string = this._w2OutputFileFld.getText();
        this._habitatData.setOptFile(string);
        this._habitatData.setFishGroupList(arrayList);
        this._model.setHabitatData(this._habitatData);
    }

    private void fillForm(W2Model list) {
        int n;
        if (list == null) {
            return;
        }
        Vector<Object> vector = ((W2Model)((Object)list)).getDefaultDirectory() + "/w2_habitat.npt";
        vector = new HabitatControlFile((String)((Object)vector));
        Object object = null;
        if (((HabitatControlFile)((Object)vector)).readHabitatControlFile()) {
            object = ((HabitatControlFile)((Object)vector)).getHabitatVolumeData();
        }
        list = ((W2Model)((Object)list)).getHabitatData();
        this._habitatData = object;
        if (object == null && list != null) {
            this._habitatData = list;
        } else if (object != null && list != null && ((HabitatData)object).getNumberOfFishGroups() <= ((HabitatData)((Object)list)).getNumberOfFishGroups()) {
            this._habitatData = list;
        }
        if (this._habitatData != null) {
            this._w2OutputFileFld.setText(this._habitatData.getOptFile());
        }
        list = this._habitatData != null ? this._habitatData.getFishGroupList() : new ArrayList<FishGroup>();
        this._habitatTable.deleteCells();
        for (n = 0; n < list.size(); ++n) {
            vector = new Vector<Object>(5);
            object = list.get(n);
            vector.add(((FishGroup)object).getGroupName());
            vector.add(((FishGroup)object).getMinTemp());
            vector.add(((FishGroup)object).getMaxTemp());
            vector.add(((FishGroup)object).getMinDO());
            this._habitatTable.appendRow(vector);
        }
        for (int i = n = this._habitatTable.getRowCount(); i < 3; ++i) {
            vector = new Vector<String>(5);
            vector.add("");
            vector.add("");
            vector.add("");
            vector.add("");
            vector.add("");
            this._habitatTable.appendRow(vector);
        }
    }
}

