/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$1;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$2;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$3;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$4;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$5;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$6;
import hec.rss.plugins.w2.client.W2BcAssignmentsEditor$7;
import hec.rss.plugins.w2.model.W2Alt;
import hec.rss.plugins.w2.model.W2BcConnection;
import hec.rss.plugins.w2.model.W2Model;
import hec.rss.plugins.w2.model.W2OutputConnection;
import hec.rss.plugins.w2.model.W2flow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class W2BcAssignmentsEditor
extends RmaJDialog {
    protected static final int a = 0;
    protected static final int b = 1;
    protected static final int c = 2;
    protected static final int d = 3;
    protected static final int e = 4;
    protected static final int f = 3;
    private RmaJTable _mappingTable;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTextField _downStreamModelFld;
    private RmaJTextField _downStreamModelPathFld;
    RmiFileChooserField _tableUpstrmFileChooser;
    RmiFileChooserField _tableDwnstrmFileChooser;
    protected boolean _canceled;
    private W2Model _model;
    List<W2Model> _modelList;
    private W2Alt _w2Alt;
    private List<W2OutputConnection> _tsrMapping = new ArrayList<W2OutputConnection>();
    private Identifier _id;
    private String _modelDirectory;
    private String _exeDirectory;
    protected JMenu _editMenu;
    protected JMenuItem _insertRow;
    protected JMenuItem _deleteRow;
    protected JMenuItem _appendRow;

    public W2BcAssignmentsEditor(Dialog dialog, boolean bl, W2Model w2Model, List<W2Model> list, W2Alt w2Alt, String string, String string2) {
        super(dialog, bl);
        this._model = w2Model;
        this._modelList = list;
        this._modelDirectory = string;
        this._exeDirectory = string2;
        this._w2Alt = w2Alt;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(840, 480);
        W2BcAssignmentsEditor w2BcAssignmentsEditor = this;
        w2BcAssignmentsEditor.setLocationRelativeTo(w2BcAssignmentsEditor.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Link W2 Upstream Output to Downstream Model Input");
        new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        Object object = new JLabel("Downstream W2 Model:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)object, gridBagConstraints);
        this._downStreamModelFld = new RmaJTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._downStreamModelFld, gridBagConstraints);
        this._downStreamModelFld.setEditable(false);
        object = new JLabel("Downstream Directory:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)object, gridBagConstraints);
        this._downStreamModelPathFld = new RmaJTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._downStreamModelPathFld, gridBagConstraints);
        this._downStreamModelPathFld.setEditable(false);
        object = new String[]{"W2 Element", "Type", "Parameter", "Downstream File", "Upstream File"};
        W2BcAssignmentsEditor w2BcAssignmentsEditor = this;
        this._mappingTable = new W2BcAssignmentsEditor$1(w2BcAssignmentsEditor, (Component)((Object)w2BcAssignmentsEditor), (Object[])object);
        this._mappingTable.setTableHeader((JTableHeader)new GroupableTableHeader(this._mappingTable.getColumnModel()));
        this._mappingTable.setRowSorter(new TableRowSorter<TableModel>(this._mappingTable.getModel()));
        this._mappingTable.setColumnWidths(new int[]{80, 100, 80, 250, 250});
        this._mappingTable.setColumnEnabled(false, 0);
        this._mappingTable.setColumnEnabled(false, 1);
        this._mappingTable.setColumnEnabled(false, 2);
        this._mappingTable.setHorizontalAlignment(4, 4);
        object = this._mappingTable.getColumnModel();
        ColumnGroup columnGroup = new ColumnGroup("Link W2 Upstream Output to Downstream Input");
        columnGroup.add((Object)object.getColumn(0));
        columnGroup.add((Object)object.getColumn(1));
        columnGroup.add((Object)object.getColumn(2));
        columnGroup.add((Object)object.getColumn(3));
        columnGroup.add((Object)object.getColumn(4));
        object = (GroupableTableHeader)this._mappingTable.getTableHeader();
        object.addColumnGroup(columnGroup);
        this._tableUpstrmFileChooser = this.setFileChooserEditor(this._mappingTable, 4, new RMAFilenameFilter("*.opt", "upstrm files"));
        this._tableDwnstrmFileChooser = this.setFileChooserEditor(this._mappingTable, 3, new RMAFilenameFilter("*.npt", "dwnstrm files"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._mappingTable.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this._editMenu = new JMenu("Edit");
        this._insertRow = new JMenuItem("Insert Row(s)", 73);
        this._editMenu.add(this._insertRow);
        this._appendRow = new JMenuItem("Append Row", 65);
        this._editMenu.add(this._appendRow);
        this._deleteRow = new JMenuItem("Delete Row(s)", 68);
        this._editMenu.add(this._deleteRow);
        jMenuBar.add(this._editMenu);
        this.setJMenuBar(jMenuBar);
        this._insertRow.addActionListener(new W2BcAssignmentsEditor$2(this));
        this._appendRow.addActionListener(new W2BcAssignmentsEditor$3(this));
        this._deleteRow.addActionListener(new W2BcAssignmentsEditor$4(this));
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new W2BcAssignmentsEditor$5(this));
    }

    protected void saveForm() {
        this.saveBcMappingTable();
    }

    protected void saveBcMappingTable() {
        this._mappingTable.commitEdit(true);
        int n = this._mappingTable.getRowCount();
        n /= 4;
        int[] nArray = new int[]{1, 2, 3};
        String[] stringArray = new String[]{"Flow", "Temperature", "Cons"};
        ArrayList<W2BcConnection> arrayList = new ArrayList<W2BcConnection>();
        for (int i = 0; i < n; ++i) {
            int n2 = i << 2;
            String string = (String)this._mappingTable.getValueAt(n2, 0);
            this.getElementType(string);
            for (int j = 0; j < 3; ++j) {
                String string2;
                n2 = (i << 2) + 1 + j;
                String string3 = (String)this._mappingTable.getValueAt(n2, 2);
                string3.startsWith(stringArray[j]);
                int n3 = nArray[j];
                String string4 = string2 = (String)this._mappingTable.getValueAt(n2, 3);
                if (!RMAIO.isFullPath((String)string2)) {
                    string4 = RMAIO.makeAbsolutePath((String)this._modelDirectory, (String)string2);
                }
                string2 = this._w2Alt.getRelativePath(string4);
                Object object = (String)this._mappingTable.getValueAt(n2, 4);
                object = new W2BcConnection(string, n3, string2, (String)object);
                arrayList.add((W2BcConnection)object);
            }
        }
        this._model.setW2BcMapping(arrayList);
    }

    private void fillForm() {
        String string = "";
        String string2 = "";
        if (this._model != null) {
            string = this._model.getName();
            string2 = this._model.getDefaultDirectory();
        }
        this._downStreamModelFld.setText(string);
        this._downStreamModelPathFld.setText(string2);
        if (this._model != null && this._modelList != null && this._tableUpstrmFileChooser != null) {
            Object object;
            int n = -1;
            string2 = this._model.toString();
            for (int i = 0; i < this._modelList.size(); ++i) {
                object = this._modelList.get(i).toString();
                if (!string2.equals(object)) continue;
                n = i;
                break;
            }
            if (n <= 0) {
                System.out.println("W2BcAssignmentsEditor: Upstream Model not found " + n);
            }
            W2Model w2Model = this._modelList.get(n - 1);
            object = w2Model.getDefaultDirectory() + "/";
            this._tableUpstrmFileChooser.setDefaultPath((String)object);
            object = this._model.getDefaultDirectory() + "/";
            this._tableDwnstrmFileChooser.setDefaultPath((String)object);
        }
        this.fillMappingTable();
        this.updateTableWithMappingList();
        this.setModified(false);
    }

    private void fillMappingTable() {
        this._mappingTable.deleteCells();
        Object object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        List<W2flow> list = this._model.findflows(this._modelDirectory, this._exeDirectory, (RmiFileManager)object);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object object2 = list.get(i);
            if (!((W2flow)object2).getType().toLowerCase().startsWith("inflow")) continue;
            object = ((W2flow)object2).getName();
            int n2 = this.getElementType((String)object);
            String string = ((W2flow)object2).getPath();
            int n3 = string.toLowerCase().indexOf("qin");
            if (n3 < 0) {
                if (n2 == 2) {
                    string.toLowerCase().indexOf("tr");
                } else if (n2 == 3) {
                    string.toLowerCase().indexOf("qdt");
                }
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            object = new Vector(5);
            object2 = ((W2flow)object2).clone();
            ((Vector)object).add(((W2flow)object2).getName());
            ((Vector)object).add(((W2flow)object2).getDescription());
            this._mappingTable.appendRow((Vector)object);
            this._mappingTable.setRowBackground(n, Color.LIGHT_GRAY);
            this._mappingTable.setRowEnabled(false, n);
            object = new Vector<String>(5);
            ((Vector)object).add("");
            ((Vector)object).add("");
            ((Vector)object).add("Flow");
            ((Vector)object).add(((W2flow)object2).getPath());
            ((Vector)object).add("");
            this._mappingTable.appendRow((Vector)object);
            object = new Vector<String>(5);
            ((Vector)object).add("");
            ((Vector)object).add("");
            ((Vector)object).add("Temperature");
            object2 = "";
            ((Vector)object).add(object2);
            ((Vector)object).add("");
            this._mappingTable.appendRow((Vector)object);
            new Vector(3);
            object = new Vector<String>(5);
            ((Vector)object).add("");
            ((Vector)object).add("");
            ((Vector)object).add("Constituent Conc");
            object2 = "";
            ((Vector)object).add(object2);
            ((Vector)object).add("");
            this._mappingTable.appendRow((Vector)object);
            n += 4;
        }
    }

    protected void updateTableWithMappingList() {
        int n;
        W2BcConnection[] w2BcConnectionArray;
        Object object;
        List<W2BcConnection> list = this._model.getW2BcMapping();
        if (list == null || list.size() <= 0) {
            return;
        }
        HashMap<String, W2BcConnection[]> hashMap = new HashMap<String, W2BcConnection[]>();
        int n2 = list.size();
        block5: for (int i = 0; i < n2; ++i) {
            object = list.get(i);
            w2BcConnectionArray = (W2BcConnection[])hashMap.get(((W2BcConnection)object).getW2ElementName());
            if (w2BcConnectionArray == null) {
                w2BcConnectionArray = new W2BcConnection[3];
                hashMap.put(((W2BcConnection)object).getW2ElementName(), w2BcConnectionArray);
            }
            n = ((W2BcConnection)object).getBcType();
            switch (n) {
                case 1: {
                    w2BcConnectionArray[0] = object;
                    continue block5;
                }
                case 2: {
                    w2BcConnectionArray[1] = object;
                    continue block5;
                }
                case 3: {
                    w2BcConnectionArray[2] = object;
                }
            }
        }
        int n3 = this._mappingTable.getRowCount();
        n3 /= 4;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2 << 2;
            String string = (String)this._mappingTable.getValueAt(n, 0);
            w2BcConnectionArray = (W2BcConnection[])hashMap.get(string);
            if (w2BcConnectionArray == null) continue;
            for (int i = 0; i < 3; ++i) {
                n = (n2 << 2) + i + 1;
                object = w2BcConnectionArray[i];
                if (object == null) continue;
                String string2 = ((W2BcConnection)object).getW2DownstreamFile();
                object = ((W2BcConnection)object).getW2UpstreamFile();
                if (string2 != null && string2.length() > 0) {
                    string2 = this._w2Alt.makeAbsolutePath(string2);
                    string2 = RMAIO.getRelativePath((String)this._modelDirectory, (String)string2);
                    this._mappingTable.setValueAt((Object)string2, n, 3);
                }
                if (object == null || ((String)object).length() <= 0) continue;
                this._mappingTable.setValueAt(object, n, 4);
            }
        }
    }

    protected int getElementType(String string) {
        string = string.substring(0, 3);
        int n = 0;
        if (string.equals("qin")) {
            n = 1;
        } else if (string.equals("tr_")) {
            n = 2;
        } else if (string.equals("qdt")) {
            n = 3;
        }
        return n;
    }

    public RmiFileChooserField setFileChooserEditor(RmaJTable rmaJTable, int n, RMAFilenameFilter rMAFilenameFilter) {
        Object object = rmaJTable.getColumnModel();
        if (n >= object.getColumnCount() || n < 0) {
            return null;
        }
        object = rmaJTable.getColumnModel().getColumn(n);
        if (object == null) {
            return null;
        }
        RmiFileChooserField rmiFileChooserField = n == 3 ? new W2BcAssignmentsEditor$6(this) : new W2BcAssignmentsEditor$7(this);
        Vector<RMAFilenameFilter> vector = new Vector<RMAFilenameFilter>(1);
        vector.add(rMAFilenameFilter);
        rmiFileChooserField.setFilters(vector);
        rmiFileChooserField.addMouseListener((MouseListener)rmaJTable);
        rMAFilenameFilter = new RmaCellEditor((JTextField)rmiFileChooserField);
        rMAFilenameFilter.setClickCountToStart(rmaJTable.getClickCountToStart());
        ((TableColumn)object).setCellEditor((TableCellEditor)rMAFilenameFilter);
        rmaJTable.setHorizontalAlignment(2, n);
        if (rmaJTable.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)rmaJTable.getModel()).setColumnClass(n, Number.class);
        }
        return rmiFileChooserField;
    }
}

