/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.rss.client.RSimSimulationMode;
import hec.rss.plugins.w2.client.AltW2Panel;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$1;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$2;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$3;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$4;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$5;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$6;
import hec.rss.plugins.w2.client.W2OutputAssignmentsEditor$7;
import hec.rss.plugins.w2.io.DssOutput;
import hec.rss.plugins.w2.model.DssOutData;
import hec.rss.plugins.w2.model.W2Model;
import hec.rss.plugins.w2.model.W2OutputConnection;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class W2OutputAssignmentsEditor
extends RmaJDialog {
    private RmaJTable _mappingTable;
    private RmaJTable _tsrTable;
    private RmaJTable _profileTable;
    private Identifier _id;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private DssOutput _dssOutput;
    private W2Model _model;
    private AltW2Panel _altPanel;
    private String _fpart = "";
    private List<W2OutputConnection> _tsrMapping = new ArrayList<W2OutputConnection>();
    private List<W2OutputConnection> _profileMapping = new ArrayList<W2OutputConnection>();
    protected JMenu _editMenu;
    protected JMenuItem _insertRow;
    protected JMenuItem _deleteRow;
    protected JMenuItem _appendRow;

    public W2OutputAssignmentsEditor(Dialog dialog, boolean bl, W2Model w2Model, AltW2Panel altW2Panel, Identifier identifier) {
        super(dialog, bl);
        this._id = identifier;
        this._model = w2Model;
        this._altPanel = altW2Panel;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(550, 480);
        W2OutputAssignmentsEditor w2OutputAssignmentsEditor = this;
        w2OutputAssignmentsEditor.setLocationRelativeTo(w2OutputAssignmentsEditor.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DSS Output Editor");
        new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        Object[] objectArray = new JLabel("DSS Output Time Series:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)objectArray, gridBagConstraints);
        objectArray = new String[]{"", "W2 Output File", "ResSim Element/B Part", "Custom Label"};
        W2OutputAssignmentsEditor w2OutputAssignmentsEditor = this;
        this._mappingTable = new W2OutputAssignmentsEditor$1(w2OutputAssignmentsEditor, (Component)((Object)w2OutputAssignmentsEditor), objectArray);
        this._mappingTable.setColumnVisible(0, false, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._mappingTable.getScrollPane(), gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        objectArray = new JLabel("TSR or Habitat Output:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)objectArray, gridBagConstraints);
        objectArray = new String[]{"W2 TSR Output File", "ResSim Element/B Part", "Custom Label"};
        W2OutputAssignmentsEditor w2OutputAssignmentsEditor2 = this;
        this._tsrTable = new W2OutputAssignmentsEditor$2(w2OutputAssignmentsEditor2, (Component)((Object)w2OutputAssignmentsEditor2), objectArray);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._tsrTable.getScrollPane(), gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        objectArray = new JLabel("Vertical Profile Output:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)objectArray, gridBagConstraints);
        objectArray = new String[]{"W2 Profile Output File", "ResSim Element/B Part", "Custom Label"};
        W2OutputAssignmentsEditor w2OutputAssignmentsEditor3 = this;
        this._profileTable = new W2OutputAssignmentsEditor$3(w2OutputAssignmentsEditor3, (Component)((Object)w2OutputAssignmentsEditor3), objectArray);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._profileTable.getScrollPane(), gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.buildMenus();
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this._editMenu = new JMenu("Edit");
        this._insertRow = new JMenuItem("Insert Row(s)", 73);
        this._editMenu.add(this._insertRow);
        this._appendRow = new JMenuItem("Append Row", 65);
        this._editMenu.add(this._appendRow);
        this._deleteRow = new JMenuItem("Delete Row(s)", 68);
        this._editMenu.add(this._deleteRow);
        jMenuBar.add(this._editMenu);
        this.setJMenuBar(jMenuBar);
        this._insertRow.addActionListener(new W2OutputAssignmentsEditor$4(this));
        this._appendRow.addActionListener(new W2OutputAssignmentsEditor$5(this));
        this._deleteRow.addActionListener(new W2OutputAssignmentsEditor$6(this));
    }

    public boolean isModified() {
        return this._tsrTable.isModified() || this._profileTable.isModified();
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new W2OutputAssignmentsEditor$7(this));
    }

    protected RmaJTable getSelectedTable() {
        if (this._mappingTable.getSelectedRowCount() > 0) {
            return this._mappingTable;
        }
        if (this._tsrTable.getSelectedRowCount() > 0) {
            return this._tsrTable;
        }
        if (this._profileTable.getSelectedRowCount() > 0) {
            return this._profileTable;
        }
        return this._mappingTable;
    }

    protected void saveForm() {
        this.saveDssOutTable();
        this.saveTsrTable();
        this.saveProfileTable();
    }

    protected void saveDssOutTable() {
        this._mappingTable.commitEdit(true);
        int n = this._mappingTable.getRowCount();
        this._dssOutput.clearDssData();
        for (int i = 0; i < n; ++i) {
            Object object = this._mappingTable.getCell(i, 0);
            String string = (String)this._mappingTable.getCell(i, 1);
            String string2 = (String)this._mappingTable.getCell(i, 2);
            String string3 = (String)this._mappingTable.getCell(i, 3);
            if (!(object instanceof DssOutData)) {
                if (string.isEmpty()) continue;
                object = new DssOutData(string, string2, this._fpart, "deg-c");
            } else {
                if (string == null || string.trim().length() <= 0) continue;
                object = (DssOutData)object;
                ((DssOutData)object).setOptFile(string);
                ((DssOutData)object).setBPart(string2);
                ((DssOutData)object).setUserLabel(string3);
                string = string.toUpperCase();
                if (string.startsWith("Q")) {
                    ((DssOutData)object).setCPart("FLOW");
                    ((DssOutData)object).setUnits("m3/s");
                }
            }
            this._dssOutput.add((DssOutData)object);
        }
        this._dssOutput.writeDssOutFile();
    }

    protected void saveTsrTable() {
        this._tsrTable.commitEdit(true);
        if (this._tsrTable.isModified()) {
            this._tsrMapping.clear();
            int n = this._tsrTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object object = (String)this._tsrTable.getCell(i, 0);
                String string = (String)this._tsrTable.getCell(i, 1);
                String string2 = (String)this._tsrTable.getCell(i, 2);
                if (((String)object).length() <= 0) continue;
                object = new W2OutputConnection((String)object, string, string2);
                this._tsrMapping.add((W2OutputConnection)object);
            }
            this._model.setTsrMapping(this._tsrMapping);
        }
    }

    protected void saveProfileTable() {
        this._profileTable.commitEdit(true);
        if (this._profileTable.isModified()) {
            this._profileMapping.clear();
            int n = this._profileTable.getRowCount();
            new Vector();
            for (int i = 0; i < n; ++i) {
                Object object = (String)this._profileTable.getCell(i, 0);
                String string = (String)this._profileTable.getCell(i, 1);
                String string2 = (String)this._profileTable.getCell(i, 2);
                if (((String)object).length() <= 0) continue;
                object = new W2OutputConnection((String)object, string, string2);
                this._profileMapping.add((W2OutputConnection)object);
            }
            this._model.setProfileMapping(this._profileMapping);
        }
    }

    private void fillForm() {
        this.fillDssOutTable();
        this.fillTsrTable();
        this.fillProfileTable();
        this.setModified(false);
    }

    private void fillDssOutTable() {
        Vector<Object> vector;
        int n;
        Object object;
        this._mappingTable.deleteCells();
        this._dssOutput = new DssOutput(this._id);
        this._fpart = "";
        if (ClientApp.frame().getCurrentMode() instanceof RSimSimulationMode) {
            object = (RSimSimulationMode)ClientApp.frame().getCurrentMode();
            if ((object = object.getSimulation()) != null) {
                object = object.getRunTimeWindow();
                object.getStartTime().year();
                this._dssOutput.getDssFile();
            }
        }
        object = this._id.getPath();
        RMAIO.getDirectoryFromPath((String)object);
        this._altPanel.getExeDirectory();
        RmiFileManager cfr_ignored_0 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        if (!this._dssOutput.readDssOutFile()) {
            this._mappingTable.appendRow();
            return;
        }
        object = this._dssOutput.getDssOutData();
        if (object.size() == 0) {
            this._mappingTable.appendRow();
            return;
        }
        for (n = 0; n < object.size(); ++n) {
            vector = new Vector<Object>(3);
            DssOutData dssOutData = (DssOutData)object.get(n);
            vector.add(dssOutData);
            vector.add(dssOutData.getOptFile());
            vector.add(dssOutData.getBPart());
            if (this._fpart.length() == 0 && dssOutData.getFPart() != null && dssOutData.getFPart().length() > 0) {
                this._fpart = dssOutData.getFPart();
            }
            vector.add(dssOutData.getUserLabel());
            this._mappingTable.appendRow(vector);
        }
        for (int i = n = this._mappingTable.getRowCount(); i < 3; ++i) {
            vector = new Vector<String>(3);
            vector.add("");
            vector.add("");
            vector.add("");
            this._mappingTable.appendRow(vector);
        }
    }

    private void fillTsrTable() {
        Vector<String> vector;
        int n;
        this._tsrTable.deleteCells();
        this._tsrMapping = this._model.getTsrMapping();
        int n2 = this._tsrMapping.size();
        for (n = 0; n < n2; ++n) {
            vector = new Vector<String>(3);
            W2OutputConnection w2OutputConnection = this._tsrMapping.get(n);
            vector.add(w2OutputConnection.getW2File());
            vector.add(w2OutputConnection.getResSimName());
            vector.add(w2OutputConnection.getUserName());
            this._tsrTable.appendRow(vector);
        }
        for (n2 = n = this._tsrTable.getRowCount(); n2 < 3; ++n2) {
            vector = new Vector<String>(3);
            vector.add("");
            vector.add("");
            vector.add("");
            this._tsrTable.appendRow(vector);
        }
    }

    private void fillProfileTable() {
        Vector<String> vector;
        int n;
        this._profileTable.deleteCells();
        this._profileMapping = this._model.getProfileMapping();
        int n2 = this._profileMapping.size();
        for (n = 0; n < n2; ++n) {
            vector = new Vector<String>(3);
            W2OutputConnection w2OutputConnection = this._profileMapping.get(n);
            vector.add(w2OutputConnection.getW2File());
            vector.add(w2OutputConnection.getResSimName());
            vector.add(w2OutputConnection.getUserName());
            this._profileTable.appendRow(vector);
        }
        for (n2 = n = this._profileTable.getRowCount(); n2 < 3; ++n2) {
            vector = new Vector<String>(3);
            vector.add("");
            vector.add("");
            vector.add("");
            this._profileTable.appendRow(vector);
        }
    }
}

