/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldRect;
import hec.gfx2d.profilePlot.ProfileDataG2dObject;
import hec.gfx2d.profilePlot.ProfileDataRecords;
import hec.rss.plugins.w2.model.VerticalProfileDataSet;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;
import rma.util.RMAConst;

public class W2ProfileDataG2dObject
extends ProfileDataG2dObject {
    public W2ProfileDataG2dObject(VerticalProfileDataSet verticalProfileDataSet, String string) {
        super((ProfileDataRecords)verticalProfileDataSet, string);
        this.init();
    }

    public W2ProfileDataG2dObject(VerticalProfileDataSet verticalProfileDataSet, String string, int n) {
        super((ProfileDataRecords)verticalProfileDataSet, string, n);
        this.init();
    }

    protected boolean init() {
        this.setUnitSystem(2);
        VerticalProfileDataSet verticalProfileDataSet = (VerticalProfileDataSet)this._rec;
        verticalProfileDataSet.getType();
        this.setYParameterId(Parameter.PARAMID_ELEV);
        this.yunits = "m";
        if (this.yunits.equalsIgnoreCase("FEET")) {
            this.yunits = "ft";
        }
        if (Units.getUnitsForAlias((String)this.yunits) != null) {
            this.yunits = Units.getUnitsForAlias((String)this.yunits);
        }
        return true;
    }

    public String getYAxisName() {
        VerticalProfileDataSet verticalProfileDataSet = (VerticalProfileDataSet)this._rec;
        return ParameterLookup.getFullParamString((int)verticalProfileDataSet.getYParameterId()) + " (%S)";
    }

    public String getXAxisName() {
        Object object = (VerticalProfileDataSet)this._rec;
        object = object.getParameterName();
        return object;
    }

    public int getXAxisType() {
        return 0;
    }

    public int getYAxisType() {
        return 0;
    }

    public int getXParameterId() {
        if (this._rec.getType() == 1) {
            return Parameter.PARAMID_TEMP;
        }
        return -1;
    }

    public int getYParameterId() {
        if (this._rec.getType() == 1) {
            return Parameter.PARAMID_ELEV;
        }
        return Parameter.PARAMID_TEMP;
    }

    public void load() {
    }

    public void unload() {
    }

    public WorldRect getBounds() {
        if (this._profx == null || this._profy == null) {
            return null;
        }
        if (this._bounds == null) {
            this._bounds = new WorldRect();
            float f = Float.MAX_VALUE;
            float f2 = Float.MIN_VALUE;
            float f3 = Float.MAX_VALUE;
            float f4 = Float.MIN_VALUE;
            for (int i = 0; i < this._profx.length; ++i) {
                if (!RMAConst.isValidValue((float)this._profx[i])) continue;
                if (f > this._profx[i]) {
                    f = this._profx[i];
                }
                if (f2 < this._profx[i]) {
                    f2 = this._profx[i];
                }
                if (RMAConst.isValidValue((float)this._profy[i]) && f3 > this._profy[i]) {
                    f3 = this._profy[i];
                }
                if (!RMAConst.isValidValue((float)this._profy[i]) || !(f4 < this._profy[i])) continue;
                f4 = this._profy[i];
            }
            float[] fArray = this._rec.getParameterBounds(this._parameter);
            if (fArray != null) {
                f3 = fArray[0];
                f4 = fArray[1];
            }
            if (this._rec.getType() == 1) {
                this._bounds.s = f;
                this._bounds.n = f2;
                this._bounds.w = f3;
                this._bounds.e = f4;
            } else {
                this._bounds.w = f;
                this._bounds.e = f2;
                this._bounds.s = f3;
                this._bounds.n = f4;
            }
        }
        return this._bounds;
    }
}

