/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.client;

import hec.clientapp.client.ClientApp;
import hec.heclib.util.HecTime;
import hec.io.Identifier;
import hec.rss.plugins.w2.client.AltW2Panel;
import hec.rss.plugins.w2.client.W2RestartEditor$1;
import hec.rss.plugins.w2.client.W2RestartEditor$2;
import hec.rss.plugins.w2.model.DateTimeFrequencyRecord;
import hec.rss.plugins.w2.model.W2Model;
import hec.rss.plugins.w2.model.W2RestartInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimePanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class W2RestartEditor
extends RmaJDialog {
    private JPanel _restartInputPanel;
    private RmaJCheckBox _w2RestartInCheck;
    private JPanel _restartOutputPanel;
    private RmaJCheckBox _w2RestartOutCheck;
    private RmaJTextField _w2RestartOutFileFld;
    private DateTimePanel _restartDatePanel;
    private RmiFileChooserField _restartFileFld;
    private RmaJRadioButton _restartByDateRadio;
    private RmaJRadioButton _restartByFrequencyRadio;
    private RmaJTable _outputRestartTable;
    private Identifier _id;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private W2Model _model;
    private AltW2Panel _altPanel;
    private String _fpart = "";

    public W2RestartEditor(Dialog dialog, boolean bl, W2Model w2Model, AltW2Panel altW2Panel) {
        super(dialog, bl);
        this._model = w2Model;
        this._altPanel = altW2Panel;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(500, 400);
        W2RestartEditor w2RestartEditor = this;
        w2RestartEditor.setLocationRelativeTo(w2RestartEditor.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("W2 Restart Control Editor");
        Object object = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        object.gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)10, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)jPanel, object);
        this._w2RestartInCheck = new RmaJCheckBox("Read W2 Input Restart File");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.gridwidth = 2;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._w2RestartInCheck, object);
        Serializable serializable = new JLabel("Input Restart File:");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)serializable, object);
        this._restartFileFld = new RmiFileChooserField();
        this._restartFileFld.setOpenFile();
        this._restartFileFld.setDefaultPath(ClientApp.Workspace().getWorkspacePath() + "/w2");
        ((JLabel)serializable).setLabelFor((Component)this._restartFileFld);
        serializable = new Vector(1);
        RMAFilenameFilter rMAFilenameFilter = new RMAFilenameFilter("rs*.*pt", "W2 Restart File");
        ((Vector)serializable).add(rMAFilenameFilter);
        this._restartFileFld.setFilters((List)((Object)serializable));
        object.gridx = 1;
        object.gridy = 1;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._restartFileFld, object);
        jPanel = new JPanel(new GridBagLayout());
        object.gridx = 0;
        object.gridy = 1;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)10, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)jPanel, object);
        object = new String[]{"Date", "Time", "Frequency"};
        this._outputRestartTable = new RmaJTable((Component)((Object)this), object);
        this._outputRestartTable.setColumnWidth(1, 50);
        this._outputRestartTable.setColumnWidth(2, 50);
        this._outputRestartTable.setPrecision(2);
        this._outputRestartTable.setDateCellEditor(0, "DDMMMYYYY", true);
        this._outputRestartTable.setTimeCellEditor(1);
        this._outputRestartTable.setDoubleCellEditor(2);
        this._outputRestartTable.setHorizontalAlignment(0, 0);
        this._outputRestartTable.setHorizontalAlignment(0, 1);
        this._outputRestartTable.setNumRows(4);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 3;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = new Insets(15, 5, 5, 5);
        jPanel.add((Component)this._outputRestartTable.getScrollPane(), object);
        this._w2RestartOutCheck = new RmaJCheckBox("Write W2 Restart File(s)");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.gridwidth = 2;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._w2RestartOutCheck, object);
        this._restartDatePanel = new DateTimePanel(1, "W2 Restart Date:", "Time:", "DDMMMYYYY");
        this._restartDatePanel.showTimeAsBeginningOfDay(false);
        object.gridx = 0;
        object.gridy = 2;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)30, (int)0, (int)5);
        this._cmdPanel = new ButtonCmdPanel(12);
        object.gridx = 0;
        object.gridy = 10;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.gridwidth = 2;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, object);
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new W2RestartEditor$1(this));
        new W2RestartEditor$2();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected void saveForm() {
        String string;
        Object object;
        this._outputRestartTable.commitEdit(true);
        int n = this._outputRestartTable.getNumRows();
        ArrayList<DateTimeFrequencyRecord> arrayList = new ArrayList<DateTimeFrequencyRecord>();
        for (int i = 0; i < n; ++i) {
            object = this._outputRestartTable.getValueAt(i, 0);
            if (object == null || "".equals(object)) continue;
            string = (String)object;
            object = this._outputRestartTable.getValueAt(i, 1);
            if (object == null || "".equals(object)) {
                object = "0000";
            }
            object = (String)object;
            string = new HecTime(string, (String)object, 1);
            object = this._outputRestartTable.getValueAt(i, 2);
            double d = RMAIO.parseDouble((Object)object, (double)100.0);
            object = new DateTimeFrequencyRecord((HecTime)string, d);
            arrayList.add((DateTimeFrequencyRecord)object);
        }
        W2RestartInfo w2RestartInfo = new W2RestartInfo();
        w2RestartInfo.setShouldInputRestartFile(this._w2RestartInCheck.isSelected());
        w2RestartInfo.setShouldWriteRestartFile(this._w2RestartOutCheck.isSelected());
        object = this._restartFileFld.getText();
        if (((String)object).trim().length() > 0) {
            string = this._model.getDefaultDirectory();
            Object object2 = object;
            if (!RMAIO.isFullPath((String)object)) {
                object2 = RMAIO.makeAbsolutePath((String)string, (String)object);
            }
            object = RMAIO.getRelativePath((String)string, (String)object2);
        }
        w2RestartInfo.setInputRestartFilename((String)object);
        w2RestartInfo.setOutputRecordsList(arrayList);
        this._model.setRestartInfo(w2RestartInfo);
    }

    private void fillForm() {
        this.clearPanel();
        if (this._model == null) {
            return;
        }
        Object object = this._model.getDefaultDirectory();
        this._restartFileFld.setDefaultPath((String)object);
        W2RestartInfo w2RestartInfo = this._model.getRestartInfo();
        if (w2RestartInfo != null) {
            Object object2;
            this._w2RestartInCheck.setSelected(w2RestartInfo.shouldInputRestartFile());
            String string = w2RestartInfo.getInputRestartFilename();
            if (string.trim().length() > 0) {
                object2 = string;
                if (!RMAIO.isFullPath((String)string)) {
                    object2 = RMAIO.makeAbsolutePath((String)object, (String)string);
                }
                string = RMAIO.getRelativePath((String)object, (String)object2);
            }
            this._restartFileFld.setText(string);
            this._w2RestartOutCheck.setSelected(w2RestartInfo.shouldWriteRestartFile());
            object2 = w2RestartInfo.getOutputRecordsList();
            if (object2 != null && object2.size() > 0) {
                for (int i = 0; i < object2.size(); ++i) {
                    object = (DateTimeFrequencyRecord)object2.get(i);
                    string = ((DateTimeFrequencyRecord)object).hecTime.date(104);
                    if (string.trim().length() > 1) {
                        this._outputRestartTable.setValueAt((Object)string, i, 0);
                        string = ((DateTimeFrequencyRecord)object).hecTime.getTime(false);
                        this._outputRestartTable.setValueAt((Object)string, i, 1);
                        this._outputRestartTable.setValueAt((Object)((DateTimeFrequencyRecord)object).frequency, i, 2);
                        continue;
                    }
                    this._outputRestartTable.setValueAt((Object)"", i, 0);
                    this._outputRestartTable.setValueAt((Object)"", i, 1);
                    this._outputRestartTable.setValueAt((Object)"", i, 2);
                }
            }
        }
        this.setModified(false);
    }

    private void clearPanel() {
        this._outputRestartTable.clear();
        this._w2RestartInCheck.setSelected(false);
        this._w2RestartOutCheck.setSelected(false);
        this._restartFileFld.setText("");
        this.setModified(false);
    }
}

