/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.model.XMLManager;
import hec.rss.plugins.w2.model.DssOutData;
import hec.rss.plugins.w2.model.W2DssConnection;
import hec.rss.plugins.w2.model.W2Model;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import rma.util.RMAIO;

public class W2Alt
extends XMLManager {
    public static final String FILE_EXT = ".w2alt";
    private boolean _computeW2;
    private List<W2Model> _modelList = new ArrayList<W2Model>();

    public List<W2Model> getModelList() {
        return this._modelList;
    }

    public void init() {
    }

    public void setComputeW2(boolean bl) {
        this._computeW2 = bl;
    }

    public boolean shouldComputeW2() {
        return this._computeW2;
    }

    protected boolean loadDocument(Document object) {
        this.setIgnoreModifiedEvents(true);
        this._modelList.clear();
        try {
            object = object.getRootElement();
            String string = object.getAttributeValue("Name");
            this.setName(string);
            this.loadDescription((Element)object);
            string = object.getAttributeValue("runW2");
            this._computeW2 = Boolean.parseBoolean(string);
            string = object.getAttributeValue("LastModified");
            if (string != null) {
                this._lastModifiedTime = Long.parseLong(string);
            }
            if ((string = object.getAttributeValue("Index")) != null) {
                this._index = Integer.parseInt(string);
            }
            if ((object = object.getChild("W2Models")) != null) {
                object = object.getChildren();
                for (int i = 0; i < object.size(); ++i) {
                    W2Model w2Model;
                    string = (Element)object.get(i);
                    if (!"W2Model".equals(string.getName()) || !(w2Model = new W2Model(this)).loadData((Element)string)) continue;
                    this._modelList.add(w2Model);
                }
            }
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
        this.setModified(false);
        return true;
    }

    public String getUserLabelForW2File(String string, String string2) {
        for (int i = 0; i < this._modelList.size(); ++i) {
            Object object = this._modelList.get(i);
            if (object == null || (object = ((W2Model)object).getUserLabelForW2File(string, string2)) == null) continue;
            return ((DssOutData)object).getUserLabel();
        }
        return "";
    }

    public boolean writeFile(Identifier object) {
        if (object == null) {
            return true;
        }
        HecFile hecFile = object.getFile();
        if (hecFile == null) {
            System.out.println("writeFile:no File for " + String.valueOf(object));
            return false;
        }
        object = hecFile.getBufferedWriter();
        if (object == null) {
            System.out.println("writeFile:failed to get writer for " + String.valueOf(hecFile));
            return false;
        }
        object = new Element("W2Alt");
        Document document = new Document((Element)object);
        object.setAttribute("Name", this.getName());
        String string = this.getDescription();
        if (string != null && string.length() > 0) {
            this.saveDescription((Element)object);
        }
        int n = this.getIndex();
        object.setAttribute("Index", String.valueOf(n));
        long l = this.getLastModifiedTime();
        object.setAttribute("LastModified", String.valueOf(l));
        object.setAttribute("runW2", String.valueOf(this._computeW2));
        Element element = new Element("W2Models");
        object.addContent((Content)element);
        for (int i = 0; i < this._modelList.size(); ++i) {
            object = this._modelList.get(i);
            object.saveData(element);
        }
        return this.saveDocument(document, hecFile);
    }

    public boolean updateModel(W2Model w2Model) {
        boolean bl = true;
        for (int i = 0; i < this._modelList.size(); ++i) {
            W2Model w2Model2 = this._modelList.get(i);
            if (!w2Model2.getName().equals(w2Model.getName()) || w2Model2.copyModel(w2Model)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public W2Model getModel(String string) {
        for (int i = 0; i < this._modelList.size(); ++i) {
            W2Model w2Model = this._modelList.get(i);
            if (!w2Model.getName().equals(string)) continue;
            return w2Model;
        }
        return null;
    }

    public Manager saveManagerAs(String object, String string, ManagerProxyListContainer managerProxyListContainer) {
        if (managerProxyListContainer == null) {
            managerProxyListContainer = this._proxyList.getContainer();
        }
        String string2 = this._proxyList.getModel();
        if ((object = this.getSaveAsId((String)object, string, (string2 = (managerProxyListContainer = managerProxyListContainer.getManagerProxyList(string2)).newManager(((Object)((Object)this)).getClass().getName())).getIndex())) == null) {
            return null;
        }
        string2.getIdentifier().copy((Identifier)object);
        string2.getIdentifier().setName(string + ":" + this.getName());
        string2.setName(string + ":" + this.getName());
        string2.setDescription(this.getDescription());
        object = (W2Alt)((Object)string2);
        ((W2Alt)((Object)string2))._computeW2 = this._computeW2;
        ((W2Alt)((Object)object))._modelList = new ArrayList<W2Model>(this._modelList.size());
        for (int i = 0; i < this._modelList.size(); ++i) {
            W2Model w2Model = this._modelList.get(i);
            W2Model w2Model2 = w2Model.clone();
            ((W2Alt)((Object)object))._modelList.add(w2Model2);
            Object object2 = w2Model.getControlFilename();
            if (object2 == null || ((String)object2).length() <= 0) continue;
            String string3 = this.makeAbsolutePath((String)object2);
            string3 = RMAIO.getDirectoryFromPath((String)string3);
            Object object3 = object.makeAbsolutePath(w2Model2.getControlFilename());
            object3 = RMAIO.getDirectoryFromPath((String)object3);
            string3 = new Identifier(string3);
            object3 = RMAIO.getDirectoryFromPath((String)object3);
            object3 = (String)object3 + "/" + string + "-" + w2Model.getName();
            Identifier identifier = new Identifier((String)object3);
            w2Model2.setControlFilename((String)object3 + "/" + RMAIO.getFileFromPath((String)object2));
            w2Model2.setControlFilename(object.getRelativePath(w2Model2.getControlFilename()));
            for (int j = 0; j < w2Model.getDssMapping().size(); ++j) {
                object2 = w2Model2.getDssMapping().get(j);
                Object object4 = RMAIO.getFileFromPath((String)((W2DssConnection)object2).getW2File());
                object4 = (String)object3 + "/" + (String)object4;
                object4 = object.getRelativePath((String)object4);
                ((W2DssConnection)object2).setW2File((String)object4);
            }
            try {
                this.getFileManager().copyDirectory((Identifier)string3, identifier);
                continue;
            }
            catch (RemoteException remoteException) {
                System.out.println("saveManagerAs: ****ERROR RemoteException copying W2 directory " + String.valueOf(remoteException));
            }
        }
        managerProxyListContainer.saveManager(UserId.getUserId(), (Manager)object);
        return string2;
    }

    public void setW2Models(List<W2Model> list) {
        this._modelList.clear();
        if (list == null) {
            return;
        }
        this._modelList.addAll(list);
    }
}

