/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.model;

import hec.clientapp.client.ClientApp;
import hec.heclib.util.HecTime;
import hec.io.Identifier;
import hec.io.ProcessOutput;
import hec.io.ProcessOutputLine;
import hec.io.ProcessOutputReader;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.rss.plugins.w2.io.DssOutput;
import hec.rss.plugins.w2.model.DateTimeFrequencyRecord;
import hec.rss.plugins.w2.model.DssOutData;
import hec.rss.plugins.w2.model.FishGroup;
import hec.rss.plugins.w2.model.HabitatData;
import hec.rss.plugins.w2.model.SelectiveWithdrawalData;
import hec.rss.plugins.w2.model.W2Alt;
import hec.rss.plugins.w2.model.W2BcConnection;
import hec.rss.plugins.w2.model.W2DssConnection;
import hec.rss.plugins.w2.model.W2OutputConnection;
import hec.rss.plugins.w2.model.W2RestartInfo;
import hec.rss.plugins.w2.model.W2flow;
import hec.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAIO;

public class W2Model
extends NamedType
implements Cloneable {
    public static final String SELECTIVE_WITHDRAWAL_FILE = "w2_selective.npt";
    private String _controlFilename;
    private String _w2Exe;
    private List<W2DssConnection> _dssMapping = new ArrayList<W2DssConnection>();
    private HabitatData _habitatVolumeData;
    private boolean _runHabitatVolume;
    private SelectiveWithdrawalData _selWithdrawalData;
    private boolean _runSelWithdrawal;
    private List<W2OutputConnection> _tsrMapping = new ArrayList<W2OutputConnection>();
    private List<W2OutputConnection> _profileMapping = new ArrayList<W2OutputConnection>();
    private List<W2BcConnection> _bcMapping = new ArrayList<W2BcConnection>();
    private W2RestartInfo _restartInfo;
    private boolean _changeRestartOptions = false;
    private W2Alt _alt;
    private boolean _runBCBatchFile;
    private boolean _runDssOut;
    private boolean _execute = true;
    private boolean _w2HabitatC_On = false;
    private boolean _w2SelectC_On = false;
    private String _miscellLine = "";
    private Map<String, DssOutData> _dssOutDataMap = new HashMap<String, DssOutData>();

    public W2Model(W2Alt w2Alt) {
        super(null);
        this._alt = w2Alt;
    }

    public void setControlFilename(String string) {
        this._controlFilename = string;
    }

    public String getControlFilename() {
        return this._controlFilename;
    }

    public String getW2Exe() {
        return this._w2Exe;
    }

    public void setW2Exe(String string) {
        this._w2Exe = string;
    }

    public void setDssMapping(List<W2DssConnection> list) {
        this._dssMapping.clear();
        if (list == null) {
            return;
        }
        this._dssMapping.addAll(list);
    }

    public List<W2DssConnection> getDssMapping() {
        ArrayList<W2DssConnection> arrayList = new ArrayList<W2DssConnection>();
        arrayList.addAll(this._dssMapping);
        return arrayList;
    }

    public DssOutData getUserLabelForW2File(String object, String string) {
        if (this._dssOutDataMap.isEmpty()) {
            if (!this.readDssOutFile()) {
                return null;
            }
            if (this._dssOutDataMap.isEmpty()) {
                return null;
            }
        }
        object = this._dssOutDataMap.get(string);
        return object;
    }

    private boolean readDssOutFile() {
        if (this._controlFilename == null || this._controlFilename.length() == 0) {
            return false;
        }
        Identifier identifier = this.getControlFilename();
        identifier = this._alt.makeAbsolutePath((String)identifier);
        identifier = RMAIO.getDirectoryFromPath((String)identifier);
        if ((identifier = identifier.concat("/").concat("dssout.npt")).length() <= 0) {
            return false;
        }
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (!rmiFileManager.fileExists((String)identifier)) {
                return false;
            }
            identifier = new Identifier((String)identifier);
            identifier = rmiFileManager.openFile(UserId.getUserId(), identifier);
            if (identifier == null) {
                return false;
            }
            if (!(identifier = new DssOutput(identifier)).readDssOutFile()) {
                return false;
            }
            identifier = identifier.getDssOutData();
            for (int i = 0; i < identifier.size(); ++i) {
                DssOutData dssOutData = identifier.get(i);
                Object object = dssOutData.getOptFile();
                object = "W2:" + ((String)object).toUpperCase();
                this._dssOutDataMap.put((String)object, dssOutData);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("DssOutFile:failed: RemoteException " + String.valueOf(remoteException));
            return false;
        }
        return true;
    }

    public String getDefaultDirectory() {
        String string = this.getControlFilename();
        string = this._alt.makeAbsolutePath(string);
        string = RMAIO.getDirectoryFromPath((String)string);
        return string;
    }

    public void clearDssOutDataList() {
        this._dssOutDataMap.clear();
    }

    public void setHabitatData(HabitatData habitatData) {
        this._habitatVolumeData = habitatData;
    }

    public HabitatData getHabitatData() {
        return this._habitatVolumeData;
    }

    public void setSelectiveWithdrawalData(SelectiveWithdrawalData selectiveWithdrawalData) {
        this._selWithdrawalData = selectiveWithdrawalData;
    }

    public SelectiveWithdrawalData getSelectiveWithdrawalData() {
        return this._selWithdrawalData;
    }

    public void setRestartInfo(W2RestartInfo w2RestartInfo) {
        this._restartInfo = w2RestartInfo;
    }

    public W2RestartInfo getRestartInfo() {
        return this._restartInfo;
    }

    public boolean saveData(Element element) {
        Object object;
        Element element2;
        Object object2 = new Element("W2Model");
        element.addContent((Content)object2);
        if (this._name != null && this._name.length() > 0) {
            object2.setAttribute("Name", this._name);
        }
        if (this._controlFilename != null && this._controlFilename.length() > 0) {
            object2.setAttribute("ControlFile", this._controlFilename);
        }
        if (this._w2Exe != null) {
            object2.setAttribute("W2Exe", this._w2Exe);
        }
        object2.setAttribute("ShouldExecute", String.valueOf(this._execute));
        object2.setAttribute("RunBCBatchFile", String.valueOf(this._runBCBatchFile));
        object2.setAttribute("RunDssOut", String.valueOf(this._runDssOut));
        object2.setAttribute("RunHabitatVolume", String.valueOf(this._runHabitatVolume));
        object2.setAttribute("RunSelectiveWithdrawal", String.valueOf(this._runSelWithdrawal));
        element = new Element("W2ResSimConnectivity");
        object2.addContent((Content)element);
        for (int i = 0; i < this._dssMapping.size(); ++i) {
            W2DssConnection w2DssConnection = this._dssMapping.get(i);
            element2 = new Element("DssMapping");
            element2.setAttribute("w2Name", w2DssConnection.getW2Name());
            element2.setAttribute("w2File", w2DssConnection.getW2File());
            element2.setAttribute("tSName", w2DssConnection.getRssTscName());
            element2.setAttribute("varId", String.valueOf(w2DssConnection.getVarId()));
            element2.setAttribute("param", w2DssConnection.getParam());
            if (w2DssConnection.getFlowType() != null) {
                element2.setAttribute("flowType", w2DssConnection.getFlowType());
            }
            element2.setAttribute("flowIndex", String.valueOf(w2DssConnection.getFlowIndex()));
            element2.setAttribute("flowCount", String.valueOf(w2DssConnection.getFlowCount()));
            element.addContent((Content)element2);
        }
        if (this._habitatVolumeData != null) {
            Element element3 = new Element("W2HabitatVolume");
            object2.setAttribute("HabitatOutputFile", this._habitatVolumeData.getOptFile());
            object2.addContent((Content)element3);
            object = this._habitatVolumeData.getFishGroupList();
            for (int i = 0; i < object.size(); ++i) {
                FishGroup fishGroup = object.get(i);
                element2 = new Element("FishGroup");
                element2.setAttribute("groupName", fishGroup.getGroupName());
                element2.setAttribute("minTemp", String.valueOf(fishGroup.getMinTemp()));
                element2.setAttribute("maxTemp", String.valueOf(fishGroup.getMaxTemp()));
                element2.setAttribute("minDO", String.valueOf(fishGroup.getMinDO()));
                element3.addContent((Content)element2);
            }
        }
        if (this._selWithdrawalData != null) {
            Element element4 = new Element("W2SelectiveWithdrawal");
            object2.addContent((Content)element4);
            double d = this._selWithdrawalData.getTargetTemperature();
            element4.setAttribute("targetTemp", String.valueOf(d));
        }
        if (this._tsrMapping != null) {
            Element element5 = new Element("W2TsrMapping");
            object2.addContent((Content)element5);
            for (int i = 0; i < this._tsrMapping.size(); ++i) {
                W2OutputConnection w2OutputConnection = this._tsrMapping.get(i);
                element2 = new Element("W2OutputConnection");
                element2.setAttribute("w2File", w2OutputConnection.getW2File());
                element2.setAttribute("resSimName", w2OutputConnection.getResSimName());
                element2.setAttribute("userName", w2OutputConnection.getUserName());
                element5.addContent((Content)element2);
            }
        }
        if (this._profileMapping != null) {
            Element element6 = new Element("W2ProfileMapping");
            object2.addContent((Content)element6);
            for (int i = 0; i < this._profileMapping.size(); ++i) {
                W2OutputConnection w2OutputConnection = this._profileMapping.get(i);
                element2 = new Element("W2OutputConnection");
                element2.setAttribute("w2File", w2OutputConnection.getW2File());
                element2.setAttribute("resSimName", w2OutputConnection.getResSimName());
                element2.setAttribute("userName", w2OutputConnection.getUserName());
                element6.addContent((Content)element2);
            }
        }
        if (this._bcMapping != null) {
            Element element7 = new Element("W2BcMapping");
            object2.addContent((Content)element7);
            for (int i = 0; i < this._bcMapping.size(); ++i) {
                W2BcConnection w2BcConnection = this._bcMapping.get(i);
                element2 = new Element("W2BcConnection");
                element2.setAttribute("w2Element", w2BcConnection.getW2ElementName());
                element2.setAttribute("bcType", String.valueOf(w2BcConnection.getBcType()));
                element2.setAttribute("downstreamFile", w2BcConnection.getW2DownstreamFile());
                element2.setAttribute("upstreamFile", w2BcConnection.getW2UpstreamFile());
                element7.addContent((Content)element2);
            }
        }
        if (this._restartInfo != null) {
            Element element8 = new Element("W2RestartInfo");
            object2.addContent((Content)element8);
            element8.setAttribute("UseRestartFile", String.valueOf(this._restartInfo.shouldInputRestartFile()));
            element8.setAttribute("RestartInputFile", this._restartInfo.getInputRestartFilename());
            element8.setAttribute("WriteRestartFile", String.valueOf(this._restartInfo.shouldWriteRestartFile()));
            List<DateTimeFrequencyRecord> list = this._restartInfo.getOutputRecordsList();
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                element2 = new Element("DateTimeFreqRec");
                object2 = ((DateTimeFrequencyRecord)object).hecTime;
                object2 = object2.dateAndTime(104);
                element2.setAttribute("dateTime", (String)object2);
                element2.setAttribute("freq", String.valueOf(((DateTimeFrequencyRecord)object).frequency));
                element8.addContent((Content)element2);
            }
        }
        return true;
    }

    public boolean loadData(Element object) {
        int n;
        Element element;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        int n3;
        if (!"W2Model".equals(object.getName())) {
            return false;
        }
        Object object7 = object.getAttributeValue("ControlFile");
        this._controlFilename = object7;
        object7 = object.getAttributeValue("Name");
        if (object7 != null) {
            this._name = object7;
        }
        if ((object7 = object.getAttributeValue("W2Exe")) != null) {
            this._w2Exe = object7;
        }
        this._runBCBatchFile = XMLUtilities.getAttributeValueAsBoolean((Element)object, (String)"RunBCBatchFile", (boolean)this._runBCBatchFile);
        this._runDssOut = XMLUtilities.getAttributeValueAsBoolean((Element)object, (String)"RunDssOut", (boolean)this._runDssOut);
        this._execute = XMLUtilities.getAttributeValueAsBoolean((Element)object, (String)"ShouldExecute", (boolean)true);
        this._runHabitatVolume = XMLUtilities.getAttributeValueAsBoolean((Element)object, (String)"RunHabitatVolume", (boolean)true);
        this._runSelWithdrawal = XMLUtilities.getAttributeValueAsBoolean((Element)object, (String)"RunSelectiveWithdrawal", (boolean)true);
        object7 = object.getChild("W2ResSimConnectivity");
        if (object7 != null) {
            object7 = object7.getChildren();
            for (n3 = 0; n3 < object7.size(); ++n3) {
                object6 = (Element)object7.get(n3);
                if (!"DssMapping".equals(object6.getName())) continue;
                string = object6.getAttributeValue("w2Name");
                object5 = object6.getAttributeValue("w2File");
                object4 = object6.getAttributeValue("tSName");
                int n4 = RMAIO.parseInt((String)object6.getAttributeValue("varId"));
                object3 = object6.getAttributeValue("param");
                String string2 = object6.getAttributeValue("flowType");
                int n5 = RMAIO.parseInt((String)object6.getAttributeValue("flowIndex"), (int)-1);
                n2 = RMAIO.parseInt((String)object6.getAttributeValue("flowCount"), (int)0);
                object2 = new W2DssConnection(string, (String)object5, (String)object4, (String)object3, n4, string2, n5, n2);
                this._dssMapping.add((W2DssConnection)object2);
            }
        }
        if ((object7 = object.getChild("W2HabitatVolume")) != null) {
            object2 = object7.getChildren();
            if (this._habitatVolumeData == null) {
                this._habitatVolumeData = new HabitatData("HabitatVolume");
            }
            object4 = object.getAttributeValue("HabitatOutputFile");
            this._habitatVolumeData.setOptFile((String)object4);
            object3 = this._habitatVolumeData.getFishGroupList();
            for (int i = 0; i < object2.size(); ++i) {
                string = (Element)object2.get(i);
                if (!"FishGroup".equals(string.getName())) continue;
                object5 = string.getAttributeValue("groupName");
                double d = RMAIO.parseDouble((String)string.getAttributeValue("minTemp"), (double)-99.0);
                double d2 = RMAIO.parseDouble((String)string.getAttributeValue("maxTemp"), (double)99.0);
                double d3 = RMAIO.parseDouble((String)string.getAttributeValue("minDO"), (double)-99.0);
                object6 = new FishGroup((String)object5, d, d2, d3);
                object3.add(object6);
            }
            this._habitatVolumeData.setFishGroupList((List<FishGroup>)object3);
        }
        if ((object2 = object.getChild("W2SelectiveWithdrawal")) != null) {
            object6 = object2.getAttributeValue("targetTemp");
            double d = RMAIO.parseDouble((String)object6, (double)-3.4028234663852886E38);
            if (this._selWithdrawalData == null) {
                this._selWithdrawalData = new SelectiveWithdrawalData();
                this._selWithdrawalData.setTargetTemperature(d);
            }
        }
        if ((object6 = object.getChild("W2TsrMapping")) != null) {
            this._tsrMapping.clear();
            List list = object6.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                object4 = (Element)list.get(i);
                if (!"W2OutputConnection".equals(object4.getName())) continue;
                object3 = object4.getAttributeValue("w2File");
                String string3 = object4.getAttributeValue("resSimName");
                String string4 = object4.getAttributeValue("userName");
                object5 = new W2OutputConnection((String)object3, string3, string4);
                this._tsrMapping.add((W2OutputConnection)object5);
            }
        }
        if ((element = object.getChild("W2ProfileMapping")) != null) {
            this._profileMapping.clear();
            object5 = element.getChildren();
            for (n2 = 0; n2 < object5.size(); ++n2) {
                object3 = (Element)object5.get(n2);
                if (!"W2OutputConnection".equals(object3.getName())) continue;
                String string5 = object3.getAttributeValue("w2File");
                String string6 = object3.getAttributeValue("resSimName");
                String string7 = object3.getAttributeValue("userName");
                object4 = new W2OutputConnection(string5, string6, string7);
                this._profileMapping.add((W2OutputConnection)object4);
            }
        }
        if ((object5 = object.getChild("W2BcMapping")) != null) {
            this._bcMapping.clear();
            object4 = object5.getChildren();
            for (n = 0; n < object4.size(); ++n) {
                Element element2 = (Element)object4.get(n);
                if (!"W2BcConnection".equals(element2.getName())) continue;
                String string8 = element2.getAttributeValue("w2Element");
                String string9 = element2.getAttributeValue("downstreamFile");
                String string10 = element2.getAttributeValue("upstreamFile");
                n3 = RMAIO.parseInt((String)element2.getAttributeValue("bcType"), (int)0);
                object3 = new W2BcConnection(string8, n3, string9, string10);
                this._bcMapping.add((W2BcConnection)object3);
            }
        }
        if ((object4 = object.getChild("W2RestartInfo")) != null) {
            if (this._restartInfo == null) {
                this._restartInfo = new W2RestartInfo();
            }
            boolean bl = XMLUtilities.getAttributeValueAsBoolean((Element)object4, (String)"UseRestartFile", (boolean)false);
            String string11 = object4.getAttributeValue("RestartInputFile");
            this._restartInfo.setShouldInputRestartFile(bl);
            this._restartInfo.setInputRestartFilename(string11);
            bl = XMLUtilities.getAttributeValueAsBoolean((Element)object4, (String)"WriteRestartFile", (boolean)false);
            this._restartInfo.setShouldWriteRestartFile(bl);
            List list = object4.getChildren();
            List<DateTimeFrequencyRecord> list2 = this._restartInfo.getOutputRecordsList();
            list2.clear();
            for (n = 0; n < list.size(); ++n) {
                Element element3 = (Element)list.get(n);
                if (!"DateTimeFreqRec".equals(element3.getName())) continue;
                object = element3.getAttributeValue("dateTime");
                object = new HecTime((String)object, 1);
                double d = RMAIO.parseDouble((String)element3.getAttributeValue("freq"), (double)100.0);
                DateTimeFrequencyRecord dateTimeFrequencyRecord = new DateTimeFrequencyRecord((HecTime)object, d);
                list2.add(dateTimeFrequencyRecord);
            }
            this._restartInfo.setOutputRecordsList(list2);
        }
        return true;
    }

    public String toString() {
        if (this._name != null) {
            return this._name;
        }
        if (this._controlFilename != null && this._controlFilename.length() > 0) {
            return RMAIO.getFileFromPath((String)this._controlFilename);
        }
        return "unnamed";
    }

    public List<W2flow> findflows(String object, String string, RmiFileManager rmiFileManager) {
        ArrayList<W2flow> arrayList = new ArrayList<W2flow>();
        string = string.concat("/").concat("control_file_read_write.exe");
        string = string.replace("\\", "/");
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = string;
        stringArray2[1] = "\"" + (String)object + "\"";
        string = this.executeProcess(stringArray2);
        if (string.getExitCode() != 0) {
            System.out.println("findflows:error running " + stringArray2[0] + " Exit code=" + string.getExitCode());
            object = string.getProcessOutput();
            for (int i = 0; i < object.size(); ++i) {
                System.out.println("\t" + (String)object.get(i));
            }
            return arrayList;
        }
        this.readFlowTable((String)object, rmiFileManager, arrayList);
        return arrayList;
    }

    private ProcessOutput executeProcess(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            ProcessOutput processOutput = new ProcessOutput(stringArray);
            processOutput.setExitCode(-1);
            processOutput.addProcessOutput(new ProcessOutputLine("No command specified", true));
            return processOutput;
        }
        Object object = System.getSecurityManager();
        Vector vector = new Vector(100);
        new ArrayList(2);
        try {
            ((SecurityManager)object).checkExec(stringArray[0]);
        }
        catch (SecurityException securityException) {
            System.out.println("exec: Security EXCEPTION on cmd [" + stringArray[0] + "] error " + String.valueOf(securityException));
            ProcessOutput processOutput = new ProcessOutput(stringArray);
            processOutput.setExitCode(-1);
            processOutput.addProcessOutput(new ProcessOutputLine("Security EXCEPTION on cmd [" + stringArray[0] + "] error " + String.valueOf(securityException), true));
            return processOutput;
        }
        int n = RMAIO.getOSType();
        System.out.println("OS Type is " + n);
        try {
            ProcessOutput processOutput;
            object = null;
            if (n == 0 || n == 1) {
                stringArray[0] = stringArray[0].replace('/', File.separatorChar);
                if (!stringArray[0].startsWith("start ") && !stringArray[0].endsWith(".exe")) {
                    String[] stringArray2 = new String[stringArray.length + 2];
                    System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
                    stringArray2[0] = "cmd";
                    stringArray2[1] = "/c";
                    stringArray = stringArray2;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println("exec:" + stringArray[i]);
                }
                processOutput = new ProcessOutput(stringArray);
                object = Runtime.getRuntime().exec(stringArray);
            } else if (n == 2) {
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = stringArray[n].replace('\\', File.separatorChar);
                }
                System.out.println("exec:Command is:");
                for (n = 0; n < stringArray.length; ++n) {
                    System.out.println("\t" + n + " " + stringArray[n]);
                }
                processOutput = new ProcessOutput(stringArray);
                object = Runtime.getRuntime().exec(stringArray);
            } else if (n == 1) {
                int n2;
                String[] stringArray3 = new String[stringArray.length + 2];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray3[n2 + 2] = stringArray[n2].replace('/', File.separatorChar);
                }
                stringArray3[0] = "start";
                stringArray3[1] = "/wait";
                stringArray = stringArray3;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    System.out.println("exec:" + stringArray3[n2]);
                }
                processOutput = new ProcessOutput(stringArray);
                object = Runtime.getRuntime().exec(stringArray3);
            } else {
                System.out.println("Unknown OS Type " + n);
                processOutput = new ProcessOutput(stringArray);
                processOutput.addProcessOutput(new ProcessOutputLine("Unknown OS Type " + n + " " + System.getProperty("os.name"), true));
                processOutput.setExitCode(-1);
            }
            if (object != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(((Process)object).getErrorStream()));
                new ProcessOutputReader(bufferedReader, vector, "stdout", false, false);
                new ProcessOutputReader(bufferedReader2, vector, "stderr", false, true);
                ((Process)object).waitFor();
                int n3 = ((Process)object).exitValue();
                processOutput.setExitCode(n3);
                System.out.println("exec:Process Exited with " + n3);
                processOutput.setProcessOutput(vector);
            }
            return processOutput;
        }
        catch (Exception exception) {
            String string = Arrays.toString(stringArray);
            System.out.println("exec:Unable to exec cmd ->" + string + "<-");
            System.out.println("exec:Exception: " + exception.getMessage());
            exception.printStackTrace();
            ProcessOutput processOutput = new ProcessOutput(stringArray);
            processOutput.addProcessOutput(new ProcessOutputLine("Unable to exec cmd " + string + " Error:" + exception.getMessage(), true));
            processOutput.setExitCode(-1);
            return processOutput;
        }
    }

    private boolean readFlowTable(String object, RmiFileManager object2, List<W2flow> list) {
        object = ((String)object).concat("/").concat("table_inflows_outflows.opt");
        Identifier identifier = new Identifier((String)object);
        try {
            object2 = object2.openFile(UserId.getUserId(), identifier);
        }
        catch (RemoteException remoteException) {
            System.out.println("readTableFile:RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return false;
        }
        if (object2 == null) {
            System.out.println("readTableFile:failed to find table file " + (String)object);
            return false;
        }
        object = object2.getFile().getBufferedReader();
        try {
            ((BufferedReader)object).readLine();
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                if ((object2 = W2flow.parseTableLine((String)object2)) == null) continue;
                if (((W2flow)object2).getCount() > 1 && list.size() > 0) {
                    List<W2flow> list2 = list;
                    if (((W2flow)object2).equals(list2.get(list2.size() - 1))) continue;
                }
                list.add((W2flow)object2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException " + String.valueOf(iOException));
                    iOException.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<W2flow> findflowsOld(Identifier identifier, String string, RmiFileManager rmiFileManager) {
        String string2;
        ArrayList<W2flow> arrayList = new ArrayList<W2flow>();
        Object object = identifier.getFile();
        if (object == null) {
            return arrayList;
        }
        if ((object = object.getBufferedReader()) == null) {
            return arrayList;
        }
        int n = 0;
        while ((string2 = ((BufferedReader)object).readLine()) != null) {
            if ((string2 = string2.toLowerCase()).startsWith("qin file.")) {
                this.readflows(arrayList, (BufferedReader)object, string, "Inflow", rmiFileManager);
                ++n;
            }
            if (string2.startsWith("qot file.")) {
                this.readflows(arrayList, (BufferedReader)object, string, "Outflow", rmiFileManager);
                ++n;
            }
            if (n < 2) continue;
        }
        if (object == null) return arrayList;
        try {
            ((BufferedReader)object).close();
            return arrayList;
        }
        catch (IOException iOException) {}
        return arrayList;
        catch (IOException iOException) {
            try {
                System.out.println("findInflows:error reading control file " + identifier.getPath() + " Error:" + String.valueOf(iOException));
                if (object == null) return arrayList;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((BufferedReader)object).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((BufferedReader)object).close();
                return arrayList;
            }
            catch (IOException iOException3) {}
            return arrayList;
        }
    }

    private void readflows(List<W2flow> list, BufferedReader bufferedReader, String string, String string2, RmiFileManager rmiFileManager) throws IOException {
        Object object;
        while ((object = bufferedReader.readLine()) != null) {
            if (((String)(object = ((String)object).trim())).length() == 0) {
                return;
            }
            String string3 = RMAIO.getType((String)object, (String)" ");
            object = RMAIO.getParam((String)object, (String)" ");
            if (!rmiFileManager.fileExists((String)(object = string + "/" + (String)object))) continue;
            list.add(new W2flow(string3, (String)object, "", "Flow", string2, 1, "m^3/s"));
        }
    }

    public W2Model clone() {
        try {
            int n;
            W2Model w2Model = (W2Model)super.clone();
            ((W2Model)super.clone())._dssMapping = new ArrayList<W2DssConnection>(this._dssMapping.size());
            for (int i = 0; i < this._dssMapping.size(); ++i) {
                W2DssConnection w2DssConnection = this._dssMapping.get(i);
                w2DssConnection = w2DssConnection.clone();
                w2Model._dssMapping.add(w2DssConnection);
            }
            w2Model._tsrMapping = new ArrayList<W2OutputConnection>(this._tsrMapping.size());
            for (n = 0; n < this._tsrMapping.size(); ++n) {
                W2OutputConnection w2OutputConnection = this._tsrMapping.get(n);
                w2OutputConnection = w2OutputConnection.clone();
                w2Model._tsrMapping.add(w2OutputConnection);
            }
            w2Model._profileMapping = new ArrayList<W2OutputConnection>(this._profileMapping.size());
            for (n = 0; n < this._profileMapping.size(); ++n) {
                W2OutputConnection w2OutputConnection = this._profileMapping.get(n);
                w2OutputConnection = w2OutputConnection.clone();
                w2Model._profileMapping.add(w2OutputConnection);
            }
            if (this._restartInfo != null) {
                w2Model._restartInfo = this._restartInfo.clone();
            }
            return w2Model;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("clone:" + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public boolean copyModel(W2Model w2Model) {
        w2Model = w2Model.clone();
        this._dssMapping = w2Model.getDssMapping();
        this._habitatVolumeData = w2Model.getHabitatData();
        this._runHabitatVolume = w2Model.shouldRunHabitatVolume();
        this._tsrMapping = w2Model.getTsrMapping();
        this._profileMapping = w2Model.getProfileMapping();
        this._w2Exe = w2Model.getW2Exe();
        this._execute = w2Model.shouldExecute();
        this._runHabitatVolume = w2Model.shouldRunHabitatVolume();
        this._runSelWithdrawal = w2Model.shouldRunSelectiveWithdrawal();
        this._selWithdrawalData = w2Model.getSelectiveWithdrawalData();
        this._runDssOut = w2Model.shouldRunDssOut();
        this._runBCBatchFile = w2Model.shouldRunBCBatchFile();
        this._restartInfo = w2Model.getRestartInfo();
        return true;
    }

    public void setW2BcMapping(List<W2BcConnection> list) {
        this._bcMapping.clear();
        if (list == null) {
            return;
        }
        this._bcMapping.addAll(list);
    }

    public List<W2BcConnection> getW2BcMapping() {
        ArrayList<W2BcConnection> arrayList = new ArrayList<W2BcConnection>();
        arrayList.addAll(this._bcMapping);
        return arrayList;
    }

    public void setTsrMapping(List<W2OutputConnection> list) {
        this._tsrMapping.clear();
        if (list == null) {
            return;
        }
        this._tsrMapping.addAll(list);
    }

    public List<W2OutputConnection> getTsrMapping() {
        ArrayList<W2OutputConnection> arrayList = new ArrayList<W2OutputConnection>();
        arrayList.addAll(this._tsrMapping);
        return arrayList;
    }

    public List<W2OutputConnection> getTsrMapping(String string) {
        ArrayList<W2OutputConnection> arrayList = new ArrayList<W2OutputConnection>();
        for (int i = 0; i < this._tsrMapping.size(); ++i) {
            W2OutputConnection w2OutputConnection = this._tsrMapping.get(i);
            if (!w2OutputConnection.getResSimName().equalsIgnoreCase(string)) continue;
            arrayList.add(w2OutputConnection);
        }
        return arrayList;
    }

    public List<W2OutputConnection> getProfileMapping(String string) {
        ArrayList<W2OutputConnection> arrayList = new ArrayList<W2OutputConnection>();
        for (int i = 0; i < this._profileMapping.size(); ++i) {
            W2OutputConnection w2OutputConnection = this._profileMapping.get(i);
            if (!w2OutputConnection.getResSimName().equalsIgnoreCase(string)) continue;
            arrayList.add(w2OutputConnection);
        }
        return arrayList;
    }

    public void setProfileMapping(List<W2OutputConnection> list) {
        this._profileMapping.clear();
        if (list == null) {
            return;
        }
        this._profileMapping.addAll(list);
    }

    public List<W2OutputConnection> getProfileMapping() {
        ArrayList<W2OutputConnection> arrayList = new ArrayList<W2OutputConnection>();
        arrayList.addAll(this._profileMapping);
        return arrayList;
    }

    private boolean scanControlFile() {
        Object object;
        this._miscellLine = "";
        if (this._controlFilename == null || this._controlFilename.length() == 0) {
            return false;
        }
        String string = this._controlFilename;
        string = this._alt.makeAbsolutePath(string);
        Object object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (!object2.fileExists(string)) {
                return false;
            }
            object = new Identifier(string);
            if ((object2 = object2.openFile(UserId.getUserId(), (Identifier)object)) == null) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("scanControlFile:RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return false;
        }
        if (object2 == null) {
            System.out.println("scanControlFile:failed to find W2 control file " + string);
            return false;
        }
        object = object2.getFile().getBufferedReader();
        try {
            ((BufferedReader)object).readLine();
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.indexOf("HABTATC") < 0) continue;
                string = ((BufferedReader)object).readLine();
                object2 = (string = string.toUpperCase()).substring(24, 32);
                this._w2HabitatC_On = object2.indexOf("ON") >= 0;
                object2 = string.substring(16, 24);
                this._w2SelectC_On = object2.indexOf("ON") >= 0;
                this._miscellLine = string;
                System.out.println(" Control line:" + string);
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException " + String.valueOf(iOException));
                    iOException.printStackTrace();
                }
            }
        }
        return true;
    }

    public String getMiscellLine() {
        this.scanControlFile();
        return this._miscellLine;
    }

    public List scanSelectiveWithdrawalFile() {
        if (this._controlFilename == null || this._controlFilename.length() == 0) {
            return null;
        }
        String string = this._controlFilename;
        string = this._alt.makeAbsolutePath(string);
        Object object = RMAIO.getDirectoryFromPath((String)string) + "/";
        object = (String)object + SELECTIVE_WITHDRAWAL_FILE;
        Object object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (!object2.fileExists((String)object)) {
                return null;
            }
            object = new Identifier((String)object);
            object = object2.openFile(UserId.getUserId(), (Identifier)object);
            if (object == null) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("scanSelectiveWithdrawalFile:RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return null;
        }
        if (object == null) {
            System.out.println("scanSelectiveWithdrawalFile:failed to find W2 control file " + string);
            return null;
        }
        object = object.getFile().getBufferedReader();
        object2 = new Vector();
        try {
            while ((string = ((BufferedReader)object).readLine()) != null) {
                object2.add(string);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException " + String.valueOf(iOException));
                    iOException.printStackTrace();
                }
            }
        }
        return object2;
    }

    public void setRunBCBatchFile(boolean bl) {
        this._runBCBatchFile = bl;
    }

    public boolean shouldRunBCBatchFile() {
        return this._runBCBatchFile;
    }

    public void setRunDssOut(boolean bl) {
        this._runDssOut = bl;
    }

    public boolean shouldRunDssOut() {
        return this._runDssOut;
    }

    public boolean shouldExecute() {
        return this._execute;
    }

    public void setShouldExecute(boolean bl) {
        this._execute = bl;
    }

    public boolean shouldRunHabitatVolume() {
        this.scanControlFile();
        return this._runHabitatVolume;
    }

    public void setShouldRunHabitatVolume(boolean bl) {
        this._runHabitatVolume = bl;
    }

    public boolean shouldRunSelectiveWithdrawal() {
        return this._runSelWithdrawal;
    }

    public void setShouldRunSelectiveWithdrawal(boolean bl) {
        this._runSelWithdrawal = bl;
    }
}

