/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.w2.server;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ComputeInfo;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.server.HecRmiWorkspaceImpl;
import hec.clientapp.server.RmiWorkspaceImpl;
import hec.heclib.util.HecTime;
import hec.io.DSSArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.ProcessOutput;
import hec.io.ProcessOutputReader;
import hec.lang.Logger;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.map.MapIdentifier;
import hec.map.WorldRect;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.w2.W2RmiWorkspace;
import hec.rss.plugins.w2.io.DssOutput;
import hec.rss.plugins.w2.model.DateTimeFrequencyRecord;
import hec.rss.plugins.w2.model.FishGroup;
import hec.rss.plugins.w2.model.HabitatData;
import hec.rss.plugins.w2.model.SelectiveWithdrawalData;
import hec.rss.plugins.w2.model.W2Alt;
import hec.rss.plugins.w2.model.W2BcConnection;
import hec.rss.plugins.w2.model.W2DssConnection;
import hec.rss.plugins.w2.model.W2Model;
import hec.rss.plugins.w2.model.W2RestartInfo;
import hec.rss.plugins.w2.server.W2RmiWorkspaceImpl$FilePosition;
import hec.rss.plugins.w2.server.W2RmiWorkspaceImpl$JulTimeData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.lang.NestingException;
import rma.text.PrintfFormat;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class W2RmiWorkspaceImpl
extends RmiWorkspaceImpl
implements W2RmiWorkspace {
    private String _exeFolder;

    public W2RmiWorkspaceImpl(int n) throws RemoteException {
        super(n);
        this._typeOfWorkspace = "w2";
    }

    public W2RmiWorkspaceImpl(Integer n) throws RemoteException {
        this((int)n);
    }

    public W2RmiWorkspaceImpl(String string, Identifier identifier) throws RemoteException {
        this(8089);
        this.setIdentifier(string, identifier);
        this._lockedBy = string;
        try {
            this.addUser(string);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
            return;
        }
    }

    public boolean load() {
        HecFile hecFile = this.identifier.getFile();
        if (hecFile != null) {
            this.readConfiguration(hecFile);
            return true;
        }
        return false;
    }

    protected synchronized void readConfiguration(HecFile object) {
        if (object == null) {
            return;
        }
        if (!object.canRead()) {
            return;
        }
        boolean bl = Logger.canDebug((String)"rmiworkspace");
        object = object.getBufferedReader();
        try {
            Object object2 = ((BufferedReader)object).readLine();
            while (object2 != null) {
                object2 = ((String)object2).trim();
                if (bl) {
                    System.out.println((String)object2);
                }
                if (((String)object2).indexOf("MapBegin") >= 0) {
                    this.readMap((BufferedReader)object);
                } else if (((String)object2).indexOf("ManagerProxyBegin") >= 0) {
                    this.readManagerProxy((BufferedReader)object);
                } else {
                    String string = RMAIO.getType((String)object2, (String)"=");
                    object2 = RMAIO.getParam((String)object2, (String)"=");
                    if (string.compareTo("WorkspaceName") == 0) {
                        this.setName((String)object2);
                        this.identifier.setName((String)object2);
                    } else if (string.compareTo("WorkspaceDescription") == 0) {
                        this.identifier.setDescription((String)object2);
                    } else if (string.compareTo("W2ExeFolder") == 0) {
                        this._exeFolder = this.makeAbsolutePath((String)object2);
                    } else if (string.compareTo("Extents") == 0) {
                        object2 = new StringTokenizer((String)object2, ",");
                        string = ((StringTokenizer)object2).nextToken();
                        String string2 = ((StringTokenizer)object2).nextToken();
                        String string3 = ((StringTokenizer)object2).nextToken();
                        object2 = ((StringTokenizer)object2).nextToken();
                        double d = new Double(string);
                        double d2 = new Double(string2);
                        double d3 = new Double(string3);
                        double d4 = new Double((String)object2);
                        this._extents = new WorldRect(d, d4, d2, d3);
                    }
                }
                object2 = ((BufferedReader)object).readLine();
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.out.println("Error reading in RSS data file  " + String.valueOf(exception));
        }
        W2RmiWorkspaceImpl w2RmiWorkspaceImpl = this;
        w2RmiWorkspaceImpl.createDefaultDataLists((RmiDataListContainer)w2RmiWorkspaceImpl.getDataListContainer());
    }

    public void saveWorkspace(String string) throws RemoteException {
        string = this.identifier.getFile();
        if (string != null) {
            System.out.println("Save the Workspace " + this.getTitleName());
            this.writeConfiguration((HecFile)string);
            return;
        }
        System.out.println("Workspace " + this.getTitleName() + " not Saved.");
    }

    public void closeWorkspace(String string) throws RemoteException {
        System.out.println("Save and Close the Workspace");
        this.saveWorkspace(string);
        this.removeUser(string);
        if (this._listOfUsers.size() <= 0) {
            if (!this._local) {
                try {
                    Naming.unbind(this.stringUrl + this.getName());
                }
                catch (Throwable throwable) {
                    System.out.println("Exception trying to Close the Workspace");
                    System.out.println(throwable.getMessage() + "...." + throwable.toString());
                    throwable.printStackTrace(System.out);
                }
            }
            System.gc();
        }
    }

    public int computeAlternative(ComputeInfo computeInfo) throws RemoteException, NestingException {
        W2Model w2Model;
        Object object;
        Object object2 = this.getExeFolder();
        if (object2 == null) {
            this.printErrorMessage(computeInfo.uiWrapper, "No CE-QUAL-W2 Executable directory defined");
            return 2;
        }
        this.setProgress(computeInfo.uiWrapper, 0);
        try {
            object = computeInfo.modelRef;
            if (object == null) {
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ModelReference for " + computeInfo.modelAltname);
                System.out.println("w2.computeAlternative: no ModelReference in ComputeInfo");
                return 2;
            }
            try {
                Manager manager = this._managerProxys.openManager(((ModelReference)object).wkspName, ((ModelReference)object).className, ((ModelReference)object).newId);
                if (!(manager instanceof W2Alt)) {
                    System.out.println("w2.computeAlternative: failed to get an MfpAlternative for " + String.valueOf(object));
                    if (manager != null) {
                        System.out.println("w2.computeAlternative: got a " + manager.getClass().getName() + " instead");
                    }
                    this.printErrorMessage(computeInfo.uiWrapper, "Failed to load W2 Alternative for " + computeInfo.modelAltname);
                    return 2;
                }
                object2 = (W2Alt)manager;
            }
            catch (Exception exception) {
                System.out.println("w2.computeAlternative: Error loading " + String.valueOf(object) + " Error:" + String.valueOf(exception));
                exception.printStackTrace();
                this.printErrorMessage(computeInfo.uiWrapper, "Error loading W2Alternative for " + computeInfo.modelAltname);
                return 2;
            }
            if (object2 == null) {
                System.out.println("Failed to load W2 Alt " + computeInfo.modelAltname + " ModelRef=" + String.valueOf(computeInfo.modelRef));
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to load W2 Alternative " + computeInfo.modelAltname);
                return 2;
            }
        }
        catch (Exception exception) {
            System.out.println("w2.computeAlternative: Exception getting W2Alternative " + String.valueOf(exception));
            this.printErrorMessage(computeInfo.uiWrapper, "Exception retrieving W2Alternative");
            return 2;
        }
        this.setProgress(computeInfo.uiWrapper, 5);
        object = ((W2Alt)((Object)object2)).getModelList();
        int n = 0;
        for (int i = 0; i < object.size(); ++i) {
            w2Model = (W2Model)object.get(i);
            if (!w2Model.shouldExecute()) continue;
            ++n;
        }
        this.printMessage(computeInfo.uiWrapper, n + " W2 Models to run");
        if (n == 0) {
            this.setProgress(computeInfo.uiWrapper, 100);
            return 0;
        }
        double d = 95.0 / (double)n;
        n = (int)d;
        for (int i = 0; i < object.size(); ++i) {
            w2Model = (W2Model)object.get(i);
            if (!w2Model.shouldExecute()) continue;
            if (this.computeModel((W2Alt)((Object)object2), (W2Model)object.get(i), computeInfo) == 2) {
                return 2;
            }
            this.setProgress(computeInfo.uiWrapper, n);
            n = (int)((double)n + d);
        }
        this.setProgress(computeInfo.uiWrapper, 100);
        return 0;
    }

    protected int computeModel(W2Alt object, W2Model w2Model, ComputeInfo computeInfo) {
        this.printMessage(computeInfo.uiWrapper, "Running CE-QUAL-W2 model " + String.valueOf(w2Model));
        Object object2 = w2Model.getControlFilename();
        Object object3 = w2Model.getW2Exe();
        if (object2 == null || ((String)object2).length() == 0) {
            System.out.println("w2.computeAlternative: No W2 Control file defined for " + String.valueOf(object));
            this.printErrorMessage(computeInfo.uiWrapper, "No W2 Control file defined for " + String.valueOf(object));
            return 2;
        }
        if (object3 == null || ((String)object3).length() == 0) {
            System.out.println("w2.computeAlternative: No W2 executable defined for " + String.valueOf(object));
            this.printErrorMessage(computeInfo.uiWrapper, "No W2 executable defined for " + String.valueOf(object));
            return 2;
        }
        this.printMessage(computeInfo.uiWrapper, "Running CE-QUAL-W2 " + (String)object2);
        object2 = computeInfo.forecastpath + "/" + (String)object2;
        String string = RMAIO.getDirectoryFromPath((String)object2);
        if (!RMAIO.isFullPath((String)object3)) {
            object3 = string + "/" + (String)object3;
        }
        try {
            if (!this.getFileManager().fileExists((String)object3)) {
                this.printErrorMessage(computeInfo.uiWrapper, "Missing CE-QUAL-W2 executable " + (String)object3);
                return 2;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
        }
        if (Boolean.getBoolean("NoW2DssIn") ? !this.editW2Files((W2Alt)((Object)object), w2Model, (String)object2, computeInfo) : !this.writeDssInFile((W2Alt)((Object)object), w2Model, (String)object2, computeInfo)) {
            return 2;
        }
        if (!this.editControlFile(w2Model, (String)object2, computeInfo)) {
            return 2;
        }
        String string2 = "control_file_read_write.exe";
        W2RmiWorkspaceImpl w2RmiWorkspaceImpl = this;
        int n = w2RmiWorkspaceImpl.launchExe(w2RmiWorkspaceImpl.getExeFolder() + "/" + string2, string, computeInfo);
        if (n != 0) {
            return 2;
        }
        List<W2Model> list = object.getModelList();
        if (w2Model == list.get(0)) {
            w2Model.setRunBCBatchFile(false);
        }
        if (w2Model.shouldRunBCBatchFile() && !this.copyBcFiles((W2Alt)((Object)object), w2Model, string, computeInfo)) {
            return 2;
        }
        this.printMessage(computeInfo.uiWrapper, "Working Directory: " + string);
        this.printLogMessage(computeInfo.uiWrapper, "CE-QUAL-W2 executable is " + (String)object3);
        int n2 = this.launchExe((String)object3, string, computeInfo);
        if (n2 == 0) {
            object = RMAIO.getDirectoryFromPath((String)object2);
            boolean bl = this.checkErrorFile((String)(object = (String)object + "/w2.err"), computeInfo);
            if (bl && w2Model.shouldRunDssOut() && !this.editDssOutFile(w2Model, (String)object2, computeInfo)) {
                return 2;
            }
            if (bl) {
                return 0;
            }
            return 2;
        }
        object = RMAIO.getDirectoryFromPath((String)object2);
        object = (String)object + "/w2.err";
        this.checkErrorFile((String)object, computeInfo);
        return 2;
    }

    @Override
    public boolean editDssOutFile(W2Model object, String list, ComputeInfo computeInfo) {
        object = RMAIO.getDirectoryFromPath((String)((Object)list));
        list = ((String)object).concat("/").concat("dssout.npt");
        Object object2 = new Identifier((String)((Object)list));
        try {
            object2 = this.getFileManager().openFile(UserId.getUserId(), (Identifier)object2);
            if (object2 == null) {
                if (computeInfo != null) {
                    this.printWarningMessage(computeInfo.uiWrapper, "No dssout.npt to run.");
                } else {
                    System.out.println("editDssOutFile:No dssout.npt to run.");
                }
                return false;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("editDssOutFile:Error opening " + (String)((Object)list) + " Error:" + String.valueOf(remoteException));
            return false;
        }
        if (computeInfo != null) {
            this.printLogMessage(computeInfo.uiWrapper, "Editing dssout file " + (String)((Object)list));
        } else {
            System.out.println("editDssOutFile:Editing dssout file " + (String)((Object)list));
        }
        object2 = new DssOutput((Identifier)object2);
        if (!((DssOutput)object2).readDssOutFile()) {
            System.out.println("editDssOutFile:failed to read dssout.npt");
            if (computeInfo != null) {
                this.printWarningMessage(computeInfo.uiWrapper, "Failed to read dssout.npt");
            }
            return false;
        }
        if (computeInfo != null) {
            list = computeInfo.forecastpath + "/" + computeInfo.outputDSSFileName;
            int n = ((String)((Object)(list = RMAIO.getRelativePath((String)object, (String)((Object)list), (boolean)true, (boolean)false)))).lastIndexOf(46);
            if (n >= 0) {
                list = ((String)((Object)list)).substring(0, n);
            }
            list = ((String)((Object)list)).replace("/".charAt(0), File.separatorChar);
            ((DssOutput)object2).setDssFile((String)((Object)list));
            list = ((DssOutput)object2).getDssOutData();
            String string = computeInfo.modelAltname.substring(0, computeInfo.modelPosition * computeInfo.nameMultiplier);
            ((DssOutput)object2).setYear(String.valueOf(computeInfo.runTimeWindow.getStartTime().year()));
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setFPart(string);
            }
        }
        if (((DssOutput)object2).writeDssOutFile()) {
            return this.runDssOutExe((String)object, computeInfo);
        }
        return false;
    }

    private boolean runCopyBCBatchFile(W2Alt object, String string, ComputeInfo computeInfo) {
        int n;
        String string2 = RMAIO.getFileFromPath((String)string);
        String string3 = string.concat("/").concat("copyBc.bat");
        try {
            if (!this.getFileManager().fileExists(string3)) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("runCopyBCBatchFile: RemoteException " + String.valueOf(remoteException));
            return false;
        }
        this.printMessage(computeInfo.uiWrapper, "Running batch file " + string3);
        object = ((W2Alt)((Object)object)).getModelList();
        String[] stringArray = new String[object.size() + 1];
        String[] stringArray2 = stringArray;
        stringArray[0] = string3;
        for (n = 0; n < object.size(); ++n) {
            stringArray2[n + 1] = string2 + "-" + ((W2Model)object.get(n)).getName();
        }
        n = this.launchExe(stringArray2, string, computeInfo);
        return n == 0;
    }

    private boolean copyBcFiles(W2Alt w2Alt, W2Model object, String string, ComputeInfo computeInfo) {
        if ((object = ((W2Model)object).getW2BcMapping()) == null || object.size() <= 0) {
            return false;
        }
        this.printMessage(computeInfo.uiWrapper, "\nCopying BC files ... ");
        for (int i = 0; i < object.size(); ++i) {
            boolean bl;
            Object object2 = (W2BcConnection)object.get(i);
            String string2 = ((W2BcConnection)object2).getW2DownstreamFile();
            object2 = ((W2BcConnection)object2).getW2UpstreamFile();
            if (string2 == null || string2.length() <= 1 || object2 == null || ((String)object2).length() <= 1) continue;
            String string3 = w2Alt.makeAbsolutePath((String)object2);
            String string4 = w2Alt.makeAbsolutePath(string2);
            string3 = new Identifier(string3);
            string4 = new Identifier(string4);
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                bl = rmiFileManager.copyFile((Identifier)string3, (Identifier)string4);
            }
            catch (RemoteException remoteException) {
                System.out.println("createDssInFile: ****ERROR RemoteException " + String.valueOf(remoteException));
                return false;
            }
            this.printMessage(computeInfo.uiWrapper, "From File: " + (String)object2 + "\nTo File:   " + string2 + "   Success=" + bl);
            if (i != object.size()) continue;
            this.printMessage(computeInfo.uiWrapper, "");
        }
        return true;
    }

    private boolean editControlFile(W2Model w2Model, String string, ComputeInfo computeInfo) {
        double d;
        BufferedWriter bufferedWriter;
        boolean bl;
        Object object;
        string = RMAIO.getDirectoryFromPath((String)string);
        string = string.concat("/").concat("changes.npt");
        string = new Identifier(string);
        try {
            object = this.getFileManager().openFile(UserId.getUserId(), (Identifier)string);
        }
        catch (RemoteException remoteException) {
            System.out.println("RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
            return false;
        }
        if (object == null) {
            try {
                object = this.getFileManager().newFile(UserId.getUserId(), (Identifier)string);
            }
            catch (RemoteException remoteException) {
                System.out.println("RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
            }
            if (object == null) {
                System.out.println("editControlFileTimeWindow:failed to open/create changes file " + string.getPath());
                return false;
            }
        }
        if (bl = this.editControlFileTimeWindow(bufferedWriter = object.getFile().getBufferedWriter(), computeInfo)) {
            bl = this.editControlFileMiscellLine(bufferedWriter, w2Model, computeInfo);
        }
        if (bl && (object = w2Model.getHabitatData()) != null && w2Model.shouldRunHabitatVolume() && ((HabitatData)object).getNumberOfFishGroups() > 0) {
            bl = this.editControlFileHabitatVolume(bufferedWriter, (HabitatData)object, computeInfo);
        }
        if (bl && (object = w2Model.getSelectiveWithdrawalData()) != null && w2Model.shouldRunSelectiveWithdrawal() && RMAConst.isValidValue((double)(d = ((SelectiveWithdrawalData)object).getTargetTemperature()))) {
            bl = this.editControlFileSelectiveWithdrawal(bufferedWriter, w2Model, (SelectiveWithdrawalData)object, computeInfo);
        }
        if (bl && (object = w2Model.getRestartInfo()) != null) {
            bl = this.editControlFileRestartOptions(bufferedWriter, w2Model, (W2RestartInfo)object, computeInfo);
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private boolean editControlFileTimeWindow(BufferedWriter bufferedWriter, ComputeInfo computeInfo) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("         ");
        HecTime hecTime = computeInfo.runTimeWindow.getStartTime();
        hecTime.showTimeAsBeginningOfDay(true);
        System.out.println("editControlFileTimeWindow:start time=" + String.valueOf(hecTime));
        int n2 = hecTime.dayOfYear();
        String string = String.valueOf(n2);
        System.out.println("editControlFileTimeWindow:julian=" + string);
        int n3 = hecTime.secondsSinceMidnight();
        if (n3 == 0 || n3 == 86400) {
            string = string.concat(".000");
        } else {
            double d = (double)(n3 /= 60) / 1440.0;
            String string2 = RMAIO.setPrecision2((double)d, (int)3);
            System.out.println("editControlFileTimeWindow:minutes=" + string2);
            int n4 = string2.indexOf(46);
            if (n4 > 0) {
                string2 = string2.substring(n4);
            }
            string = string.concat(string2);
        }
        System.out.println("editControlFileTimeWindow:start=" + string);
        string = RMAIO.leftJustify((int)7, (String)string).toString();
        System.out.println("editControlFileTimeWindow:justified start=" + string);
        stringBuffer.append(string);
        HecTime hecTime2 = computeInfo.runTimeWindow.getEndTime();
        System.out.println("editControlFileTimeWindow:end time=" + String.valueOf(hecTime));
        int n5 = hecTime2.dayOfYear();
        String string3 = String.valueOf(n5);
        System.out.println("editControlFileTimeWindow:julian=" + string3);
        int n6 = hecTime2.secondsSinceMidnight();
        if (n6 == 0) {
            string3 = string3.concat(".000");
        } else {
            n = n6 / 60;
            double d = (double)n / 1440.0;
            if (d == 1.0) {
                string3 = String.valueOf(++n5);
                string3 = string3.concat(".000");
            } else {
                String string4 = RMAIO.setPrecision2((double)d, (int)3);
                n6 = string4.indexOf(46);
                if (n6 > 0) {
                    string4 = string4.substring(n6);
                }
                System.out.println("editControlFileTimeWindow:minutes=" + string4);
                string3 = string3.concat(string4);
            }
        }
        System.out.println("editControlFileTimeWindow:end=" + string3);
        string3 = RMAIO.leftJustify((int)8, (String)string3).toString();
        System.out.println("editControlFileTimeWindow:justified end=" + string3);
        stringBuffer.append(string3);
        n = hecTime.year();
        String string5 = String.valueOf(n);
        System.out.println("editControlFileTimeWindow:year=" + string5);
        string5 = RMAIO.leftJustify((int)8, (String)string5).toString();
        System.out.println("editControlFileTimeWindow:justified year=" + string5);
        stringBuffer.append(string5);
        try {
            bufferedWriter.write("TIME CON  TMSTRT   TMEND    YEAR");
            bufferedWriter.newLine();
            String string6 = stringBuffer.toString();
            System.out.println("editControlFileTimeWindow:time buffer='" + string6 + "'");
            bufferedWriter.write(string6);
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: Time Window. Error=" + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    private boolean editControlFileMiscellLine(BufferedWriter bufferedWriter, W2Model w2Model, ComputeInfo computeInfo) {
        String string = w2Model.getMiscellLine();
        if (string.trim().length() <= 0) {
            return false;
        }
        string = string.toUpperCase();
        String string2 = string.substring(24, 32);
        String string3 = string.substring(16, 24);
        boolean bl = false;
        boolean bl2 = false;
        if (string2.indexOf("ON") >= 0) {
            bl = true;
        }
        if (string3.indexOf("ON") >= 0) {
            bl2 = true;
        }
        boolean bl3 = w2Model.shouldRunHabitatVolume();
        boolean bl4 = w2Model.shouldRunSelectiveWithdrawal();
        if (bl3 == bl && bl4 == bl2) {
            return true;
        }
        string2 = "     OFF";
        if (bl3) {
            string2 = "      ON";
        }
        String string4 = "     OFF";
        if (bl4) {
            string4 = "      ON";
        }
        String string5 = string.substring(0, 16) + string4 + string2 + string.substring(32);
        try {
            string2 = "MISCELL     NDAY SELECTC HABTATC ENVIRPC AERATEC INITUWL";
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.write(string5);
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            System.out.println(string);
            System.out.println(string5);
        }
        catch (IOException iOException) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: MISCELL Line. Error=" + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    private boolean editControlFileHabitatVolume(BufferedWriter bufferedWriter, HabitatData object, ComputeInfo computeInfo) {
        List<FishGroup> list = ((HabitatData)object).getFishGroupList();
        int n = list.size();
        object = ((HabitatData)object).getOptFile();
        ((String)object).trim().length();
        object = ((String)object).trim().length() < 0 ? "'habitat.opt'" : "'" + (String)object + "'";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object2 = "#FISH CRITERIA, OUTPUTFILENAME  ,,";
            bufferedWriter.write((String)object2);
            bufferedWriter.newLine();
            stringBuffer.append(n);
            stringBuffer.append("," + (String)object + ",,");
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
            object2 = "NAMES OF FISH, TEMP-low, TEMP-high, DO limits ";
            bufferedWriter.write((String)object2);
            bufferedWriter.newLine();
            for (int i = 0; i < n; ++i) {
                stringBuffer.setLength(0);
                object2 = list.get(i);
                stringBuffer.append("'" + ((FishGroup)object2).getGroupName() + "',");
                stringBuffer.append(((FishGroup)object2).getMinTemp() + ",");
                stringBuffer.append(((FishGroup)object2).getMaxTemp() + ",");
                stringBuffer.append(((FishGroup)object2).getMinDO());
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: HabitatVolume. Error=" + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    private boolean editControlFileSelectiveWithdrawal(BufferedWriter bufferedWriter, W2Model object, SelectiveWithdrawalData object2, ComputeInfo computeInfo) {
        double d = ((SelectiveWithdrawalData)object2).getTargetTemperature();
        if ((object = ((W2Model)object).scanSelectiveWithdrawalFile()) == null || object.size() <= 0) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: Selective Withdrawal.");
            object2 = "Check that a w2_selective.npt file exist";
            this.printErrorMessage(computeInfo.uiWrapper, (String)object2);
            return false;
        }
        int n = 0;
        this.printMessage(computeInfo.uiWrapper, "W2 - Updating Selective Withdrawal ");
        try {
            while (n < object.size()) {
                object2 = ((String)object.get(n)).toUpperCase();
                ++n;
                if (((String)object2).indexOf("SPLIT1") < 0) continue;
                object2 = (String)object.get(n);
                ++n;
                Object object3 = ((String)object2).substring(16, 24);
                int n2 = RMAIO.parseInt((String)object3);
                if (n2 <= 0 || n2 > 10) {
                    return false;
                }
                String cfr_ignored_0 = (String)object.get(n);
                object2 = (String)object.get(++n);
                ++n;
                if (((String)object2).indexOf("SPLIT2") < 0) {
                    return false;
                }
                object3 = RMAIO.sprintf((int)8, (double)d);
                if (((String)(object3 = ((StringBuffer)object3).toString())).length() != 8) {
                    System.out.println("editControlFileSelectiveWithdrawal: valstr='" + (String)object3 + "'");
                }
                bufferedWriter.write((String)object2);
                bufferedWriter.newLine();
                for (int i = 0; i < n2; ++i) {
                    object2 = (String)object.get(n);
                    ++n;
                    object3 = ((String)object2).substring(0, 48) + (String)object3;
                    bufferedWriter.write((String)object3);
                    int n3 = ((String)object2).trim().length();
                    if (n3 > 56) {
                        bufferedWriter.write(((String)object2).substring(56));
                    }
                    bufferedWriter.newLine();
                    object3 = RMAIO.sprintf((int)8, (double)d);
                    object3 = ((StringBuffer)object3).toString();
                    if (((String)object3).length() == 8) continue;
                    System.out.println("editControlFileSelectiveWithdrawal: valstr='" + (String)object3 + "'");
                }
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: HabitatVolume. Error=" + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    private boolean editControlFileRestartOptions(BufferedWriter bufferedWriter, W2Model object, W2RestartInfo w2RestartInfo, ComputeInfo computeInfo) {
        if (w2RestartInfo != null) {
            try {
                object = "      ON";
                Object object2 = "     OFF";
                Object object3 = "RESTART     RSOC    NRSO    RSIC";
                bufferedWriter.write((String)object3);
                bufferedWriter.newLine();
                List<DateTimeFrequencyRecord> list = w2RestartInfo.getOutputRecordsList();
                int n = list.size();
                object3 = RMAIO.sprintf((int)8, (int)n);
                Object object4 = object2;
                if (w2RestartInfo.shouldWriteRestartFile() && n > 0) {
                    object4 = object;
                }
                if (w2RestartInfo.shouldInputRestartFile()) {
                    object2 = object;
                }
                object = "        " + (String)object4 + ((StringBuffer)object3).toString() + (String)object2;
                bufferedWriter.write((String)object);
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                if (w2RestartInfo.shouldWriteRestartFile()) {
                    double d;
                    int n2;
                    object = new PrintfFormat("%8.3f");
                    object3 = "RSO DATE    RSOD    RSOD    RSOD    RSOD    RSOD    RSOD    RSOD    RSOD    RSOD";
                    bufferedWriter.write((String)object3);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ");
                    for (n2 = 0; n2 < n; ++n2) {
                        object3 = list.get(n2);
                        d = ((DateTimeFrequencyRecord)object3).getJuilianDay();
                        object3 = object.sprintf(d);
                        bufferedWriter.write((String)object3);
                    }
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    object3 = "RSO FREQ    RSOF    RSOF    RSOF    RSOF    RSOF    RSOF    RSOF    RSOF    RSOF";
                    bufferedWriter.write((String)object3);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ");
                    for (n2 = 0; n2 < n; ++n2) {
                        object3 = list.get(n2);
                        d = ((DateTimeFrequencyRecord)object3).getFrequency();
                        object3 = object.sprintf(d);
                        bufferedWriter.write((String)object3);
                    }
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
                if (w2RestartInfo.shouldInputRestartFile()) {
                    object3 = "RSI FILE..................................RSIFN.................................";
                    bufferedWriter.write((String)object3);
                    bufferedWriter.newLine();
                    bufferedWriter.write("        ");
                    object = w2RestartInfo.getInputRestartFilename();
                    bufferedWriter.write((String)object);
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                this.printErrorMessage(computeInfo.uiWrapper, "Error writing W2 changes file: Restart Info. Error=" + String.valueOf(iOException));
                return false;
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private boolean checkErrorFile(String string, ComputeInfo computeInfo) {
        Object object = new File(string);
        if (!((File)object).exists()) {
            return true;
        }
        if (((File)object).length() > 0L) {
            String string2;
            object = null;
            object = new BufferedReader(new FileReader(string));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                this.printErrorMessage(computeInfo.uiWrapper, string2);
            }
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
            return false;
            catch (IOException iOException) {
                block14: {
                    try {
                        System.out.println("checkErrorFile:**********error reading " + string + " Exception " + String.valueOf(iOException));
                        if (object == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            try {
                                ((BufferedReader)object).close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeDssOutFile(W2Alt object, W2Model w2Model, String string, ComputeInfo computeInfo) {
        List<String> list;
        Identifier identifier;
        String string2;
        block26: {
            String string3;
            string2 = RMAIO.getDirectoryFromPath((String)string);
            Object object2 = string2 + "/dssout.npt";
            object2 = new Identifier((String)object2);
            try {
                identifier = this.getFileManager().openFile(UserId.getUserId(), (Identifier)object2);
                if (identifier == null) {
                    identifier = this.getFileManager().newFile(UserId.getUserId(), (Identifier)object2);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("writeDssOutFile:****ERROR. RemoteException opening " + object2.getPath() + " Error: " + String.valueOf(remoteException));
                this.printErrorMessage(computeInfo.uiWrapper, "Error Opening dssIn file");
                return false;
            }
            list = this.getClass().getClassLoader().getResourceAsStream("hec/rss/plugins/w2/dssout.template");
            if (list == null) {
                System.out.println("writeDssOutFile to get reader for dssout.template file");
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to get reader for dssout.template file");
                return false;
            }
            object2 = new BufferedReader(new InputStreamReader((InputStream)((Object)list)));
            list = new ArrayList();
            while ((string3 = ((BufferedReader)object2).readLine()) != null) {
                list.add(string3.trim());
            }
            try {
                ((BufferedReader)object2).close();
            }
            catch (Exception exception) {}
            break block26;
            catch (IOException iOException) {
                try {
                    System.out.println("writeDssOutFile reading dssIn template file " + String.valueOf(iOException));
                }
                catch (Throwable throwable) {
                    try {
                        ((BufferedReader)object2).close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    ((BufferedReader)object2).close();
                    return false;
                }
                catch (Exception exception) {}
                return false;
            }
        }
        list = this.createDssOutFile(list, (W2Alt)((Object)object), w2Model, string, computeInfo);
        if (list == null) return false;
        object = identifier.getFile();
        object = object.getBufferedWriter();
        for (int i = 0; i < list.size(); ++i) {
            ((Writer)object).write(list.get(i));
            ((BufferedWriter)object).newLine();
        }
        if (object == null) return this.runDssOutExe(string2, computeInfo);
        try {
            ((BufferedWriter)object).close();
            return this.runDssOutExe(string2, computeInfo);
        }
        catch (IOException iOException) {}
        return this.runDssOutExe(string2, computeInfo);
        catch (IOException iOException) {
            try {
                System.out.println("writeDssOutFile:**** ERROR, writing " + identifier.getPath() + " Error:" + String.valueOf(iOException));
                this.printErrorMessage(computeInfo.uiWrapper, "Error writing " + identifier.getPath() + " Error:" + String.valueOf(iOException));
                if (object == null) return false;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((BufferedWriter)object).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((BufferedWriter)object).close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeDssInFile(W2Alt object, W2Model w2Model, String string, ComputeInfo computeInfo) {
        Object object2;
        Identifier identifier;
        List<W2DssConnection> list;
        block30: {
            String string2;
            list = w2Model.getDssMapping();
            if (list.size() == 0) {
                this.printMessage(computeInfo.uiWrapper, "No ResSim to W2 DSS mappings defined for " + w2Model.getName());
                return true;
            }
            Object object3 = computeInfo.simRunPath;
            if (!((object3 = this.openManager("rss", (String)object3)) instanceof RssSimRun)) {
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ResSim Alternative");
                return false;
            }
            object3 = (RssSimRun)object3;
            if (!this.setDssPathing(list, computeInfo, (RssAlt)(object3 = object3.getRssAlt()))) {
                return false;
            }
            list = RMAIO.getDirectoryFromPath((String)string);
            object3 = (String)((Object)list) + "/dssin.npt";
            object3 = new Identifier((String)object3);
            try {
                identifier = this.getFileManager().openFile(UserId.getUserId(), (Identifier)object3);
                if (identifier == null) {
                    identifier = this.getFileManager().newFile(UserId.getUserId(), (Identifier)object3);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("writeDssInFile:****ERROR. RemoteException opening " + object3.getPath() + " Error: " + String.valueOf(remoteException));
                this.printErrorMessage(computeInfo.uiWrapper, "Error Opening dssIn file");
                return false;
            }
            if (identifier == null) {
                System.out.println("writeDssInFile:failed to open " + object3.getPath());
                this.printErrorMessage(computeInfo.uiWrapper, "failed to open W2 file " + object3.getPath());
                return false;
            }
            object2 = this.getClass().getClassLoader().getResourceAsStream("hec/rss/plugins/w2/dssin.template");
            if (object2 == null) {
                System.out.println("writeDssInFile to get reader for dssin.template file");
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to get reader for dssin.template file");
                return false;
            }
            object3 = new BufferedReader(new InputStreamReader((InputStream)object2));
            object2 = new ArrayList();
            while ((string2 = ((BufferedReader)object3).readLine()) != null) {
                object2.add(string2.trim());
            }
            try {
                ((BufferedReader)object3).close();
            }
            catch (Exception exception) {}
            break block30;
            catch (IOException iOException) {
                try {
                    System.out.println("writeDssInFile:****ERROR reading dssIn template file " + String.valueOf(iOException));
                }
                catch (Throwable throwable) {
                    try {
                        ((BufferedReader)object3).close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    ((BufferedReader)object3).close();
                    return false;
                }
                catch (Exception exception) {}
                return false;
            }
        }
        object2 = this.createDssInFile((List<String>)object2, (W2Alt)((Object)object), w2Model, string, computeInfo);
        if (object2 == null) return false;
        object = identifier.getFile();
        object = object.getBufferedWriter();
        for (int i = 0; i < object2.size(); ++i) {
            ((Writer)object).write(object2.get(i));
            ((BufferedWriter)object).newLine();
        }
        if (object == null) return this.runDssInExe((String)((Object)list), computeInfo);
        try {
            ((BufferedWriter)object).close();
            return this.runDssInExe((String)((Object)list), computeInfo);
        }
        catch (IOException iOException) {}
        return this.runDssInExe((String)((Object)list), computeInfo);
        catch (IOException iOException) {
            try {
                System.out.println("writeDssInFile:**** ERROR, writing " + identifier.getPath() + " Error:" + String.valueOf(iOException));
                this.printErrorMessage(computeInfo.uiWrapper, "Error writing " + identifier.getPath() + " Error:" + String.valueOf(iOException));
                if (object == null) return false;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((BufferedWriter)object).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((BufferedWriter)object).close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private boolean editW2Files(W2Alt object, W2Model object2, String string, ComputeInfo computeInfo) {
        DSSManager dSSManager;
        object = ((W2Model)object2).getDssMapping();
        if (object.size() == 0) {
            this.printWarningMessage(computeInfo.uiWrapper, "No ResSim to W2 DSS mappings defined.");
            return true;
        }
        object2 = computeInfo.simRunPath;
        if (!((object2 = this.openManager("rss", (String)object2)) instanceof RssSimRun)) {
            this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ResSim Alternative");
            return false;
        }
        object2 = (RssSimRun)object2;
        if (!this.setDssPathing((List<W2DssConnection>)object, computeInfo, (RssAlt)(object2 = object2.getRssAlt()))) {
            return false;
        }
        string = new DSSIdentifier();
        string.setTimeWindow(computeInfo.runTimeWindow.getStartTime(), computeInfo.runTimeWindow.getEndTime());
        try {
            dSSManager = (DSSManager)this.getDSSFileManager().getRemote();
        }
        catch (RemoteException remoteException) {
            System.out.println("editW2Files:****ERROR. RemoteException retriving DSSFileManager " + String.valueOf(remoteException));
            this.printErrorMessage(computeInfo.uiWrapper, "Error retrieving DSSFileManager");
            return false;
        }
        if (dSSManager == null) {
            this.printErrorMessage(computeInfo.uiWrapper, "Failed to get DSSFileManager");
            return false;
        }
        object2 = computeInfo.forecastpath + "/" + computeInfo.outputDSSFileName;
        string.setFileName((String)object2);
        for (int i = 0; i < object.size(); ++i) {
            String string2;
            Object object3;
            DSSArrayContainer dSSArrayContainer;
            Object object4 = (W2DssConnection)object.get(i);
            string.setDSSPath(object4.getDssPath());
            try {
                dSSArrayContainer = dSSManager.read((DSSIdentifier)string);
            }
            catch (Exception exception) {
                System.out.println("editW2Files:***** Exception retrieving TimeSeries " + String.valueOf(exception));
                return false;
            }
            if (dSSArrayContainer == null || dSSArrayContainer.numberRead <= 0) {
                System.out.println("editW2Files:***** No ResSim DSS data read for " + String.valueOf(string));
                this.printErrorMessage(computeInfo.uiWrapper, "No ResSim DSS data read for " + String.valueOf(object4) + " from " + String.valueOf(string));
                return false;
            }
            object4 = ((W2DssConnection)object4).getW2File();
            object4 = computeInfo.forecastpath + "/" + (String)object4;
            this.printMessage(computeInfo.uiWrapper, "Editing " + (String)object4);
            try {
                object3 = new BufferedReader(new FileReader((String)object4));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("editW2Files: FileNotFoundException " + String.valueOf(fileNotFoundException));
                this.printErrorMessage(computeInfo.uiWrapper, "Failed to find W2 file " + (String)object4);
                return false;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            try {
                String string3;
                while ((string3 = ((BufferedReader)object3).readLine()) != null) {
                    if (string3.toLowerCase().startsWith("jday")) {
                        n = 1;
                        arrayList.add(string3);
                        continue;
                    }
                    if (n == 0) {
                        arrayList.add(string3);
                        continue;
                    }
                    string2 = string3.substring(0, 8);
                    string3 = string3.substring(8);
                    arrayList.add(new W2RmiWorkspaceImpl$JulTimeData(string2, RMAIO.parseDouble((String)string3)));
                }
            }
            catch (IOException iOException) {
                System.out.println("IOException " + String.valueOf(iOException));
                iOException.printStackTrace();
            }
            finally {
                try {
                    ((BufferedReader)object3).close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException " + String.valueOf(iOException));
                    iOException.printStackTrace();
                }
            }
            int n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                if (n == 1 && dSSArrayContainer.getUnits() != null && dSSArrayContainer.getUnits().length() > 0) {
                    object3 = RMAIO.leftJustify((int)11, (String)dSSArrayContainer.getUnits()).toString();
                    arrayList.set(1, object3);
                }
                if (!((string2 = arrayList.get(n)) instanceof W2RmiWorkspaceImpl$JulTimeData)) continue;
                object3 = (W2RmiWorkspaceImpl$JulTimeData)((Object)string2);
                if (!((double)n < dSSArrayContainer.dataArray[n2])) continue;
                ((W2RmiWorkspaceImpl$JulTimeData)object3).a = dSSArrayContainer.dataArray[n2++];
            }
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter((String)object4));
            for (int j = 0; j < arrayList.size(); ++j) {
                string2 = arrayList.get(j);
                object3 = string2.toString();
                bufferedWriter.write((String)object3);
                bufferedWriter.newLine();
            }
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException iOException) {
                block41: {
                    try {
                        System.out.println("IOException " + String.valueOf(iOException));
                        if (bufferedWriter == null) break block41;
                    }
                    catch (Throwable throwable) {
                        if (bufferedWriter != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }
        }
        return true;
    }

    private boolean runDssInExe(String string, ComputeInfo computeInfo) {
        this.printMessage(computeInfo.uiWrapper, "Running dssin...");
        W2RmiWorkspaceImpl w2RmiWorkspaceImpl = this;
        if (w2RmiWorkspaceImpl.launchExe(w2RmiWorkspaceImpl.getExeFolder() + "/dssin.exe", string, computeInfo) == 0) {
            return true;
        }
        this.printErrorMessage(computeInfo.uiWrapper, "Failed to run dssin");
        return false;
    }

    private boolean runDssOutExe(String string, ComputeInfo computeInfo) {
        String string2;
        if (computeInfo != null) {
            this.printMessage(computeInfo.uiWrapper, "Running dssout...");
        }
        if (this.launchExe((string2 = this.getExeFolder()) + "/dssout.exe", string, computeInfo) == 0) {
            return true;
        }
        if (computeInfo != null) {
            this.printErrorMessage(computeInfo.uiWrapper, "Failed to run dssout");
        }
        return false;
    }

    private List<String> createDssOutFile(List<String> list, W2Alt w2Alt, W2Model object, String string, ComputeInfo computeInfo) {
        Object object2;
        Vector vector;
        int n = list.size();
        string = RMAIO.getDirectoryFromPath((String)string);
        this.printMessage(computeInfo.uiWrapper, "Finding w2 output in " + string);
        try {
            vector = this.getFileManager().getRemoteFileIDList(UserId.getUserId(), string, "ts*.opt");
            object = this.getFileManager().getRemoteFileIDList(UserId.getUserId(), string, "tw*.opt");
            vector.addAll(object);
            object2 = vector.iterator();
            while (object2.hasNext()) {
                if (!((Identifier)object2.next()).isDirectory()) continue;
                object2.remove();
            }
        }
        catch (RemoteException remoteException) {
            this.printErrorMessage(computeInfo.uiWrapper, "Error getting list of w2 outputfiles " + String.valueOf(remoteException));
            System.out.println("createDssOutFile: RemoteException " + String.valueOf(remoteException));
            return null;
        }
        this.printMessage(computeInfo.uiWrapper, "Found " + vector.size() + " output files");
        object2 = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            object = list.get(i);
            if ("%D".equals(object)) {
                object = computeInfo.forecastpath + "/" + computeInfo.outputDSSFileName;
                object = RMAIO.getRelativePath((String)string, (String)object, (boolean)true, (boolean)false);
                object = ((String)object).replace('/', File.separatorChar);
                object2.add(object);
                continue;
            }
            if ("%f".equals(object)) {
                if (vector != null) {
                    object2.add(String.valueOf(vector.size()));
                    continue;
                }
                object2.add("0");
                continue;
            }
            if ("%y".equalsIgnoreCase((String)object)) {
                object2.add(String.valueOf(computeInfo.runTimeWindow.getStartTime().year()));
                continue;
            }
            if ("%o".equalsIgnoreCase((String)object)) {
                if (vector != null && vector.size() > 0) {
                    for (int j = 0; j < vector.size(); ++j) {
                        object = (Identifier)vector.get(j);
                        object2.add(object.toString());
                    }
                    continue;
                }
                object2.add(" ");
                continue;
            }
            if ("%u".equals(object)) {
                if (this.getUnitSystem() == 1) {
                    object2.add("deg-f");
                    continue;
                }
                object2.add("deg-c");
                continue;
            }
            object2.add(object);
        }
        return object2;
    }

    private List<String> createDssInFile(List<String> list, W2Alt w2Alt, W2Model w2Model, String string, ComputeInfo computeInfo) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        List<W2DssConnection> list2 = w2Model.getDssMapping();
        Object object = new Identifier(string);
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            rmiFileManager.openFile(ClientApp.app().getUser(), (Identifier)object);
        }
        catch (RemoteException remoteException) {
            System.out.println("createDssInFile: ****ERROR RemoteException " + String.valueOf(remoteException));
            return null;
        }
        string = RMAIO.getDirectoryFromPath((String)string);
        w2Model.findflows(string, this.getExeFolder(), rmiFileManager);
        w2Model = computeInfo.runTimeWindow.getStartTime();
        w2Model.showTimeAsBeginningOfDay(true);
        object = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            ArrayList<String> arrayList2;
            String string2 = list.get(i);
            if ("%D".equals(string2)) {
                arrayList2 = computeInfo.forecastpath + "/" + computeInfo.outputDSSFileName;
                arrayList2 = RMAIO.getRelativePath((String)string, (String)((Object)arrayList2), (boolean)true, (boolean)false);
                ((String)((Object)arrayList2)).lastIndexOf(46);
                arrayList2 = ((String)((Object)arrayList2)).replace('/', File.separatorChar);
                arrayList.add((String)((Object)arrayList2));
                continue;
            }
            if ("%n".equals(string2)) {
                arrayList.add(String.valueOf(list2.size()));
                continue;
            }
            if ("%d".equals(string2)) {
                arrayList.add(computeInfo.runTimeWindow.getStartTime().date(0));
                continue;
            }
            if ("%t".equals(string2)) {
                arrayList.add(computeInfo.runTimeWindow.getStartTime().time());
                continue;
            }
            if ("%zs".equals(string2)) {
                arrayList2 = new ArrayList();
                ++i;
                while (i < n) {
                    string2 = list.get(i++);
                    arrayList2.add(string2);
                    if (!"%ze".equals(string2)) continue;
                }
                --i;
                int n2 = arrayList2.size();
                block4: for (int j = 0; j < list2.size(); ++j) {
                    W2DssConnection w2DssConnection = list2.get(j);
                    for (int k = 0; k < n2; ++k) {
                        String string3 = (String)arrayList2.get(k);
                        if ("%p".equals(string3)) {
                            arrayList.add(w2DssConnection.getDssPath());
                            continue;
                        }
                        if ("%o".equals(string3)) {
                            string3 = RMAIO.getFileFromPath((String)w2DssConnection.getW2File());
                            if (w2DssConnection.getFlowCount() > 1) {
                                List<W2RmiWorkspaceImpl$FilePosition> list3 = (List)object.get(string3);
                                if (list3 == null) {
                                    list3 = new ArrayList<W2RmiWorkspaceImpl$FilePosition>();
                                    object.put(string3, list3);
                                }
                                String string4 = RMAIO.getFileExtension((String)string3);
                                string3 = RMAIO.getFileNameNoExtension((String)string3);
                                String string5 = string3 + w2DssConnection.getFlowIndex() + string4;
                                arrayList.add(string5);
                                list3.add(new W2RmiWorkspaceImpl$FilePosition(this, string5, j + 1));
                                continue;
                            }
                            arrayList.add(string3);
                            continue;
                        }
                        if ("%i".equals(string3)) {
                            arrayList.add(String.valueOf(computeInfo.runTimeWindow.getTimeStepMinutes()));
                            continue;
                        }
                        if ("%r".equals(string3)) {
                            int n3 = computeInfo.runTimeWindow.getNumSteps() - computeInfo.runTimeWindow.getNumLookbackSteps();
                            arrayList.add(String.valueOf(++n3));
                            continue;
                        }
                        if ("%ze".equals(string3)) continue block4;
                        arrayList.add(string3);
                    }
                }
                continue;
            }
            if ("%N".equals(string2)) {
                arrayList.add(String.valueOf(object.size()));
                continue;
            }
            if ("%os".equals(string2)) {
                arrayList2 = new ArrayList<String>();
                ++i;
                while (i < n) {
                    string2 = list.get(i++);
                    arrayList2.add(string2);
                    if (!"%oe".equals(string2)) continue;
                }
                --i;
                arrayList2.size();
                Set set = object.keySet();
                block7: for (List<W2RmiWorkspaceImpl$FilePosition> list3 : set) {
                    List list4 = (List)object.get(list3);
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        string2 = (String)arrayList2.get(j);
                        if ("%f".equals(string2)) {
                            arrayList.add(String.valueOf(list4.size()));
                            continue;
                        }
                        if ("%F".equals(string2)) {
                            string2 = "";
                            for (int k = 0; k < list4.size(); ++k) {
                                if (string2.length() > 0) {
                                    string2 = string2.concat(",");
                                }
                                string2 = string2.concat(String.valueOf(((W2RmiWorkspaceImpl$FilePosition)list4.get((int)k)).a));
                            }
                            arrayList.add(string2);
                            continue;
                        }
                        if ("%c".equals(string2)) {
                            arrayList.add((String)((Object)list3));
                            continue;
                        }
                        if ("%oe".equals(string2)) continue block7;
                        arrayList.add(string2);
                    }
                }
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean setDssPathing(List<W2DssConnection> list, ComputeInfo computeInfo, RssAlt rssAlt) {
        RssSystem rssSystem = rssAlt.getSystem();
        if (rssSystem == null) {
            System.out.println("getOutputDataLocations:failed to get Network from RssAlt " + String.valueOf(rssAlt));
            return false;
        }
        Vector vector = rssSystem.getActiveTSProxies(null, 0, 0);
        int n = vector.size();
        new ArrayList(n);
        this.fillDssPaths(vector, rssAlt, computeInfo.modelAltname.substring(0, 11));
        for (int i = 0; i < list.size(); ++i) {
            W2DssConnection w2DssConnection = list.get(i);
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                String string;
                rssAlt = (TSRecordProxy)vector.get(j);
                if (rssAlt == null || !(string = rssSystem.getNameForKeyString(rssAlt.getName())).equals(w2DssConnection.getRssTscName()) || rssAlt.getVariableId() != w2DssConnection.getVarId()) continue;
                w2DssConnection.setDssPath(rssAlt.getDSSPathname());
                bl = true;
                break;
            }
            if (bl) continue;
            this.printErrorMessage(computeInfo.uiWrapper, "Failed to find ResSim DSS record for " + String.valueOf(w2DssConnection));
            return false;
        }
        return true;
    }

    private void fillDssPaths(List list, RssAlt rssAlt, String string) {
        RssRun rssRun = new RssRun();
        rssRun.setRunId(string);
        rssRun.setName(rssAlt.getName());
        rssRun.setWorkspace(rssAlt.getWorkspace());
        rssRun.setProxyList(rssAlt.getProxyList());
        rssRun.setAltPath(rssAlt.getIdentifier().getPath());
        rssRun.setFpartMultiplier(1);
        rssRun.setFpartPos(0, string.length());
        rssRun.updateOutputFPart();
        rssRun.getAlternative();
        int n = rssAlt.getTimestep();
        int n2 = rssAlt.getTimestepIncrement();
        if (n == -1 || n2 == -1) {
            n = 1;
            n2 = 2;
            System.out.println("fillDssPaths:set ResSim alt " + String.valueOf(rssAlt) + " timestep to 1 HOUR");
        }
        rssRun.getRunTimeWindow().setTimeStep(n, n2);
        rssRun.getNetwork();
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)list.get(n2);
            tSRecordProxy.setDSSPathname(rssRun.constructTSRecordProxyDssPath(tSRecordProxy, ""));
        }
    }

    private int launchExe(String[] stringArray, String object, ComputeInfo computeInfo) {
        Runtime runtime = Runtime.getRuntime();
        try {
            System.out.println("launchExe:launching " + stringArray[0] + " in directory " + (String)object);
            System.out.println("launchExe:cmd=");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\t" + stringArray[i]);
            }
            object = runtime.exec(stringArray, null, new File((String)object));
            ProcessOutput processOutput = this.waitForProcess(stringArray[0], (Process)object);
            object = processOutput.getProcessOutput();
            for (int i = 0; i < object.size(); ++i) {
                this.printLogMessage(computeInfo.uiWrapper, (String)object.get(i));
            }
            if (processOutput.getExitCode() == 0) {
                return 0;
            }
            this.printErrorMessage(computeInfo.uiWrapper, stringArray[0] + " Exited with a non-zero return code of " + processOutput.getExitCode());
        }
        catch (IOException iOException) {
            System.out.println("launchExe:IOException " + String.valueOf(iOException));
            iOException.printStackTrace();
        }
        return 2;
    }

    private int launchExe(String string, String object, ComputeInfo computeInfo) {
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = string;
        stringArray2[1] = "\"" + (String)object + "\"";
        try {
            System.out.println("launchExe:launching " + string + " in directory " + (String)object);
            System.out.println("launchExe:cmd=");
            if (computeInfo != null) {
                this.printLogMessage(computeInfo.uiWrapper, "launching " + string + " in directory " + (String)object);
            } else {
                System.out.println("launchExe:launching " + string + " in directory " + (String)object);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("\t" + stringArray2[i]);
            }
            object = runtime.exec(stringArray2, null, new File((String)object));
            ProcessOutput processOutput = this.waitForProcess(string, (Process)object);
            object = processOutput.getProcessOutput();
            for (int i = 0; i < object.size(); ++i) {
                if (computeInfo != null) {
                    this.printLogMessage(computeInfo.uiWrapper, (String)object.get(i));
                    continue;
                }
                System.out.println((String)object.get(i));
            }
            if (processOutput.getExitCode() == 0) {
                return 0;
            }
            if (computeInfo != null) {
                this.printErrorMessage(computeInfo.uiWrapper, string + " Exited with a non-zero return code of " + processOutput.getExitCode());
            } else {
                System.out.println("launchExe:" + string + " Exited with a non-zero return code of " + processOutput.getExitCode());
            }
        }
        catch (IOException iOException) {
            System.out.println("launchExe:IOException " + String.valueOf(iOException));
            iOException.printStackTrace();
        }
        return 2;
    }

    private ProcessOutput waitForProcess(String string, Process process) {
        Vector vector = new Vector(100);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        string = new ProcessOutput(string);
        new ProcessOutputReader(bufferedReader, vector, "stdout", false, false);
        new ProcessOutputReader(bufferedReader2, vector, "stderr", false, true);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("waitForProcess: InterruptedException " + String.valueOf(interruptedException));
        }
        int n = process.exitValue();
        string.setExitCode(n);
        System.out.println("waitForProcess:Process Exited with " + n);
        string.setProcessOutput(vector);
        return string;
    }

    protected void writeConfiguration(HecFile object) throws RemoteException {
        object = object.getBufferedWriter();
        try {
            int n;
            Object object2 = Double.toString(this._extents.w);
            String string = Double.toString(this._extents.e);
            String string2 = Double.toString(this._extents.s);
            String string3 = Double.toString(this._extents.n);
            RMAIO.fout((BufferedWriter)object, (String)("WorkspaceName=" + this.getTitleName()));
            RMAIO.fout((BufferedWriter)object, (String)("WorkspaceDescription=" + this.getDescription()));
            if (this._exeFolder != null) {
                W2RmiWorkspaceImpl w2RmiWorkspaceImpl = this;
                RMAIO.fout((BufferedWriter)object, (String)("W2ExeFolder=" + w2RmiWorkspaceImpl.getRelativePath(w2RmiWorkspaceImpl._exeFolder)));
            }
            if (!(((String)object2).equalsIgnoreCase("-infinity") && string.equalsIgnoreCase("-infinity") && string2.equalsIgnoreCase("-infinity") && string3.equalsIgnoreCase("-infinity"))) {
                object2 = "Extents=" + (String)object2 + "," + string + "," + string2 + "," + string3;
                this.lineWrite((BufferedWriter)object, (String)object2);
            }
            for (n = 0; n < this._mapIdentifiers.size(); ++n) {
                string = (MapIdentifier)this._mapIdentifiers.elementAt(n);
                this.lineWrite((BufferedWriter)object, "");
                this.lineWrite((BufferedWriter)object, "MapBegin");
                this.lineWrite((BufferedWriter)object, "Name=" + string.getName());
                this.lineWrite((BufferedWriter)object, "Description=" + string.getDescription());
                this.writePath((BufferedWriter)object, string.getFile().getPath(), "Path=");
                this.lineWrite((BufferedWriter)object, "Shown=" + string.getMapShown());
                this.lineWrite((BufferedWriter)object, "Class=" + string.getClassName());
                string = string.getGlyphDataRecord();
                if (string != null) {
                    this.lineWrite((BufferedWriter)object, "GlyphDataRecordBegin");
                    string.write((BufferedWriter)object);
                    this.lineWrite((BufferedWriter)object, "GlyphDataRecordEnd");
                }
                this.lineWrite((BufferedWriter)object, "MapEnd");
            }
            for (n = 0; n < this._managerProxys.size(); ++n) {
                string = (ManagerProxy)this._managerProxys.elementAt(n);
                if (string == null) continue;
                string.write((BufferedWriter)object);
            }
            ((BufferedWriter)object).close();
            return;
        }
        catch (Exception exception) {
            System.out.println("Error closing output stream  " + String.valueOf(exception));
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public String getExeFolder() {
        if (((HecRmiWorkspaceImpl)this._parentWorkspace).getBaseWorkspace() != this._parentWorkspace) {
            try {
                W2RmiWorkspaceImpl w2RmiWorkspaceImpl = (W2RmiWorkspaceImpl)((HecRmiWorkspaceImpl)this._parentWorkspace).getBaseWorkspace().getChildWorkspace("w2");
                return w2RmiWorkspaceImpl.getExeFolder();
            }
            catch (RemoteException remoteException) {
                System.out.println("getExeFolder:RMI Error " + String.valueOf(remoteException));
            }
        }
        return this._exeFolder;
    }

    @Override
    public void setExeFolder(String string) {
        this._exeFolder = string;
    }
}

