/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Objects;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQConstituent
implements Constituent {
    private int _id = Integer.MIN_VALUE;
    private String _name = "";
    private String _displayName = "";
    private String _unit = "";
    private String _libraryName = "";
    private Double _referenceValue = Double.NEGATIVE_INFINITY;
    private Boolean _isAdvected = Boolean.TRUE;
    private Boolean _isInjected = Boolean.TRUE;
    private Boolean _isEvaporated = Boolean.FALSE;

    public void setId(int id) {
        this._id = id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setUnit(String unit) {
        this._unit = unit;
    }

    public void setLibraryName(String libraryName) {
        this._libraryName = libraryName;
    }

    public void setReferenceValue(Double referenceValue) {
        this._referenceValue = referenceValue;
    }

    public WQConstituent() {
    }

    public WQConstituent(int id, String shortName, String displayName, String unit, String lib) {
        this(id, shortName, displayName, unit, lib, Double.NEGATIVE_INFINITY);
    }

    public WQConstituent(int id, String shortName, String displayName, String unit, String lib, Double ref) {
        this._id = id;
        this._name = shortName;
        this._displayName = displayName;
        this._unit = unit;
        this._libraryName = lib;
        this._referenceValue = ref;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getUnit() {
        return this._unit;
    }

    public String getLibraryName() {
        return this._libraryName;
    }

    public Double getReferenceValue() {
        return this._referenceValue;
    }

    public Boolean getIsAdvected() {
        return this._isAdvected;
    }

    public void setIsAdvected(Boolean isAdvected) {
        this._isAdvected = isAdvected;
    }

    public Boolean getIsInjected() {
        return this._isInjected;
    }

    public void setIsInjected(Boolean isInjected) {
        this._isInjected = isInjected;
    }

    public Boolean getIsEvaporated() {
        return this._isEvaporated;
    }

    public void setIsEvaporated(Boolean isEvaporated) {
        this._isEvaporated = isEvaporated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WQConstituent that = (WQConstituent)o;
        return this._id == that._id && Objects.equals(this._name, that._name) && Objects.equals(this._libraryName, that._libraryName);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._name, this._libraryName);
    }

    public Constituent copy() {
        WQConstituent copy = new WQConstituent(this._id, this._name, this._displayName, this._unit, this._libraryName, this._referenceValue);
        copy.setIsAdvected(this.getIsAdvected());
        copy.setIsInjected(this.getIsInjected());
        copy.setIsEvaporated(this.getIsEvaporated());
        return copy;
    }

    public String toString() {
        return this._displayName;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQConstituent.class);
        }
    }
}

