/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqengineimpl.WQConstituent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rma.services.annotations.ServiceProvider;

@JsonPropertyOrder(value={"name", "description"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQConstituentSet
implements ConstituentSet {
    @JsonPropertyOrder(alphabetic=true)
    @JsonProperty(value="constituentList")
    @JsonDeserialize(contentAs=WQConstituent.class)
    @JsonSerialize(contentAs=WQConstituent.class)
    protected List<Constituent> _constituentList = new ArrayList<Constituent>();
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="description")
    private String description = "";

    public WQConstituentSet() {
    }

    public WQConstituentSet(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @JsonIgnore
    public List<Constituent> getConstituentList() {
        if (this._constituentList == null) {
            return null;
        }
        return Collections.unmodifiableList(this._constituentList);
    }

    public void setConstituentList(Collection<Constituent> newList) {
        this._constituentList.clear();
        this._constituentList.addAll(newList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String text) {
        this.name = text;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public void addConstituent(Constituent wqc) {
        this._constituentList.add(wqc);
    }

    public Constituent getConstituent(Integer constituentId) {
        return this._constituentList.stream().filter(c -> constituentId.intValue() == c.getId()).findFirst().orElse(null);
    }

    public Constituent getConstituent(int id) {
        if (this._constituentList == null) {
            return null;
        }
        for (Constituent constit : this._constituentList) {
            if (constit.getId() != id) continue;
            return constit;
        }
        return null;
    }

    public boolean hasConstituent(Integer id) {
        if (this._constituentList == null) {
            return false;
        }
        for (Constituent constit : this._constituentList) {
            if (constit.getId() != id.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean usesNSM1() {
        if (this._constituentList == null) {
            return false;
        }
        for (Constituent constit : this._constituentList) {
            if (constit.getId() <= 100 || constit.getId() >= 200) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public int getNumConstituents() {
        return this.size();
    }

    @JsonIgnore
    public int size() {
        if (this._constituentList == null) {
            return 0;
        }
        return this._constituentList.size();
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public WQConsistencyCheck checkConsistency(MetStationSet metStationSet) {
        String errorMessage;
        String datasetName = "Water Quality Constituent Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        boolean hasTemp = false;
        boolean hasSedTemp = false;
        boolean hasNSM1 = false;
        for (Constituent constit : this._constituentList) {
            int constitId = constit.getId();
            if (constitId == 1) {
                hasTemp = true;
                continue;
            }
            if (constitId == 2) {
                hasSedTemp = true;
                continue;
            }
            if (constitId <= 100 || constitId >= 200) continue;
            hasNSM1 = true;
        }
        if (hasSedTemp && !hasTemp) {
            errorMessage = "Constituent Set includes Sediment Temperature but does not include Water Temperature";
            consistencyCheck.addErrorMessage(errorMessage);
        }
        if (hasTemp && metStationSet == null) {
            errorMessage = "Constituent Set includes Temperature but there is no selected Met Data Set";
            consistencyCheck.addErrorMessage(errorMessage);
        }
        if (hasNSM1 && !hasTemp) {
            errorMessage = "Constituent Set includes NSM1 Water Quality but does not include Water Temperature";
            consistencyCheck.addErrorMessage(errorMessage);
        }
        return consistencyCheck;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQConstituentSet.class);
        }
    }
}

