/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl;

import hec.wqenginecore.Constituent;
import hec.wqenginecore.Library;
import hec.wqenginecore.LibraryRegistry;
import hec.wqengineimpl.libraries.GeneralConstituent;
import hec.wqengineimpl.libraries.NSM1;
import hec.wqengineimpl.libraries.Temperature;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WQLibraryRegistryImpl
implements LibraryRegistry {
    private Map<String, Library> libraries = new LinkedHashMap<String, Library>();

    public WQLibraryRegistryImpl(Map<String, Library> libraries) {
        this.libraries.putAll(libraries);
    }

    public WQLibraryRegistryImpl() {
        Temperature temperature = new Temperature();
        temperature.build();
        this.libraries.put(temperature.getName(), (Library)temperature);
        NSM1 nsm1 = new NSM1();
        nsm1.build();
        this.libraries.put(nsm1.getName(), (Library)nsm1);
        GeneralConstituent generalConstituent = new GeneralConstituent();
        generalConstituent.build();
        this.libraries.put(generalConstituent.getName(), (Library)generalConstituent);
    }

    public Collection<Library> getLibraries() {
        return Collections.unmodifiableCollection(this.libraries.values());
    }

    public Library getLibrary(String name) {
        return this.libraries.get(name);
    }

    public Collection<Constituent> addRequired(Collection<Constituent> input) {
        LinkedHashSet<Constituent> retval = new LinkedHashSet<Constituent>();
        if (input != null && !input.isEmpty()) {
            retval.addAll(input);
            Set<Constituent> missingCons = this.findMissing(retval);
            if (missingCons != null && !missingCons.isEmpty()) {
                retval.addAll(missingCons);
            }
        }
        return retval;
    }

    protected Set<Constituent> findMissing(Set<Constituent> selected) {
        int pre = selected.size();
        Set<Constituent> expanded = this.expand(selected);
        while (expanded.size() - pre > 0) {
            pre = expanded.size();
            expanded = this.expand(expanded);
        }
        HashSet<Constituent> missing = new HashSet<Constituent>(expanded);
        missing.removeAll(selected);
        return missing;
    }

    private Set<Constituent> expand(Set<Constituent> selected) {
        HashSet<Constituent> expanded = new HashSet<Constituent>(selected);
        Collection<Library> libraries = this.getLibraries();
        for (Library library : libraries) {
            Collection req = library.addRequired(selected);
            expanded.addAll(req);
        }
        return expanded;
    }
}

