/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.boundaryconditions;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.ambient.AmbientData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import java.util.List;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQBoundaryCondition
implements BoundaryCondition {
    private int _constituentId;
    private WQSubDomainBoundaryRef _boundaryRef;
    private List<Data> _dataSources;
    private String[] _units;
    private Data _selectedDataSource;
    private String _selectedDataSourceSetting;
    private String _selectedDataUnits;

    public WQBoundaryCondition() {
    }

    public WQBoundaryCondition(int constituent, WQSubDomainBoundaryRef boundary) {
        this._constituentId = constituent;
        this._boundaryRef = boundary;
    }

    public WQSubDomainBoundaryRef getBoundaryRef() {
        return this._boundaryRef;
    }

    public int getConstituentId() {
        return this._constituentId;
    }

    public List<Data> getDataSources() {
        if (this._dataSources != null && this._dataSources.stream().noneMatch(d -> d instanceof AmbientData)) {
            this._dataSources.add((Data)new AmbientData());
        }
        return this._dataSources;
    }

    public String[] getUnits() {
        return this._units;
    }

    public Data getSelectedDataSource() {
        return this._selectedDataSource;
    }

    public String getSelectedDataSourceSetting() {
        return this._selectedDataSourceSetting;
    }

    public String getSelectedDataUnits() {
        return this._selectedDataUnits;
    }

    public void setConstituentId(int constituentId) {
        this._constituentId = constituentId;
    }

    public void setBoundaryRef(WQSubDomainBoundaryRef location) {
        this._boundaryRef = location;
    }

    public void setDataSources(List<Data> dataSources) {
        this._dataSources = dataSources;
        if (this._dataSources != null) {
            for (int i = 0; i < this._dataSources.size(); ++i) {
                Data data = this._dataSources.get(i);
                if (!(data instanceof DssData)) continue;
                ((DssData)data).setHasInterpretedUnits(false);
            }
        }
    }

    public void setUnits(String[] units) {
        this._units = units;
    }

    public void setSelectedDataSource(Data selectedDataSource) {
        this._selectedDataSource = selectedDataSource;
    }

    public void setSelectedDataSourceSetting(String selectedDataSourceSetting) {
        this._selectedDataSourceSetting = selectedDataSourceSetting;
    }

    public void setSelectedDataUnits(String selectedDataUnits) {
        this._selectedDataUnits = selectedDataUnits;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQBoundaryCondition.class);
        }
    }
}

