/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.boundaryconditions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.Units;
import hec.io.Identifier;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.boundaryconditions.WQBoundaryCondition;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQBoundaryConditionSet
implements BoundaryConditionSet {
    private String _name;
    private String _description;
    private Collection<BoundaryCondition> _boundaryConditions = new ArrayList<BoundaryCondition>();
    private Identifier _geometryReference = null;

    public Identifier getGeometryIdentifier() {
        return this._geometryReference;
    }

    public void setGeometryReference(Identifier geometryProxyIdentifier) {
        this._geometryReference = geometryProxyIdentifier;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    @JsonIgnore
    public Set<Integer> getConstituentIds() {
        return this._boundaryConditions.stream().map(bc -> bc.getConstituentId()).collect(Collectors.toSet());
    }

    public void setBoundaryConditions(List<BoundaryCondition> boundaryConditions) {
        this._boundaryConditions = boundaryConditions;
    }

    public Collection<BoundaryCondition> getBoundaryConditions(SubDomainBoundaryRef j) {
        List<Object> retval = this._boundaryConditions == null || this._boundaryConditions.isEmpty() ? Collections.emptyList() : this._boundaryConditions.stream().filter(bc -> Objects.equals(j, bc.getBoundaryRef())).collect(Collectors.toList());
        return retval;
    }

    public Collection<BoundaryCondition> getBoundaryConditions(int c) {
        List<Object> retval = this._boundaryConditions == null || this._boundaryConditions.isEmpty() ? Collections.emptyList() : this._boundaryConditions.stream().filter(bc -> Objects.equals(c, bc.getConstituentId())).collect(Collectors.toList());
        return retval;
    }

    public BoundaryCondition getBoundaryCondition(int c, SubDomainBoundaryRef j) {
        List retval = this._boundaryConditions == null || this._boundaryConditions.isEmpty() ? Collections.emptyList() : this._boundaryConditions.stream().filter(bc -> Objects.equals(c, bc.getConstituentId())).filter(bc -> Objects.equals(j, bc.getBoundaryRef())).collect(Collectors.toList());
        if (retval.size() == 1) {
            return (BoundaryCondition)retval.get(0);
        }
        return null;
    }

    public BoundaryCondition getRiverInflowBoundaryCondition(Constituent constit, SubDomainBoundary sd) {
        List retval;
        if (this._boundaryConditions == null || this._boundaryConditions.isEmpty()) {
            retval = Collections.emptyList();
        } else if (sd.getBoundaryType() != BoundaryType.RIVER_INFLOW && sd.getBoundaryType() != BoundaryType.RESERVOIR_INFLOW_IN_NETWORK) {
            retval = Collections.emptyList();
        } else {
            int c = constit.getId();
            SubDomainBoundaryRef j = sd.getRef();
            retval = this._boundaryConditions.stream().filter(bc -> Objects.equals(c, bc.getConstituentId())).filter(bc -> Objects.equals(j.getJnctId(), bc.getBoundaryRef().getJnctId())).collect(Collectors.toList());
        }
        if (retval.size() == 1) {
            return (BoundaryCondition)retval.get(0);
        }
        return null;
    }

    @JsonDeserialize(contentAs=WQBoundaryCondition.class)
    @JsonSerialize(contentAs=WQBoundaryCondition.class)
    public Collection<BoundaryCondition> getBoundaryConditions() {
        return this._boundaryConditions;
    }

    @JsonIgnore
    public List<SubDomainBoundary> getExternalBoundaries(WQGeometry wqGeo) {
        EnumSet<BoundaryType> types = EnumSet.of(BoundaryType.RIVER_INFLOW_IN_NETWORK, BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
        return wqGeo.getBoundaries(types);
    }

    private String getDownstreamSubDomainName(int boundaryId, WQGeometry wqGeo) {
        String name = null;
        WQGeoSubDomain sd = wqGeo.getDownstreamSubDomain(boundaryId);
        if (sd != null) {
            name = sd.getName();
        }
        return name;
    }

    public Map<Integer, String> getDownstreamSubDomainNames(Collection<Integer> boundaryIds, WQGeometry wqGeo) {
        LinkedHashMap<Integer, String> retval = new LinkedHashMap<Integer, String>();
        Map<Integer, SubDomain> boundaryIdToSubDomain = wqGeo.getDownstreamSubDomains(boundaryIds);
        for (Map.Entry<Integer, SubDomain> entry : boundaryIdToSubDomain.entrySet()) {
            retval.put(entry.getKey(), entry.getValue().getName());
        }
        return retval;
    }

    @JsonIgnore
    public List<SubDomainBoundary> getLocalInflowBoundaries(WQGeometry wqGeo) {
        BoundaryType[] boundaryTypes = new BoundaryType[]{BoundaryType.LOCAL_INFLOW};
        return wqGeo.getBoundaries(Arrays.asList(boundaryTypes));
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public Collection<BoundaryCondition> getBoundaryConditions(SubDomainBoundary j) {
        return this.getBoundaryConditions(j.getRef());
    }

    public Collection<BoundaryCondition> getBoundaryConditions(Constituent c) {
        Collection<BoundaryCondition> retval = Collections.emptyList();
        if (c != null) {
            retval = this.getBoundaryConditions(c.getId());
        }
        return retval;
    }

    public BoundaryCondition getBoundaryCondition(Constituent c, SubDomainBoundary j) {
        return this.getBoundaryCondition(c.getId(), j.getRef());
    }

    public void addBoundaryConditions(Collection<BoundaryCondition> boundaryConditions) {
        this._boundaryConditions.addAll(boundaryConditions);
    }

    public void removeBoundaryConditions(Collection<BoundaryCondition> boundaryConditions) {
        this._boundaryConditions.removeAll(boundaryConditions);
    }

    public WQConsistencyCheck checkConsistency(Geometry geo, ConstituentSet constitSet) {
        String datasetName = "Water Quality Boundary Condition Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        if (geo == null) {
            consistencyCheck.addErrorMessage("Missing dependent Water Quality Geometry");
            return consistencyCheck;
        }
        if (constitSet == null) {
            consistencyCheck.addErrorMessage("Missing dependent Constituent Set");
            return consistencyCheck;
        }
        List sdBounds = geo.getBoundariesInExtent();
        Collection constitList = constitSet.getConstituentList();
        for (SubDomainBoundary sdBound : sdBounds) {
            if (!sdBound.isInflow()) continue;
            for (Constituent constit : constitList) {
                String errorMessage;
                BoundaryCondition bc;
                if (!constit.getIsAdvected().booleanValue() || (bc = this.getBoundaryCondition(constit, sdBound)) == null) continue;
                Data dataSrc = bc.getSelectedDataSource();
                if (dataSrc instanceof ConstantData) {
                    double val = ((ConstantData)dataSrc).getConstantValue();
                    if (val == Double.NEGATIVE_INFINITY) {
                        errorMessage = "Subdomain Boundary: " + sdBound.getName() + " has no defined constant value boundary condition for constituent " + constit.getDisplayName();
                        consistencyCheck.addErrorMessage(errorMessage);
                        continue;
                    }
                    if (!(val < 0.0)) continue;
                    errorMessage = "Subdomain Boundary: " + sdBound.getName() + " has constant boundary condition value < 0.0 for constituent " + constit.getDisplayName();
                    consistencyCheck.addErrorMessage(errorMessage);
                    continue;
                }
                if (!(dataSrc instanceof DssData)) continue;
                DssData dssData = (DssData)dataSrc;
                if (dssData.getDssFilePath() == null || dssData.getDssPath() == null) {
                    String errorMessage2 = "Subdomain Boundary: " + sdBound.getName() + " has no defined DSS file or path for constituent " + constit.getDisplayName();
                    consistencyCheck.addErrorMessage(errorMessage2);
                }
                String units = dssData.getUnits();
                if (constit.getId() != 1 || Units.canConvertBetweenUnits((String)units, (String)"deg C")) continue;
                errorMessage = "Subdomain Boundary: " + sdBound.getName() + " has units for water temperature: " + units + " which can't be converted to deg C";
                consistencyCheck.addErrorMessage(errorMessage);
            }
        }
        return consistencyCheck;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQBoundaryConditionSet.class);
        }
    }
}

