/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.dispersion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.dispersion.AlternateMixingMethod;
import hec.wqenginecore.dispersion.DispersionCoefSettings;
import hec.wqenginecore.dispersion.MunkAndersonDispersionData;
import hec.wqenginecore.dispersion.ReachDispersionType;
import hec.wqenginecore.dispersion.ReachDispersionValues;
import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqenginecore.dispersion.StabilityDispersionData;
import hec.wqenginecore.dispersion.ValueByReachType;
import hec.wqenginecore.dispersion.WindDispersionData;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.dispersion.WQReachDispersionSettings;
import hec.wqengineimpl.dispersion.WQReservoirDispersionSettings;
import hec.wqengineimpl.dispersion.WQReservoirDispersionSettingsSet;
import java.util.List;
import rma.services.annotations.ServiceProvider;

@JsonPropertyOrder(value={"id", "name", "description"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQDispersionCoefSettings
implements DispersionCoefSettings {
    private int _id;
    private String _name;
    private String _description;
    private WQReservoirDispersionSettingsSet _reservoirSettingsSet = new WQReservoirDispersionSettingsSet();
    private WQReachDispersionSettings _reachSettings = new WQReachDispersionSettings();

    public WQDispersionCoefSettings() {
    }

    public WQDispersionCoefSettings(String name, String description) {
        this._name = name;
        this._description = description;
    }

    @Deprecated
    public void setReservoirSettings(WQReservoirDispersionSettings reservoirSettings) {
    }

    @Deprecated
    public WQReservoirDispersionSettings getReservoirSettings() {
        return null;
    }

    public void setReservoirSettings(SubDomainRef ref, WQReservoirDispersionSettings reservoirSettings) {
        this._reservoirSettingsSet.setReservoirDispersionSettings(ref, reservoirSettings);
    }

    public void setReachSettings(WQReachDispersionSettings reachSettings) {
        this._reachSettings = reachSettings;
    }

    public WQReservoirDispersionSettingsSet getReservoirSettingsSet() {
        return this._reservoirSettingsSet;
    }

    public void setReservoirSettingsSet(WQReservoirDispersionSettingsSet reservoirSettingsSet) {
        this._reservoirSettingsSet = reservoirSettingsSet;
    }

    public WQReservoirDispersionSettings getReservoirSettings(SubDomainRef ref) {
        return this._reservoirSettingsSet.getReservoirDispersionSettings(ref);
    }

    public WQReachDispersionSettings getReachSettings() {
        return this._reachSettings;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public WQConsistencyCheck checkConsistency(Geometry geo) {
        String errorMessage;
        Object errorMessage2;
        List subDoms;
        WQConsistencyCheck consistencyCheck;
        block24: {
            block22: {
                block23: {
                    String datasetName = "Water Quality Mixing Coefficient Set: " + this.getName();
                    consistencyCheck = new WQConsistencyCheck(datasetName);
                    if (geo == null) {
                        String errorMessage3 = "Missing dependent Water Quality Geometry";
                        consistencyCheck.addErrorMessage(errorMessage3);
                        return consistencyCheck;
                    }
                    subDoms = geo.getSubDomainsInExtent();
                    if (this._reachSettings.getDispersionType() != ReachDispersionType.GLOBAL) break block22;
                    if (this._reachSettings.getGlobalValue() != Double.NEGATIVE_INFINITY) break block23;
                    String errorMessage4 = "Global Reach Dispersion Coefficient is undefined";
                    consistencyCheck.addErrorMessage(errorMessage4);
                    break block24;
                }
                if (this._reachSettings.getGlobalValue() != 0.0) break block24;
                String warningMessage = "Global Reach Dispersion Coefficient is 0.0";
                consistencyCheck.addWarningMessage(warningMessage);
                break block24;
            }
            List<ReachDispersionValues> valsByReach = this._reachSettings.getReachValues();
            if (this._reachSettings.getValueByReachType() == ValueByReachType.CONSTANT) {
                for (SubDomain subdom : subDoms) {
                    if (subdom.getType() != SubDomainType.REACH_1D) continue;
                    boolean foundReach = false;
                    for (ReachDispersionValues rdv : valsByReach) {
                        if (rdv.getReachId() != subdom.getId()) continue;
                        foundReach = true;
                        if (this._reachSettings.getValueByReachType() == ValueByReachType.CONSTANT) {
                            if (rdv.getConstant() != Double.NEGATIVE_INFINITY) break;
                            errorMessage2 = "Reach Dispersion Coefficient is undefined for Subdomain: " + subdom.getName();
                            consistencyCheck.addErrorMessage((String)errorMessage2);
                            break;
                        }
                        if (this._reachSettings.getValueByReachType() != ValueByReachType.LINEAR_INTERP || rdv.getUpperEnd() != Double.NEGATIVE_INFINITY && rdv.getLowerEnd() != Double.NEGATIVE_INFINITY) break;
                        errorMessage2 = "Reach Dispersion Coefficient is undefined for Subdomain: " + subdom.getName();
                        consistencyCheck.addErrorMessage((String)errorMessage2);
                        break;
                    }
                    if (foundReach) continue;
                    errorMessage = "Reach Dispersion Coefficient data not found for Subdomain: " + subdom.getName();
                    consistencyCheck.addErrorMessage(errorMessage);
                }
            }
        }
        for (SubDomain subdom : subDoms) {
            Double mixedLayerTolerance;
            Double maxOutflowHeight;
            Double maxInflowHeight;
            MunkAndersonDispersionData maData;
            String errorMessage5;
            if (subdom.getType() != SubDomainType.RESERVOIR_1DV) continue;
            SubDomainRef sdRef = geo.buildRef(subdom);
            WQReservoirDispersionSettings resDispSetting = this.getReservoirSettings(sdRef);
            if (resDispSetting == null) {
                errorMessage = "Reservoir Dispersion Coefficient data not found for Subdomain: " + subdom.getName();
                consistencyCheck.addErrorMessage(errorMessage);
                return consistencyCheck;
            }
            if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.STABILITY) {
                StabilityDispersionData stabData = resDispSetting.getStabilityData();
                if (stabData.getEcrit() == Double.NEGATIVE_INFINITY || stabData.getA1() == Double.NEGATIVE_INFINITY || stabData.getA3() == Double.NEGATIVE_INFINITY) {
                    errorMessage5 = "Undefined Reservoir Dispersion Coefficient data (Stability method) for Subdomain: " + subdom.getName();
                    consistencyCheck.addErrorMessage(errorMessage5);
                }
            } else if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.WIND) {
                WindDispersionData windData = resDispSetting.getWindData();
                if (windData.getDzmin() == Double.NEGATIVE_INFINITY || windData.getA1() == Double.NEGATIVE_INFINITY || windData.getA2() == Double.NEGATIVE_INFINITY) {
                    errorMessage5 = "Undefined Reservoir Dispersion Coefficient data (Wind method) for Subdomain: " + subdom.getName();
                    consistencyCheck.addErrorMessage(errorMessage5);
                }
            } else if (resDispSetting.getAlternateMixingMethod() == AlternateMixingMethod.MUNK_ANDERSON && ((maData = resDispSetting.getMunkAndersonData()).getACoeff() == Double.NEGATIVE_INFINITY || maData.getBCoeff() == Double.NEGATIVE_INFINITY || maData.getCCoeff() == Double.NEGATIVE_INFINITY || maData.getDzmin() == Double.NEGATIVE_INFINITY)) {
                errorMessage5 = "Undefined Reservoir Dispersion Coefficient data (Munk Anderson method) for Subdomain: " + subdom.getName();
                consistencyCheck.addErrorMessage(errorMessage5);
            }
            ReservoirDispersionEntrainmentSettings resEntrainSetting = resDispSetting.getEntrainmentSettings();
            if (resEntrainSetting == null) {
                errorMessage5 = "Undefined Reservoir Entrainment data for Subdomain: " + subdom.getName();
                consistencyCheck.addErrorMessage(errorMessage5);
            } else {
                List entrainmentInflowSettings = resEntrainSetting.getEntrainmentInflowSettings();
                for (ReservoirEntrainmentInflowSetting entrainSetting : entrainmentInflowSettings) {
                    if (!entrainSetting.useEntrainment()) continue;
                    boolean undefData = false;
                    Double initMixingRatio = entrainSetting.getInitialMixingRatio();
                    Double entrainmentRate = entrainSetting.getEntrainmentRate();
                    Double streamSlope = entrainSetting.getStreamSlope();
                    Double streamHalfAngle = entrainSetting.getStreamCrossSectionHalfAngle();
                    if (initMixingRatio == null || entrainmentRate == null || streamSlope == null || streamHalfAngle == null) {
                        undefData = true;
                    } else if (initMixingRatio == Double.NEGATIVE_INFINITY || entrainmentRate == Double.NEGATIVE_INFINITY || streamSlope == Double.NEGATIVE_INFINITY || streamHalfAngle == Double.NEGATIVE_INFINITY) {
                        undefData = true;
                    }
                    if (!undefData) continue;
                    String errorMessage6 = "Undefined Reservoir Entrainment data for Subdomain: " + subdom.getName() + " Inflow: " + entrainSetting.getInflowName();
                    consistencyCheck.addErrorMessage(errorMessage6);
                }
            }
            if (resDispSetting.useMaxInflowEnvelopeHeight() && ((maxInflowHeight = resDispSetting.getMaxInflowEnvelopeHeight()) == null || maxInflowHeight == Double.NEGATIVE_INFINITY)) {
                errorMessage2 = "Undefined Max Inflow Envelope Height for Subdomain: " + subdom.getName();
                consistencyCheck.addErrorMessage((String)errorMessage2);
            }
            if (resDispSetting.useMaxOutflowEnvelopeHeight() && ((maxOutflowHeight = resDispSetting.getMaxOutflowEnvelopeHeight()) == null || maxOutflowHeight == Double.NEGATIVE_INFINITY)) {
                errorMessage2 = "Undefined Max Outflow Envelope Height for Subdomain: " + subdom.getName();
                consistencyCheck.addErrorMessage((String)errorMessage2);
            }
            if ((mixedLayerTolerance = resDispSetting.getMixedLayerTolerance()) != null && mixedLayerTolerance != Double.NEGATIVE_INFINITY) continue;
            errorMessage2 = "Undefined Mixed Layer Tolerance for Subdomain: " + subdom.getName();
            consistencyCheck.addErrorMessage((String)errorMessage2);
        }
        return consistencyCheck;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQDispersionCoefSettings.class);
        }
    }
}

