/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.dispersion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqengineimpl.dispersion.WQReservoirDispersionEntrainmentSettingsBuilder;
import hec.wqengineimpl.dispersion.WQReservoirEntrainmentInflowSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class WQReservoirDispersionEntrainmentSettings
implements ReservoirDispersionEntrainmentSettings {
    @JsonProperty(value="useSameSettingsForAllInflows")
    private boolean _useSameSettingsForAllInflows = true;
    @JsonProperty(value="entrainmentInflowSettings")
    @JsonDeserialize(contentAs=WQReservoirEntrainmentInflowSetting.class)
    @JsonSerialize(contentAs=WQReservoirEntrainmentInflowSetting.class)
    private List<ReservoirEntrainmentInflowSetting> _inflowSettings = new ArrayList<ReservoirEntrainmentInflowSetting>();

    WQReservoirDispersionEntrainmentSettings() {
    }

    WQReservoirDispersionEntrainmentSettings(WQReservoirDispersionEntrainmentSettingsBuilder builder) {
        this._useSameSettingsForAllInflows = builder.useSameSettingsForAllInflows();
        this._inflowSettings = builder.getInflowSettings();
    }

    public boolean useSameSettingsForAllInflows() {
        return this._useSameSettingsForAllInflows;
    }

    @JsonDeserialize(contentAs=WQReservoirEntrainmentInflowSetting.class)
    @JsonSerialize(contentAs=WQReservoirEntrainmentInflowSetting.class)
    public List<ReservoirEntrainmentInflowSetting> getEntrainmentInflowSettings() {
        return new ArrayList<ReservoirEntrainmentInflowSetting>(this._inflowSettings);
    }

    @JsonIgnore
    public Optional<ReservoirEntrainmentInflowSetting> getInflowSetting(SubDomainBoundaryRef ref) {
        List<ReservoirEntrainmentInflowSetting> inflowSettings = this.getEntrainmentInflowSettings();
        return inflowSettings.stream().filter(setting -> setting.getInflowId() == ref.getId()).findFirst();
    }
}

