/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.dispersion;

import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqengineimpl.dispersion.WQReservoirDispersionEntrainmentSettings;
import java.util.ArrayList;
import java.util.List;

public final class WQReservoirDispersionEntrainmentSettingsBuilder {
    private boolean _useSameSettingsForAllInflows;
    private List<ReservoirEntrainmentInflowSetting> _inflowSettings;

    public WQReservoirDispersionEntrainmentSettingsBuilder fromExisting(ReservoirDispersionEntrainmentSettings entrainmentSettings) {
        this._useSameSettingsForAllInflows = entrainmentSettings.useSameSettingsForAllInflows();
        this._inflowSettings = entrainmentSettings.getEntrainmentInflowSettings();
        return this;
    }

    public WQReservoirDispersionEntrainmentSettingsBuilder withUseSameSettingsForAllInflows(boolean useSameSettingsForAllInflows) {
        this._useSameSettingsForAllInflows = useSameSettingsForAllInflows;
        return this;
    }

    public WQReservoirDispersionEntrainmentSettingsBuilder withInflowSettings(List<ReservoirEntrainmentInflowSetting> inflowSettings) {
        this._inflowSettings = inflowSettings;
        return this;
    }

    public ReservoirDispersionEntrainmentSettings build() {
        return new WQReservoirDispersionEntrainmentSettings(this);
    }

    boolean useSameSettingsForAllInflows() {
        return this._useSameSettingsForAllInflows;
    }

    List<ReservoirEntrainmentInflowSetting> getInflowSettings() {
        return new ArrayList<ReservoirEntrainmentInflowSetting>(this._inflowSettings);
    }
}

