/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.dispersion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.dispersion.AlternateMixingMethod;
import hec.wqenginecore.dispersion.MunkAndersonDispersionData;
import hec.wqenginecore.dispersion.ReservoirDispersionEntrainmentSettings;
import hec.wqenginecore.dispersion.ReservoirDispersionSettings;
import hec.wqenginecore.dispersion.StabilityDispersionData;
import hec.wqenginecore.dispersion.VerticalMixingType;
import hec.wqenginecore.dispersion.WindDispersionData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.dispersion.WQReservoirDispersionEntrainmentSettings;
import hec.wqengineimpl.dispersion.WQReservoirDispersionEntrainmentSettingsBuilder;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQReservoirDispersionSettings
implements ReservoirDispersionSettings {
    private VerticalMixingType _mixingType = VerticalMixingType.FROM_DENSITY_PROFILE;
    private AlternateMixingMethod _mixingMethod = AlternateMixingMethod.STABILITY;
    private StabilityDispersionData _stabilityData;
    private WindDispersionData _windData;
    private MunkAndersonDispersionData _munkAndersonData;
    @JsonDeserialize(as=WQReservoirDispersionEntrainmentSettings.class)
    @JsonSerialize(as=WQReservoirDispersionEntrainmentSettings.class)
    private ReservoirDispersionEntrainmentSettings _entrainmentSettings;
    @JsonProperty(value="useMaxInflowEnvelopeHeight")
    private boolean _useMaxInflowEnvelopeHeight = false;
    @JsonProperty(value="useMaxOutflowEnvelopeHeight")
    private boolean _useMaxOutflowEnvelopeHeight = false;
    @JsonProperty(value="maxInflowEnvelopeHeight")
    private Double _maxInflowEnvelopeHeight;
    @JsonProperty(value="maxOutflowEnvelopeHeight")
    private Double _maxOutflowEnvelopeHeight;
    @JsonProperty(value="mixedLayerTolerance")
    private Double _mixedLayerTolerance;

    public WQReservoirDispersionSettings() {
        this._stabilityData = new StabilityDispersionData();
        this._windData = new WindDispersionData();
        this._munkAndersonData = new MunkAndersonDispersionData();
        this._entrainmentSettings = new WQReservoirDispersionEntrainmentSettings();
        this._mixedLayerTolerance = 0.01;
        this._useMaxInflowEnvelopeHeight = false;
        this._useMaxOutflowEnvelopeHeight = false;
    }

    public WQReservoirDispersionSettings(int unitSys) {
        this._stabilityData = new StabilityDispersionData(unitSys);
        this._windData = new WindDispersionData(unitSys);
        this._munkAndersonData = new MunkAndersonDispersionData(unitSys);
        this._entrainmentSettings = new WQReservoirDispersionEntrainmentSettings();
        this._mixedLayerTolerance = 0.01;
        this._useMaxInflowEnvelopeHeight = false;
        this._useMaxOutflowEnvelopeHeight = false;
    }

    public VerticalMixingType getVerticalMixingType() {
        return this._mixingType;
    }

    public void setVerticalMixingType(VerticalMixingType mixingType) {
        this._mixingType = mixingType;
    }

    public AlternateMixingMethod getAlternateMixingMethod() {
        return this._mixingMethod;
    }

    public void setAlternateMixingMethod(AlternateMixingMethod method) {
        this._mixingMethod = method;
    }

    public StabilityDispersionData getStabilityData() {
        return this._stabilityData;
    }

    public void setStabilityData(StabilityDispersionData data) {
        this._stabilityData = data;
    }

    public WindDispersionData getWindData() {
        return this._windData;
    }

    public void setWindData(WindDispersionData data) {
        this._windData = data;
    }

    public MunkAndersonDispersionData getMunkAndersonData() {
        return this._munkAndersonData;
    }

    public void setMunkAndersonData(MunkAndersonDispersionData data) {
        this._munkAndersonData = data;
    }

    @JsonDeserialize(as=WQReservoirDispersionEntrainmentSettings.class)
    @JsonSerialize(as=WQReservoirDispersionEntrainmentSettings.class)
    public ReservoirDispersionEntrainmentSettings getEntrainmentSettings() {
        return new WQReservoirDispersionEntrainmentSettingsBuilder().fromExisting(this._entrainmentSettings).build();
    }

    @JsonProperty(value="mixedLayerTolerance")
    public Double getMixedLayerTolerance() {
        return this._mixedLayerTolerance;
    }

    @JsonIgnore
    public void setMixedLayerTolerance(Double mixedLayerTolerance) {
        this._mixedLayerTolerance = mixedLayerTolerance;
    }

    public void setEntrainmentSettings(ReservoirDispersionEntrainmentSettings settings) {
        this._entrainmentSettings = settings;
    }

    @JsonProperty(value="useMaxInflowEnvelopeHeight")
    public boolean useMaxInflowEnvelopeHeight() {
        return this._useMaxInflowEnvelopeHeight;
    }

    public void setUseMaxInflowEnvelopeHeight(boolean useMaxInflowEnvelopeHeight) {
        this._useMaxInflowEnvelopeHeight = useMaxInflowEnvelopeHeight;
    }

    @JsonProperty(value="useMaxOutflowEnvelopeHeight")
    public boolean useMaxOutflowEnvelopeHeight() {
        return this._useMaxOutflowEnvelopeHeight;
    }

    public void setUseMaxOutflowEnvelopeHeight(boolean useMaxOutflowEnvelopeHeight) {
        this._useMaxOutflowEnvelopeHeight = useMaxOutflowEnvelopeHeight;
    }

    public Double getMaxInflowEnvelopeHeight() {
        return this._maxInflowEnvelopeHeight;
    }

    public void setMaxInflowEnvelopeHeight(Double maxInflowEnvelopeHeight) {
        this._maxInflowEnvelopeHeight = maxInflowEnvelopeHeight;
    }

    public Double getMaxOutflowEnvelopeHeight() {
        return this._maxOutflowEnvelopeHeight;
    }

    public void setMaxOutflowEnvelopeHeight(Double maxOutflowEnvelopeHeight) {
        this._maxOutflowEnvelopeHeight = maxOutflowEnvelopeHeight;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQReservoirDispersionSettings.class);
        }
    }
}

