/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.dispersion;

import hec.wqenginecore.dispersion.EntrainmentCalculationType;
import hec.wqenginecore.dispersion.ReservoirEntrainmentInflowSetting;
import hec.wqengineimpl.dispersion.WQReservoirDispersionDefaultSettings;
import hec.wqengineimpl.dispersion.WQReservoirEntrainmentInflowSetting;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;

public class WQReservoirEntrainmentInflowSettingBuilder {
    private int _inflowId = -1;
    private String _inflowName;
    private boolean _useEntrainment = true;
    private Double _initialMixingRatio = 0.15;
    private Double _entrainmentRate;
    private EntrainmentCalculationType _entrainmentRateType = WQReservoirDispersionDefaultSettings.DEFAULT_ENTRAINMENT_RATE_TYPE;
    private Double _streamSlope;
    private EntrainmentCalculationType _streamSlopeType = WQReservoirDispersionDefaultSettings.DEFAULT_SLOPE_CALCULATION_TYPE;
    private Double _streamCrossSectionHalfAngle = 85.0;

    public WQReservoirEntrainmentInflowSettingBuilder fromExisting(ReservoirEntrainmentInflowSetting existing) {
        this._inflowId = existing.getInflowId();
        this._inflowName = existing.getInflowName();
        this._useEntrainment = existing.useEntrainment();
        this._initialMixingRatio = existing.getInitialMixingRatio();
        this._entrainmentRate = existing.getEntrainmentRate();
        this._entrainmentRateType = existing.getEntrainmentRateType();
        this._streamSlope = existing.getStreamSlope();
        this._streamSlopeType = existing.getStreamSlopeType();
        this._streamCrossSectionHalfAngle = existing.getStreamCrossSectionHalfAngle();
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withWQSubDomainBoundaryRef(WQSubDomainBoundaryRef inflowRef) {
        this._inflowName = inflowRef.getName();
        this._inflowId = inflowRef.getId();
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withInflowId(int inflowId) {
        this._inflowId = inflowId;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withInflowName(String inflowName) {
        this._inflowName = inflowName;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withUseEntrainment(boolean useEntrainment) {
        this._useEntrainment = useEntrainment;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withInitialMixingRatio(Double initialMixingRatio) {
        this._initialMixingRatio = initialMixingRatio;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withEntrainmentRate(Double entrainmentRate) {
        this._entrainmentRate = entrainmentRate;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withEntrainmentRateType(EntrainmentCalculationType entrainmentRateType) {
        this._entrainmentRateType = entrainmentRateType;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withStreamSlope(Double streamSlope) {
        this._streamSlope = streamSlope;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withStreamSlopeType(EntrainmentCalculationType streamSlopeType) {
        this._streamSlopeType = streamSlopeType;
        return this;
    }

    public WQReservoirEntrainmentInflowSettingBuilder withStreamCrossSectionHalfAngle(Double streamCrossSectionHalfAngle) {
        this._streamCrossSectionHalfAngle = streamCrossSectionHalfAngle;
        return this;
    }

    public ReservoirEntrainmentInflowSetting build() {
        return new WQReservoirEntrainmentInflowSetting(this);
    }

    int getInflowId() {
        return this._inflowId;
    }

    String getInflowName() {
        return this._inflowName;
    }

    boolean useEntrainment() {
        return this._useEntrainment;
    }

    Double getInitialMixingRatio() {
        return this._initialMixingRatio;
    }

    Double getEntrainmentRate() {
        return this._entrainmentRate;
    }

    EntrainmentCalculationType getEntrainmentRateType() {
        return this._entrainmentRateType;
    }

    Double getStreamSlope() {
        return this._streamSlope;
    }

    EntrainmentCalculationType getStreamSlopeType() {
        return this._streamSlopeType;
    }

    Double getStreamCrossSectionHalfAngle() {
        return this._streamCrossSectionHalfAngle;
    }
}

