/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.lang.annotation.Scriptable;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQReachHydro;
import hec.wqenginecore.WQResHydro;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.geometry.WQControlDevice;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQGeometry;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import rma.services.annotations.ServiceProvider;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
@JsonIgnoreProperties(value={"_resLength", "_usesNullRouting"})
public class WQGeoSubDomain
implements SubDomain {
    private int _id = Integer.MIN_VALUE;
    private String _name = null;
    private SubDomainType _type;
    private int _elementId = Integer.MIN_VALUE;
    private static final int MAX_CELL_FACES = 12;
    public static final int OUTSIDE_SUBDOMAIN_FLAG = -2;
    private int _numCells = 0;
    private int _numFacesInternal = 0;
    private int _numFacesFlow = 0;
    private int _numFaces = 0;
    private List<int[]> _faceCells;
    private List<Integer> _flowFacesBoundaryIdx = new ArrayList<Integer>();
    private int[][] _cellFaces;
    private List<Integer> _upstreamElemIds = null;
    private List<Integer> _downstreamElemIds = null;
    private double[][] _cellCenterCoordinates;
    private double[] _cellLength;
    private WQReachHydro _reachHydro = null;
    private WQResHydro _resHydro = null;
    private List<WQControlDevice> _wqControlDevices = null;
    @JsonBackReference
    private WQGeometry _geometry;
    private double[][] _resElevArea;
    private double[][] _resElevStor;
    private int _numOutlets;
    private List<List<Double>> _resOutletElev;
    private List<List<Double>> _resOutletArea;
    private List<List<Integer>> _resReleaseElemId;
    private List<Integer> _resOutletBCIds;
    private int _resElevStorInterpType;
    @JsonProperty(value="xRAS")
    private double[] _xRAS;
    @JsonProperty(value="xRASRiver")
    private String[] _xRASRiver;
    @JsonProperty(value="xRASReach")
    private String[] _xRASReach;
    @JsonProperty(value="xRASStation")
    private String[] _xRASStation;
    @JsonProperty(value="xFace")
    private double[] _xFace;
    private Double _upstreamStation = null;
    private Double _downstreamStation = null;
    @JsonProperty(value="singleRASRiver")
    private String _singleRASRiver;
    @JsonProperty(value="singleRASReach")
    private String _singleRASReach;
    @JsonProperty(value="singleRASStation")
    private String _singleRASStation;

    public WQGeoSubDomain() {
    }

    public WQGeoSubDomain(int id, WQGeometry wqGeo, int elementId) {
        this._id = id;
        this._geometry = wqGeo;
        this._elementId = elementId;
    }

    public WQGeoSubDomain(int id, String name, WQGeometry wqGeo, int elementId) {
        this._id = id;
        this._name = name;
        this._geometry = wqGeo;
        this._elementId = elementId;
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    public void setGeometry(WQGeometry wqGeo) {
        this._geometry = wqGeo;
    }

    public int getElementId() {
        return this._elementId;
    }

    public void setElementId(int elementId) {
        this._elementId = elementId;
    }

    public void createDefaultReach(double length, double maxCellLength) {
        this._type = SubDomainType.REACH_1D;
        if (length < maxCellLength) {
            length = maxCellLength;
        }
        this._numCells = (int)Math.ceil(length / maxCellLength);
        this._numCells = Math.max(this._numCells, 2);
        this._numFacesInternal = this._numCells - 1;
        this._numFacesFlow = 2;
        this._numFaces = this._numFacesInternal + this._numFacesFlow;
        this._cellLength = new double[this._numCells];
        double cellLen = length / (double)this._numCells;
        Arrays.fill(this._cellLength, cellLen);
        this._faceCells = new ArrayList<int[]>();
        for (int[] row : this._cellFaces = new int[this._numCells][12]) {
            Arrays.fill(row, -2);
        }
        for (int j = 0; j < this._numFacesInternal; ++j) {
            int[] fc = new int[]{j, j + 1};
            this._faceCells.add(fc);
        }
        int[] usfc = new int[]{-2, 0};
        this._faceCells.add(usfc);
        int[] dsfc = new int[]{this._numCells - 1, -2};
        this._faceCells.add(dsfc);
        for (int i = 1; i < this._numCells - 1; ++i) {
            this._cellFaces[i][0] = i - 1;
            this._cellFaces[i][1] = i;
        }
        this._cellFaces[0][0] = this._numFacesInternal;
        this._cellFaces[0][1] = 0;
        this._cellFaces[this._numCells - 1][0] = this._numFacesInternal - 1;
        this._cellFaces[this._numCells - 1][1] = this._numFacesInternal + 1;
    }

    public void discretizeReservoir(double layerHeight, double resHeight) {
        this._type = SubDomainType.RESERVOIR_1DV;
        if (resHeight < layerHeight) {
            resHeight = layerHeight;
        }
        this._numCells = (int)Math.ceil(resHeight / layerHeight);
        this._cellLength = new double[this._numCells];
        double cellHt = resHeight / (double)this._numCells;
        Arrays.fill(this._cellLength, cellHt);
        this.finishReservoirDiscretization();
    }

    private void finishReservoirDiscretization() {
        this._numFacesInternal = this._numCells - 1;
        this._numFacesFlow = 2;
        this._numFaces = this._numFacesInternal + this._numFacesFlow;
        this._faceCells = new ArrayList<int[]>();
        for (int[] row : this._cellFaces = new int[this._numCells][12]) {
            Arrays.fill(row, -2);
        }
        for (int j = 0; j < this._numFacesInternal; ++j) {
            int[] fc = new int[]{j, j + 1};
            this._faceCells.add(fc);
        }
        this._cellFaces[0][0] = 0;
        for (int i = 1; i < this._numCells - 1; ++i) {
            this._cellFaces[i][0] = i - 1;
            this._cellFaces[i][1] = i;
        }
        this._cellFaces[this._numCells - 1][0] = this._numCells - 2;
    }

    public void discretizeReservoir(List<Double> origLayerElevs, double minResElev, double maxResElev) {
        ArrayList<Double> layerElevs = new ArrayList<Double>(origLayerElevs);
        this._type = SubDomainType.RESERVOIR_1DV;
        double elevTolerance = 0.001;
        int nLayerElevs = layerElevs.size();
        Collections.sort(layerElevs);
        if (layerElevs.isEmpty() || (Double)layerElevs.get(0) > maxResElev - elevTolerance || (Double)layerElevs.get(nLayerElevs - 1) < minResElev + elevTolerance) {
            this._numCells = 1;
            this._cellLength = new double[this._numCells];
            this._cellLength[0] = maxResElev - minResElev;
        } else {
            this._numCells = 1;
            double layerElev = (Double)layerElevs.get(0);
            int minIdx = Integer.MAX_VALUE;
            int maxIdx = -2147483647;
            for (int i = 0; i < nLayerElevs; ++i) {
                layerElev = (Double)layerElevs.get(i);
                if (!(layerElev > minResElev + elevTolerance) || !(layerElev < maxResElev - elevTolerance)) continue;
                ++this._numCells;
                minIdx = Math.min(minIdx, i);
                maxIdx = Math.max(maxIdx, i);
            }
            this._cellLength = new double[this._numCells];
            int count = 0;
            for (int i = minIdx; i < maxIdx + 1; ++i) {
                layerElev = (Double)layerElevs.get(i);
                this._cellLength[count] = i == minIdx ? layerElev - minResElev : layerElev - (Double)layerElevs.get(i - 1);
                ++count;
            }
            this._cellLength[count] = maxResElev - layerElev;
        }
        this.finishReservoirDiscretization();
    }

    public void createCellCenters(double upstreamPtx, double upstreamPty, double downstreamPtx, double downstreamPty, double minElev, double maxElev) {
        for (double[] row : this._cellCenterCoordinates = new double[this._numCells][3]) {
            Arrays.fill(row, 0.0);
        }
        double dx = (downstreamPtx - upstreamPtx) / (double)this._numCells;
        double dy = (downstreamPty - upstreamPty) / (double)this._numCells;
        double z = minElev;
        for (int i = 0; i < this._numCells; ++i) {
            double y;
            double x;
            if (this._type == SubDomainType.REACH_1D) {
                x = dx * (double)i + upstreamPtx + dx / 2.0;
                y = dy * (double)i + upstreamPty + dy / 2.0;
                this._cellCenterCoordinates[i][0] = x;
                this._cellCenterCoordinates[i][1] = y;
                this._cellCenterCoordinates[i][2] = z;
                continue;
            }
            x = 0.5 * (downstreamPtx - upstreamPtx) + upstreamPtx;
            y = 0.5 * (downstreamPty - upstreamPty) + upstreamPty;
            this._cellCenterCoordinates[i][0] = x;
            this._cellCenterCoordinates[i][1] = y;
            this._cellCenterCoordinates[i][2] = z += 0.5 * this._cellLength[i];
            z += 0.5 * this._cellLength[i];
        }
    }

    public int addFlowFaces(int[] fc) {
        this._faceCells.add(fc);
        ++this._numFaces;
        ++this._numFacesFlow;
        return this._numFaces - 1;
    }

    public void addFlowFaceBoundaryIdx(int idx) {
        this._flowFacesBoundaryIdx.add(idx);
    }

    public void addUpstreamElemId(int upid) {
        if (this._upstreamElemIds == null) {
            this._upstreamElemIds = new ArrayList<Integer>();
        }
        this._upstreamElemIds.add(upid);
    }

    public void addDownstreamElemId(int dnid) {
        if (this._downstreamElemIds == null) {
            this._downstreamElemIds = new ArrayList<Integer>();
        }
        this._downstreamElemIds.add(dnid);
    }

    public void createHydro() {
        if (this._type == SubDomainType.REACH_1D) {
            if (this._reachHydro == null) {
                this._reachHydro = new WQReachHydro();
            }
        } else if (this._type == SubDomainType.RESERVOIR_1DV && this._resHydro == null) {
            this._resHydro = new WQResHydro();
        }
    }

    public void saveElementState(WQEngineAdapter.STATE state) {
        if (this._reachHydro != null) {
            this._reachHydro.saveElementState(state);
        } else if (this._resHydro != null) {
            this._resHydro.saveElementState(state);
        }
    }

    public void restoreElementState(WQEngineAdapter.STATE state) {
        if (this._reachHydro != null) {
            this._reachHydro.restoreElementState(state);
        } else if (this._resHydro != null) {
            this._resHydro.restoreElementState(state);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setElevAreaData(double[][] resElevArea) {
        this._resElevArea = resElevArea;
    }

    public void setElevStorData(double[][] resElevStor) {
        this._resElevStor = resElevStor;
    }

    public void setNumOutlets(int numOutlets) {
        this._numOutlets = numOutlets;
    }

    public void setOutletElevData(List<List<Double>> resOutletElev) {
        this._resOutletElev = resOutletElev;
    }

    public void setOutletAreaData(List<List<Double>> resOutletArea) {
        this._resOutletArea = resOutletArea;
    }

    public void setResReleaseElemId(List<List<Integer>> resReleaseElemId) {
        this._resReleaseElemId = resReleaseElemId;
    }

    public List<List<Integer>> getResReleaseElemId() {
        return this._resReleaseElemId;
    }

    public void setOutletBCIds(ArrayList<Integer> resOutletBCIds) {
        this._resOutletBCIds = resOutletBCIds;
    }

    public int getId() {
        return this._id;
    }

    @JsonIgnore
    public int getTypeId() {
        return this._type.id();
    }

    public SubDomainType getType() {
        return this._type;
    }

    public int getNumCells() {
        return this._numCells;
    }

    public int getNumFacesInternal() {
        return this._numFacesInternal;
    }

    public int getNumFacesFlow() {
        return this._numFacesFlow;
    }

    public int getNumFaces() {
        return this._numFaces;
    }

    public int[][] getCellFaces() {
        return this._cellFaces;
    }

    public List<int[]> getFaceCells() {
        return this._faceCells;
    }

    public double[][] getCellCenterCoordinates() {
        return this._cellCenterCoordinates;
    }

    @JsonIgnore
    public int[][] get2DArrayFaceCells() {
        int[][] fcarray = new int[this._numFaces][2];
        int count = 0;
        for (int[] fc : this._faceCells) {
            fcarray[count][0] = fc[0];
            fcarray[count][1] = fc[1];
            ++count;
        }
        return fcarray;
    }

    @JsonIgnore
    public int[] getArrayFlowFaceBoundaryIdx() {
        int[] bcidx = new int[this._numFacesFlow];
        int count = 0;
        for (Integer bci : this._flowFacesBoundaryIdx) {
            bcidx[count] = bci;
            ++count;
        }
        return bcidx;
    }

    public List<Integer> getUpstreamElemIds() {
        return this._upstreamElemIds;
    }

    public List<Integer> getDownstreamElemIds() {
        return this._downstreamElemIds;
    }

    public String getName() {
        return this._name;
    }

    public double[] getCellLength() {
        return this._cellLength;
    }

    public WQReachHydro getReachHydro() {
        return this._reachHydro;
    }

    public WQResHydro getResHydro() {
        return this._resHydro;
    }

    @JsonIgnore
    public double[][] getElevAreaData() {
        return this._resElevArea;
    }

    @JsonIgnore
    public double[][] getElevStorData() {
        return this._resElevStor;
    }

    public int getNumOutlets() {
        return this._numOutlets;
    }

    @JsonIgnore
    public List<List<Double>> getOutletElev() {
        return this._resOutletElev;
    }

    @JsonIgnore
    public List<List<Double>> getOutletArea() {
        return this._resOutletArea;
    }

    @JsonIgnore
    public List<Integer> getOutletBCIds() {
        return this._resOutletBCIds;
    }

    public int getElevStorInterpType() {
        return this._resElevStorInterpType;
    }

    @Scriptable
    @JsonIgnore
    public double[] getResLayerBoundaryElevs() {
        double tempElev;
        double[] layerBounds = new double[this._numCells + 1];
        layerBounds[0] = tempElev = this._resElevStor[0][0];
        for (int j = 0; j < this._numCells; ++j) {
            layerBounds[j + 1] = tempElev += this._cellLength[j];
        }
        return layerBounds;
    }

    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public WQSubDomainRef getRef() {
        return this._geometry.buildRef(this);
    }

    @JsonIgnore
    public double[] getXFace() {
        return this._xFace;
    }

    @JsonIgnore
    public double[] getXRAS() {
        return this._xRAS;
    }

    public void setXRAS(double[] lengthRatios) {
        this._xRAS = lengthRatios;
    }

    @JsonIgnore
    public void setXRAS(double[] lengthRatios, String[] rivers, String[] reaches, String[] stations) {
        this._xRAS = lengthRatios;
        this._xRASRiver = rivers;
        this._xRASReach = reaches;
        this._xRASStation = stations;
    }

    @JsonIgnore
    public String[] getXRASRiver() {
        return this._xRASRiver;
    }

    public void setXRASRiver(String[] rivers) {
        this._xRASRiver = rivers;
    }

    @JsonIgnore
    public String[] getXRASReach() {
        return this._xRASReach;
    }

    public void setXRASReach(String[] reaches) {
        this._xRASReach = reaches;
    }

    @JsonIgnore
    public String[] getXRASStation() {
        return this._xRASStation;
    }

    public void setXRASStation(String[] stations) {
        this._xRASStation = stations;
    }

    public void setXFace(double[] xFace) {
        this._xFace = xFace;
    }

    public void setSingleRiverReachStation(String river, String reach, String station) {
        this._singleRASRiver = river;
        this._singleRASReach = reach;
        this._singleRASStation = station;
    }

    public String getSingleRASRiver() {
        return this._singleRASRiver;
    }

    public String getSingleRASReach() {
        return this._singleRASReach;
    }

    public String getSingleRASStation() {
        return this._singleRASStation;
    }

    public void updateAndRecalculate(double[] xFace, double rssLength) {
        this.setXFace(xFace);
        int oldNumCells = this._numCells;
        this._numCells = this._xFace.length - 1;
        int numAdded = this._numCells - oldNumCells;
        if (numAdded > 0) {
            this._faceCells = WQGeoSubDomain.addFaceCells(this._numFacesInternal, this._faceCells, numAdded);
            this._numFacesInternal += numAdded;
            this._numFaces += numAdded;
        } else if (numAdded < 0) {
            this._faceCells = WQGeoSubDomain.removeFaceCells(this._numFacesInternal, this._faceCells, -numAdded);
            this._numFacesInternal += numAdded;
            this._numFaces += numAdded;
        }
        int numEntries = 10;
        if (this._cellFaces != null && this._cellFaces.length > 0 && this._cellFaces[0] != null) {
            numEntries = this._cellFaces[0].length;
        }
        this._cellFaces = WQGeoSubDomain.buildCellFaces(this._numCells, numEntries, this._faceCells);
        this._cellLength = WQGeoSubDomain.lengthsFromXFace(this._xFace, rssLength);
    }

    public static int[][] buildCellFaces(int numCells, int numEntries, List<int[]> faceCells) {
        int i;
        ArrayList cellFaces = new ArrayList();
        for (i = 0; i < numCells; ++i) {
            cellFaces.add(new ArrayList());
        }
        for (i = 0; i < faceCells.size(); ++i) {
            int[] indexes;
            for (int index : indexes = faceCells.get(i)) {
                if (index == -2 || index >= cellFaces.size()) continue;
                List cellFaceEntry = (List)cellFaces.get(index);
                cellFaceEntry.add(i);
            }
        }
        int[][] retval = new int[numCells][numEntries];
        for (int i2 = 0; i2 < numCells; ++i2) {
            List entries = (List)cellFaces.get(i2);
            retval[i2] = IntStream.range(0, numEntries).map(v -> v < entries.size() ? (Integer)entries.get(v) : -2).toArray();
        }
        return retval;
    }

    public static List<int[]> addFaceCells(int numFacesInternal, List<int[]> faceCells, int numToAdd) {
        List<int[]> chainPart = faceCells.subList(0, numFacesInternal);
        List<int[]> tailPart = faceCells.subList(numFacesInternal, faceCells.size());
        ArrayList<int[]> newFaceCells = new ArrayList<int[]>();
        newFaceCells.addAll(chainPart);
        for (int i = 0; i < numToAdd; ++i) {
            newFaceCells.add(new int[]{numFacesInternal + i, numFacesInternal + i + 1});
        }
        List<int[]> newTailPart = WQGeoSubDomain.addToEntriesAbove(tailPart, numFacesInternal - 1, numToAdd);
        newFaceCells.addAll(newTailPart);
        return newFaceCells;
    }

    public static List<int[]> removeFaceCells(int numFacesInternal, List<int[]> faceCells, int numToRemove) {
        List<int[]> chainPart = faceCells.subList(0, numFacesInternal - numToRemove);
        List<int[]> tailPart = faceCells.subList(numFacesInternal, faceCells.size());
        ArrayList<int[]> newFaceCells = new ArrayList<int[]>();
        newFaceCells.addAll(chainPart);
        List<int[]> newTailPart = WQGeoSubDomain.addToEntriesAbove(tailPart, numFacesInternal - 1, -numToRemove);
        newFaceCells.addAll(newTailPart);
        return newFaceCells;
    }

    private static List<int[]> addToEntriesAbove(List<int[]> tailPart, int threshold, int toAdd) {
        ArrayList<int[]> retval = new ArrayList<int[]>();
        for (int[] ints : tailPart) {
            int[] modified = IntStream.of(ints).map(i -> i > threshold ? i + toAdd : i).toArray();
            retval.add(modified);
        }
        return retval;
    }

    public static double[] lengthsFromXFace(double[] xFace, double rssLength) {
        double[] lengths = null;
        if (xFace != null) {
            lengths = new double[xFace.length - 1];
            for (int i = 0; i < xFace.length - 1; ++i) {
                double current = xFace[i];
                double next = xFace[i + 1];
                double diff = current - next;
                lengths[i] = BigDecimal.valueOf(Math.abs(diff) * rssLength).setScale(6, RoundingMode.HALF_UP).doubleValue();
            }
        }
        return lengths;
    }

    public static double[] centerRatioFromXFace(double[] xFace) {
        double[] centers = null;
        if (xFace != null) {
            centers = new double[xFace.length - 1];
            for (int i = 0; i < xFace.length - 1; ++i) {
                double current = xFace[i];
                double next = xFace[i + 1];
                centers[i] = (current + next) / 2.0;
            }
        }
        return centers;
    }

    public int getCellIdxForStation(double statDist) {
        int cellIdx = -1;
        double buffer = 1.0E-6;
        statDist = Math.max(buffer, Math.min(1.0 - buffer, statDist));
        if (this._xFace != null) {
            for (int i = 1; i < this._xFace.length; ++i) {
                double cellUsDist = this._xFace[i - 1];
                double cellDsDist = this._xFace[i];
                if (!(statDist < cellUsDist) || !(statDist >= cellDsDist)) continue;
                cellIdx = i - 1;
                break;
            }
        }
        return cellIdx;
    }

    public void setCellCenterCoordinates(double[][] centers) {
        this._cellCenterCoordinates = centers;
    }

    public void setCellLength(double[] cellLengths) {
        this._cellLength = cellLengths;
    }

    public void setElevStorInterpType(int interpType) {
        this._resElevStorInterpType = interpType;
    }

    public Double getUpstreamStation() {
        return this._upstreamStation;
    }

    public void setUpstreamStation(Double upstreamStation) {
        this._upstreamStation = upstreamStation;
    }

    public Double getDownstreamStation() {
        return this._downstreamStation;
    }

    @JsonIgnore
    public int getWqControlDeviceId(int rssReleaseElemId) {
        for (WQControlDevice wqcd : this._wqControlDevices) {
            if (wqcd.getRssReleaseElemId() != rssReleaseElemId) continue;
            return wqcd.getId();
        }
        return -1;
    }

    public List<WQControlDevice> getWqControlDevices() {
        return this._wqControlDevices;
    }

    public void clearWqControlDevices() {
        if (this._wqControlDevices != null) {
            this._wqControlDevices.clear();
        }
    }

    public void setWqControlDevices(List<WQControlDevice> wqControlDevices) {
        this._wqControlDevices = wqControlDevices;
    }

    public void setWqControlDevice(WQControlDevice wqControlDevice) {
        this._wqControlDevices = Arrays.asList(wqControlDevice);
    }

    public void addWqControlDevice(WQControlDevice wqControlDevice) {
        if (this._wqControlDevices == null) {
            this._wqControlDevices = new ArrayList<WQControlDevice>();
        }
        int rssReleaseElemId = wqControlDevice.getRssReleaseElemId();
        int removeIdx = -1;
        for (int j = 0; j < this._wqControlDevices.size(); ++j) {
            if (rssReleaseElemId != this._wqControlDevices.get(j).getRssReleaseElemId()) continue;
            removeIdx = j;
            break;
        }
        if (removeIdx >= 0) {
            this._wqControlDevices.remove(removeIdx);
        }
        this._wqControlDevices.add(wqControlDevice);
    }

    public void setDownstreamStation(Double downstreamStation) {
        this._downstreamStation = downstreamStation;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQGeoSubDomain.class);
        }
    }
}

