/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeometry;
import rma.services.annotations.ServiceProvider;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQGeoSubDomainBoundary
implements SubDomainBoundary {
    private int _id;
    private int _jnctId;
    private String _name = null;
    private int _upstreamSubDomainId = -2;
    private int _downstreamSubDomainId = -2;
    private BoundaryType _type;
    private double _savedFlow = 0.0;
    private double _distToResDam = 0.0;
    private boolean _inExtent = true;
    private int _dsDiversionJnctId = -1;
    @JsonBackReference
    private WQGeometry _geometry;

    public WQGeoSubDomainBoundary() {
    }

    public WQGeoSubDomainBoundary(WQGeometry wqGeo, int id, String name, WQGeoSubDomain upstreamWQSd, WQGeoSubDomain downstreamWQSd, boolean isUpstreamNetworkBoundary, int jnctId) {
        this(wqGeo, id, name, WQGeoSubDomainBoundary.getSubDomainId(upstreamWQSd), WQGeoSubDomainBoundary.getSubDomainId(downstreamWQSd), jnctId, WQGeoSubDomainBoundary.determineType(upstreamWQSd, downstreamWQSd, isUpstreamNetworkBoundary));
    }

    public WQGeoSubDomainBoundary(WQGeometry wqGeo, int id, String name, WQGeoSubDomain upstreamWQSd, WQGeoSubDomain downstreamWQSd, int jnctId, BoundaryType bType) {
        this(wqGeo, id, name, WQGeoSubDomainBoundary.getSubDomainId(upstreamWQSd), WQGeoSubDomainBoundary.getSubDomainId(downstreamWQSd), jnctId, bType);
    }

    public WQGeoSubDomainBoundary(WQGeometry wqGeo, int id, String name, int upstreamWQSdId, int downstreamWQSdId, int jnctId, BoundaryType bType) {
        this._geometry = wqGeo;
        this._id = id;
        this._jnctId = jnctId;
        this._type = bType;
        this._name = name;
        this._upstreamSubDomainId = upstreamWQSdId;
        this._downstreamSubDomainId = downstreamWQSdId;
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    public void setGeometry(WQGeometry wqGeo) {
        this._geometry = wqGeo;
    }

    public static int getSubDomainId(WQGeoSubDomain sd) {
        int retval = -2;
        if (sd != null) {
            retval = sd.getId();
        }
        return retval;
    }

    public static BoundaryType determineType(WQGeoSubDomain upstreamWQSd, WQGeoSubDomain downstreamWQSd, boolean isUpstreamNetworkBoundary) {
        BoundaryType type = null;
        if (upstreamWQSd == null) {
            type = downstreamWQSd.getType() == SubDomainType.REACH_1D ? (isUpstreamNetworkBoundary ? BoundaryType.RIVER_INFLOW : BoundaryType.RIVER_INFLOW_IN_NETWORK) : (isUpstreamNetworkBoundary ? BoundaryType.RESERVOIR_INFLOW : BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
        } else if (downstreamWQSd == null) {
            type = upstreamWQSd.getType() == SubDomainType.REACH_1D ? BoundaryType.RIVER_OUTFLOW : BoundaryType.RESERVOIR_OUTFLOW;
        } else if (upstreamWQSd.getType() == SubDomainType.REACH_1D && downstreamWQSd.getType() == SubDomainType.REACH_1D) {
            type = BoundaryType.RIVER_2_RIVER;
        } else if (upstreamWQSd.getType() == SubDomainType.RESERVOIR_1DV && downstreamWQSd.getType() == SubDomainType.REACH_1D) {
            type = BoundaryType.RESERVOIR_2_RIVER;
        } else if (upstreamWQSd.getType() == SubDomainType.REACH_1D && downstreamWQSd.getType() == SubDomainType.RESERVOIR_1DV) {
            type = BoundaryType.RIVER_2_RESERVOIR;
        } else if (upstreamWQSd.getType() == SubDomainType.RESERVOIR_1DV && downstreamWQSd.getType() == SubDomainType.RESERVOIR_1DV) {
            type = BoundaryType.RESERVOIR_2_RESERVOIR;
        }
        return type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setInExtent(boolean inExtent) {
        this._inExtent = inExtent;
    }

    public boolean getInExtent() {
        return this._inExtent;
    }

    public void setJnctId(int jnctId) {
        this._jnctId = jnctId;
    }

    public void setBoundaryType(BoundaryType type) {
        this._type = type;
    }

    public void setSavedFlow(double flow) {
        this._savedFlow = flow;
    }

    public int getId() {
        return this._id;
    }

    public int getUpstreamSubDomainId() {
        return this._upstreamSubDomainId;
    }

    public int getDownstreamSubDomainId() {
        return this._downstreamSubDomainId;
    }

    @JsonIgnore
    public int getBoundaryTypeId() {
        return this._type.id();
    }

    @JsonIgnore
    public BoundaryType getBoundaryType() {
        return this._type;
    }

    public int getJnctId() {
        return this._jnctId;
    }

    public int getDsDiversionJnctId() {
        return this._dsDiversionJnctId;
    }

    public void setDsDiversionJnctId(int jnctId) {
        this._dsDiversionJnctId = jnctId;
    }

    public double getSavedFlow() {
        return this._savedFlow;
    }

    @JsonIgnore
    public boolean isLocal() {
        return this._type == BoundaryType.LOCAL_INFLOW || this._type == BoundaryType.LOCAL_DIVERSION;
    }

    @JsonIgnore
    public boolean isInflow() {
        return this._type == BoundaryType.RESERVOIR_INFLOW_IN_NETWORK || this._type == BoundaryType.RIVER_INFLOW_IN_NETWORK || this._type == BoundaryType.LOCAL_INFLOW;
    }

    public boolean isInflow(SubDomain subdom) {
        if (this.isInflow()) {
            return true;
        }
        if (this.isOutflow()) {
            return false;
        }
        return this._downstreamSubDomainId == subdom.getId();
    }

    @JsonIgnore
    public void setDistToResDam(double distToResDam) {
        this._distToResDam = distToResDam;
    }

    @JsonIgnore
    public double getDistToResDam() {
        return this._distToResDam;
    }

    @JsonIgnore
    public boolean isOutflow() {
        if (this._type == BoundaryType.RIVER_OUTFLOW) {
            return true;
        }
        if (this._type == BoundaryType.RESERVOIR_OUTFLOW) {
            return true;
        }
        return this._type == BoundaryType.LOCAL_DIVERSION;
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public SubDomainBoundaryRef getRef() {
        return this._geometry.buildRef(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQGeoSubDomainBoundary.class);
        }
    }
}

