/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainJunctionRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.geometry.WQGeometry;
import java.util.ArrayList;
import java.util.List;
import rma.services.annotations.ServiceProvider;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQGeoSubDomainJunction
implements SubDomainJunction {
    private int _id;
    private int _jnctId;
    private String _name = null;
    private boolean _inExtent = true;
    @JsonIgnore
    private List<Integer> _upstreamElemIds = null;
    @JsonIgnore
    private List<Integer> _downstreamElemIds = null;
    protected List<WQGeoSubDomainBoundary> _boundaryList = new ArrayList<WQGeoSubDomainBoundary>();
    @JsonBackReference
    private WQGeometry _geometry;

    public WQGeoSubDomainJunction() {
    }

    public WQGeoSubDomainJunction(WQGeometry wqGeo, int id, String name, int jnctId) {
        this._geometry = wqGeo;
        this._id = id;
        this._name = name;
        this._jnctId = jnctId;
    }

    public void addBoundary(WQGeoSubDomainBoundary b) {
        this._boundaryList.add(b);
    }

    @JsonDeserialize(contentAs=WQGeoSubDomainBoundary.class)
    @JsonSerialize(contentAs=WQGeoSubDomainBoundary.class)
    public List<SubDomainBoundary> getBoundaryList() {
        ArrayList<SubDomainBoundary> bList = new ArrayList<SubDomainBoundary>();
        for (SubDomainBoundary subDomainBoundary : this._boundaryList) {
            bList.add(subDomainBoundary);
        }
        return bList;
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    public void setGeometry(WQGeometry wqGeo) {
        this._geometry = wqGeo;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setInExtent(boolean inExtent) {
        this._inExtent = inExtent;
    }

    public boolean getInExtent() {
        return this._inExtent;
    }

    public int getJnctId() {
        return this._jnctId;
    }

    public void setJnctId(int jnctId) {
        this._jnctId = jnctId;
    }

    @JsonIgnore
    public SubDomainJunctionRef getRef() {
        return this._geometry.buildRef(this);
    }

    public int findJunctionForMassInjection() {
        return this._id;
    }

    @JsonIgnore
    public List<Integer> getUpstreamElemIds() {
        return this._upstreamElemIds;
    }

    @JsonIgnore
    public void addUpstreamElemId(int upid) {
        if (this._upstreamElemIds == null) {
            this._upstreamElemIds = new ArrayList<Integer>();
        }
        this._upstreamElemIds.add(upid);
    }

    @JsonIgnore
    public List<Integer> getDownstreamElemIds() {
        return this._downstreamElemIds;
    }

    @JsonIgnore
    public void addDownstreamElemId(int dnid) {
        if (this._downstreamElemIds == null) {
            this._downstreamElemIds = new ArrayList<Integer>();
        }
        this._downstreamElemIds.add(dnid);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQGeoSubDomainJunction.class);
        }
    }
}

