/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Units;
import hec.lang.annotation.Scriptable;
import hec.wqenginecore.Extent;
import hec.wqenginecore.Region;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.flowtable.FlowTable;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQGeoSubDomainBoundary;
import hec.wqengineimpl.geometry.WQGeoSubDomainJunction;
import hec.wqengineimpl.geometry.WQMetAssignmentSet;
import hec.wqengineimpl.geometry.WQRegionRef;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import hec.wqengineimpl.geometry.WQSubDomainJunctionRef;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.region.WQRegion;
import hec.wqengineimpl.region.WQRegionSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
@JsonIgnoreProperties(value={"areaUnits", "topWidthUnits"})
public class WQGeometry
implements Geometry {
    private final int _id;
    @JsonManagedReference
    protected List<WQGeoSubDomain> _subDomainList = new ArrayList<WQGeoSubDomain>();
    @JsonManagedReference
    protected List<WQGeoSubDomainBoundary> _subDomainBoundaryList = new ArrayList<WQGeoSubDomainBoundary>();
    @JsonManagedReference
    protected List<WQGeoSubDomainJunction> _subDomainJnctList = new ArrayList<WQGeoSubDomainJunction>();
    @JsonIgnore
    private FlowTable _flowTable;
    @JsonIgnore
    private Units _areaUnits;
    @JsonIgnore
    private Units _topWidthUnits;
    @JsonIgnore
    private Units _flowUnits;
    private WQRegionSet _regionSet = new WQRegionSet();
    private WQMetAssignmentSet _metAssignmentSet = new WQMetAssignmentSet();
    @JsonIgnore
    private Extent _extent = null;

    @JsonCreator
    public WQGeometry(@JsonProperty(value="id") int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public WQRegionSet getRegionSet() {
        return this._regionSet;
    }

    public void setRegionSet(WQRegionSet regionSet) {
        this._regionSet = regionSet;
    }

    public WQMetAssignmentSet getMetAssignmentSet() {
        return this._metAssignmentSet;
    }

    @Deprecated
    public WQMetAssignmentSet getMetAssigmentSet() {
        return null;
    }

    @Deprecated
    public void setMetAssigmentSet(WQMetAssignmentSet metAssignmentSet) {
        this.setMetAssignmentSet(metAssignmentSet);
    }

    public void setMetAssignmentSet(WQMetAssignmentSet metAssignmentSet) {
        this._metAssignmentSet = metAssignmentSet == null ? new WQMetAssignmentSet() : metAssignmentSet;
    }

    @JsonDeserialize(contentAs=WQGeoSubDomain.class)
    @JsonSerialize(contentAs=WQGeoSubDomain.class)
    public List<SubDomain> getSubDomainList() {
        if (this._subDomainList == null) {
            return null;
        }
        return Collections.unmodifiableList(this._subDomainList);
    }

    @JsonIgnore
    public List<SubDomain> getSubDomainsInExtent() {
        Extent extent = this.getGeometryExtent();
        return this.getSubDomainList().stream().filter(d -> extent.contains(d.getRef())).collect(Collectors.toList());
    }

    @Scriptable
    @JsonIgnore
    public boolean isInExtent(SubDomain subdom) {
        List<SubDomain> extent = this.getSubDomainsInExtent();
        return extent.contains(subdom);
    }

    public boolean isWQJnctInExtent(SubDomainJunction jnct) {
        List<SubDomainJunction> jnctsInExtent = this.getWQJunctionsInExtent();
        return jnctsInExtent.contains(jnct);
    }

    @JsonIgnore
    public List<SubDomainBoundary> getBoundariesInExtent() {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        ArrayList<SubDomainBoundary> bList = new ArrayList<SubDomainBoundary>();
        for (SubDomainBoundary subDomainBoundary : this._subDomainBoundaryList) {
            if (!subDomainBoundary.getInExtent()) continue;
            bList.add(subDomainBoundary);
        }
        return bList;
    }

    @JsonIgnore
    public List<SubDomainJunction> getWQJunctionsInExtent() {
        ArrayList<SubDomainJunction> jList = new ArrayList<SubDomainJunction>();
        if (this._subDomainJnctList != null) {
            for (SubDomainJunction subDomainJunction : this._subDomainJnctList) {
                if (!subDomainJunction.getInExtent()) continue;
                jList.add(subDomainJunction);
            }
        }
        return jList;
    }

    @JsonIgnore
    public void updateWQJunctionsForExtent() {
        block0: for (SubDomainJunction subDomainJunction : this._subDomainJnctList) {
            subDomainJunction.setInExtent(false);
            for (SubDomainBoundary sdb : subDomainJunction.getBoundaryList()) {
                SubDomainBoundary origSDB = this.getSubDomainBoundary(sdb.getId());
                if (origSDB == null || !origSDB.getInExtent()) continue;
                subDomainJunction.setInExtent(true);
                continue block0;
            }
        }
    }

    @JsonIgnore
    private SubDomainBoundary getSubDomainBoundary(int sdbId) {
        for (SubDomainBoundary subDomainBoundary : this._subDomainBoundaryList) {
            if (subDomainBoundary.getId() != sdbId) continue;
            return subDomainBoundary;
        }
        return null;
    }

    @JsonIgnore
    public void updateBoundariesForExtent() {
        WQGeoSubDomain ussd;
        int usSDId;
        List<SubDomain> activeSDList = this.getSubDomainsInExtent();
        HashSet<Integer> jnctIdsInExtent = new HashSet<Integer>();
        for (WQGeoSubDomainBoundary wqsdb : this._subDomainBoundaryList) {
            WQGeoSubDomain dssd;
            usSDId = wqsdb.getUpstreamSubDomainId();
            int dsSDId = wqsdb.getDownstreamSubDomainId();
            if (usSDId < 0) {
                dssd = this.getSubDomain(dsSDId);
                if (activeSDList.contains(dssd)) {
                    wqsdb.setInExtent(true);
                } else {
                    wqsdb.setInExtent(false);
                }
            } else if (dsSDId < 0) {
                ussd = this.getSubDomain(usSDId);
                if (activeSDList.contains(ussd)) {
                    wqsdb.setInExtent(true);
                } else {
                    wqsdb.setInExtent(false);
                }
            } else {
                ussd = this.getSubDomain(usSDId);
                dssd = this.getSubDomain(dsSDId);
                if (activeSDList.contains(ussd) && activeSDList.contains(dssd)) {
                    wqsdb.setInExtent(true);
                    if (ussd.getType() == SubDomainType.REACH_1D && dssd.getType() == SubDomainType.REACH_1D) {
                        wqsdb.setBoundaryType(BoundaryType.RIVER_2_RIVER);
                    } else if (ussd.getType() == SubDomainType.REACH_1D && dssd.getType() == SubDomainType.RESERVOIR_1DV) {
                        wqsdb.setBoundaryType(BoundaryType.RIVER_2_RESERVOIR);
                    } else if (ussd.getType() == SubDomainType.RESERVOIR_1DV && dssd.getType() == SubDomainType.REACH_1D) {
                        wqsdb.setBoundaryType(BoundaryType.RESERVOIR_2_RIVER);
                    } else if (ussd.getType() == SubDomainType.RESERVOIR_1DV && dssd.getType() == SubDomainType.RESERVOIR_1DV) {
                        wqsdb.setBoundaryType(BoundaryType.RESERVOIR_2_RESERVOIR);
                    }
                } else if (!activeSDList.contains(ussd) && !activeSDList.contains(dssd)) {
                    wqsdb.setInExtent(false);
                } else if (!activeSDList.contains(dssd)) {
                    wqsdb.setInExtent(true);
                    if (ussd.getType() == SubDomainType.REACH_1D) {
                        wqsdb.setBoundaryType(BoundaryType.RIVER_OUTFLOW);
                    } else if (ussd.getType() == SubDomainType.RESERVOIR_1DV) {
                        wqsdb.setBoundaryType(BoundaryType.RESERVOIR_OUTFLOW);
                    }
                } else if (!activeSDList.contains(ussd)) {
                    wqsdb.setInExtent(true);
                    if (dssd.getType() == SubDomainType.REACH_1D) {
                        if (wqsdb.getBoundaryType() != BoundaryType.LOCAL_DIVERSION) {
                            wqsdb.setBoundaryType(BoundaryType.RIVER_INFLOW_IN_NETWORK);
                        }
                    } else if (dssd.getType() == SubDomainType.RESERVOIR_1DV) {
                        wqsdb.setBoundaryType(BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
                    }
                }
            }
            if (!wqsdb.getInExtent()) continue;
            jnctIdsInExtent.add(wqsdb.getJnctId());
        }
        for (WQGeoSubDomainBoundary wqsdb : this._subDomainBoundaryList) {
            if (wqsdb.getInExtent() || !jnctIdsInExtent.contains(wqsdb.getJnctId())) continue;
            usSDId = wqsdb.getUpstreamSubDomainId();
            if (wqsdb.getBoundaryType() == BoundaryType.LOCAL_INFLOW) {
                wqsdb.setInExtent(true);
                continue;
            }
            if (usSDId <= 0 || activeSDList.contains(ussd = this.getSubDomain(usSDId))) continue;
            wqsdb.setInExtent(true);
            if (ussd.getType() == SubDomainType.REACH_1D) {
                if (wqsdb.getBoundaryType() == BoundaryType.LOCAL_DIVERSION) continue;
                wqsdb.setBoundaryType(BoundaryType.RIVER_INFLOW_IN_NETWORK);
                continue;
            }
            wqsdb.setBoundaryType(BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
        }
    }

    @JsonIgnore
    public List<SubDomain> getSubDomainList(Predicate<SubDomain> filter) {
        return this._subDomainList == null ? new ArrayList<SubDomain>() : this._subDomainList.stream().filter(filter).collect(Collectors.toList());
    }

    public void setSubDomainList(List<WQGeoSubDomain> subDomainList) {
        this._subDomainList.clear();
        if (subDomainList != null) {
            this._subDomainList.addAll(subDomainList);
        }
    }

    public void setSubDomainBoundaryList(List<WQGeoSubDomainBoundary> subDomainBoundaryList) {
        this._subDomainBoundaryList.clear();
        if (subDomainBoundaryList != null) {
            this._subDomainBoundaryList.addAll(subDomainBoundaryList);
        }
    }

    public WQGeoSubDomain getSubDomain(int id) {
        if (this._subDomainList == null) {
            return null;
        }
        for (WQGeoSubDomain subdom : this._subDomainList) {
            if (subdom.getId() != id) continue;
            return subdom;
        }
        return null;
    }

    @JsonIgnore
    public List<SubDomainJunction> getJunctionsList() {
        if (this._subDomainJnctList == null) {
            return null;
        }
        return Collections.unmodifiableList(this._subDomainJnctList);
    }

    @JsonIgnore
    public List<SubDomainBoundary> getBoundariesList() {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        return Collections.unmodifiableList(this._subDomainBoundaryList);
    }

    public List<WQGeoSubDomainBoundary> getBoundariesList(WQGeoSubDomain wqsd) {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        ArrayList<WQGeoSubDomainBoundary> bList = new ArrayList<WQGeoSubDomainBoundary>();
        for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
            if (sdb.getUpstreamSubDomainId() != wqsd.getId() && sdb.getDownstreamSubDomainId() != wqsd.getId()) continue;
            bList.add(sdb);
        }
        return bList;
    }

    public WQGeoSubDomainBoundary getBoundary(int id) {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
            if (sdb.getId() != id) continue;
            return sdb;
        }
        return null;
    }

    public List<WQGeoSubDomainBoundary> findUpstreamBoundaries(int sdid) {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        ArrayList<WQGeoSubDomainBoundary> bList = new ArrayList<WQGeoSubDomainBoundary>();
        for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
            if (sdb.getDownstreamSubDomainId() != sdid) continue;
            bList.add(sdb);
        }
        return bList;
    }

    public List<WQGeoSubDomainBoundary> findUniqueUpstreamBoundaries(int sdid) {
        List<WQGeoSubDomainBoundary> usBoundList = this.findUpstreamBoundaries(sdid);
        ArrayList<WQGeoSubDomainBoundary> filtered_list = new ArrayList<WQGeoSubDomainBoundary>();
        ArrayList<Integer> jnctIdList = new ArrayList<Integer>();
        if (usBoundList != null) {
            for (WQGeoSubDomainBoundary sdb : usBoundList) {
                int jnctId = sdb.getJnctId();
                if (jnctIdList.contains(jnctId)) continue;
                jnctIdList.add(jnctId);
                filtered_list.add(sdb);
            }
        }
        return filtered_list;
    }

    public List<WQGeoSubDomainBoundary> findDownstreamBoundaries(int sdid) {
        if (this._subDomainBoundaryList == null) {
            return null;
        }
        ArrayList<WQGeoSubDomainBoundary> bList = new ArrayList<WQGeoSubDomainBoundary>();
        for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
            if (sdb.getUpstreamSubDomainId() != sdid) continue;
            bList.add(sdb);
        }
        return bList;
    }

    public List<WQGeoSubDomain> findDownstreamSubDomains(int jnctId) {
        if (this._subDomainList == null) {
            return null;
        }
        ArrayList<WQGeoSubDomain> sdList = new ArrayList<WQGeoSubDomain>();
        for (WQGeoSubDomain sd : this._subDomainList) {
            List<Integer> usIds = sd.getUpstreamElemIds();
            for (Integer usId : usIds) {
                if (usId != jnctId) continue;
                sdList.add(sd);
            }
        }
        return sdList;
    }

    public boolean checkBoundaryExists(int upstreamSubdomId, int downstreamSubdomId) {
        if (this._subDomainBoundaryList == null) {
            return false;
        }
        for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
            if (sdb.getUpstreamSubDomainId() != upstreamSubdomId || sdb.getDownstreamSubDomainId() != downstreamSubdomId) continue;
            return true;
        }
        return false;
    }

    public WQGeoSubDomainBoundary getBoundary(int upstreamSubdomId, int downstreamSubdomId) {
        WQGeoSubDomainBoundary rtnBound = null;
        if (this._subDomainBoundaryList != null) {
            for (WQGeoSubDomainBoundary sdb : this._subDomainBoundaryList) {
                if (sdb.getUpstreamSubDomainId() != upstreamSubdomId || sdb.getDownstreamSubDomainId() != downstreamSubdomId) continue;
                rtnBound = sdb;
                break;
            }
        }
        return rtnBound;
    }

    public void createBoundaries() throws WQException {
        if (this._subDomainList == null) {
            throw new WQException("Water Quality Subdomain List is Empty in createBoundaries");
        }
        int iboundCnt = 0;
        for (WQGeoSubDomain subdom : this._subDomainList) {
            iboundCnt = this.createUpstreamBoundaries(iboundCnt, subdom);
            iboundCnt = this.createDownstreamBoundaries(iboundCnt, subdom);
        }
        if (this._subDomainBoundaryList.size() < 1) {
            throw new WQException("Zero Water Quality Subdomain Boundaries identified for geometry in createBoundaries");
        }
    }

    private int createDownstreamBoundaries(int iboundCnt, WQGeoSubDomain subdom) {
        int sdId = subdom.getId();
        List<Integer> dsElemIds = subdom.getDownstreamElemIds();
        for (Integer dsElemId : dsElemIds) {
            boolean hasDownstreamSubdom = false;
            for (WQGeoSubDomain otherSubdom : this._subDomainList) {
                int otherSdId = otherSubdom.getId();
                if (otherSdId == sdId) continue;
                List<Integer> otherUsElemIds = otherSubdom.getUpstreamElemIds();
                for (Integer otherUsElemId : otherUsElemIds) {
                    if (otherUsElemId != dsElemId) continue;
                    hasDownstreamSubdom = true;
                    iboundCnt = this.addBoundaryIfAbsent(iboundCnt, subdom, sdId, dsElemId, otherSubdom);
                }
            }
            if (hasDownstreamSubdom) continue;
            WQGeoSubDomainBoundary sdbound = new WQGeoSubDomainBoundary(this, iboundCnt, null, subdom, null, false, dsElemId);
            this._subDomainBoundaryList.add(sdbound);
            ++iboundCnt;
        }
        return iboundCnt;
    }

    private int addBoundaryIfAbsent(int iboundCnt, WQGeoSubDomain subdom, int sdId, Integer dsElemId, WQGeoSubDomain otherSubdom) {
        boolean boundAlreadyExists = this.checkBoundaryExists(sdId, otherSubdom.getId());
        if (!boundAlreadyExists) {
            WQGeoSubDomainBoundary sdbound = new WQGeoSubDomainBoundary(this, iboundCnt, null, subdom, otherSubdom, false, dsElemId);
            this._subDomainBoundaryList.add(sdbound);
            ++iboundCnt;
        }
        return iboundCnt;
    }

    private int createUpstreamBoundaries(int iboundCnt, WQGeoSubDomain subdom) {
        int sdId = subdom.getId();
        List<Integer> usElemIds = subdom.getUpstreamElemIds();
        for (Integer usElemId : usElemIds) {
            boolean hasUpstreamSubdom = false;
            for (WQGeoSubDomain otherSubdom : this._subDomainList) {
                int otherSdId = otherSubdom.getId();
                if (otherSdId == sdId) continue;
                List<Integer> otherDsElemIds = otherSubdom.getDownstreamElemIds();
                for (Integer otherDsElemId : otherDsElemIds) {
                    if (otherDsElemId != usElemId) continue;
                    hasUpstreamSubdom = true;
                    iboundCnt = this.addBoundaryIfAbsent(iboundCnt, otherSubdom, otherSdId, usElemId, subdom);
                }
            }
            if (hasUpstreamSubdom) continue;
            WQGeoSubDomainBoundary sdbound = new WQGeoSubDomainBoundary(this, iboundCnt, null, null, subdom, true, usElemId);
            this._subDomainBoundaryList.add(sdbound);
            ++iboundCnt;
        }
        return iboundCnt;
    }

    public void associateBoundaries() throws WQException {
        if (this._subDomainList == null) {
            throw new WQException("Water Quality Subdomain List is Empty in associateBoundaries");
        }
        boolean addFlowFaceBdyIdx = true;
        for (WQGeoSubDomain subdom : this._subDomainList) {
            this.associateBoundaries(subdom, addFlowFaceBdyIdx);
        }
    }

    public void associateJncts() throws WQException {
        if (this._subDomainList == null) {
            throw new WQException("Water Quality Subdomain List is Empty in associateJncts");
        }
        for (WQGeoSubDomainBoundary bound : this._subDomainBoundaryList) {
            int jnctId = bound.getJnctId();
            WQGeoSubDomainJunction wqj = this.getWQJunction(jnctId);
            if (wqj == null) continue;
            wqj.addBoundary(bound);
            if (bound.getBoundaryType() != BoundaryType.LOCAL_DIVERSION || (jnctId = bound.getDsDiversionJnctId()) < 0) continue;
            wqj = this.getWQJunction(jnctId);
            wqj.addBoundary(bound);
        }
    }

    public WQGeoSubDomainJunction getWQJunction(int jnctId) {
        for (WQGeoSubDomainJunction wqjnct : this._subDomainJnctList) {
            int tmpJnctId = wqjnct.getJnctId();
            if (tmpJnctId != jnctId) continue;
            return wqjnct;
        }
        return null;
    }

    public void associateBoundaries(WQGeoSubDomain subdom, boolean addFlowFaceBdyIdx) throws WQException {
        int sdId = subdom.getId();
        List<WQGeoSubDomainBoundary> upBList = this.findUpstreamBoundaries(sdId);
        List<WQGeoSubDomainBoundary> downBList = this.findDownstreamBoundaries(sdId);
        try {
            WQGeoSubDomainBoundary firstUpstreamBoundary = upBList.get(0);
            if (addFlowFaceBdyIdx) {
                subdom.addFlowFaceBoundaryIdx(firstUpstreamBoundary.getId());
            }
        }
        catch (Exception e) {
            throw new WQException(e);
        }
        try {
            WQGeoSubDomainBoundary firstDownstreamBoundary = downBList.get(0);
            if (addFlowFaceBdyIdx) {
                subdom.addFlowFaceBoundaryIdx(firstDownstreamBoundary.getId());
            }
        }
        catch (Exception e) {
            throw new WQException(e);
        }
        if (subdom.getType() == SubDomainType.RESERVOIR_1DV) {
            this.addResUpstreamBoundaries(subdom, upBList, addFlowFaceBdyIdx);
            this.addResDownstreamBoundaries(subdom, downBList, addFlowFaceBdyIdx);
        }
    }

    private void addResDownstreamBoundaries(WQGeoSubDomain subdom, List<WQGeoSubDomainBoundary> downBList, boolean addFlowFaceBdyIdx) {
        if (downBList.size() > 1) {
            for (int i = 1; i < downBList.size(); ++i) {
                WQGeoSubDomainBoundary b = downBList.get(i);
                int[] faceCells = new int[]{subdom.getNumCells() - 1, -2};
                subdom.addFlowFaces(faceCells);
                if (!addFlowFaceBdyIdx) continue;
                subdom.addFlowFaceBoundaryIdx(b.getId());
            }
        }
    }

    private void addResUpstreamBoundaries(WQGeoSubDomain subdom, List<WQGeoSubDomainBoundary> upBList, boolean addFlowFaceBdyIdx) {
        if (upBList.size() > 1) {
            for (int i = 1; i < upBList.size(); ++i) {
                WQGeoSubDomainBoundary b = upBList.get(i);
                int[] faceCells = new int[]{-2, subdom.getNumCells() - 1};
                subdom.addFlowFaces(faceCells);
                if (!addFlowFaceBdyIdx) continue;
                subdom.addFlowFaceBoundaryIdx(b.getId());
            }
        }
    }

    public void initHydro() {
        for (WQGeoSubDomain subdom : this._subDomainList) {
            subdom.createHydro();
        }
    }

    public void saveElementState(WQEngineAdapter.STATE state) {
        for (WQGeoSubDomain subdom : this._subDomainList) {
            subdom.saveElementState(state);
        }
    }

    public void restoreElementState(WQEngineAdapter.STATE state) {
        for (WQGeoSubDomain subdom : this._subDomainList) {
            subdom.restoreElementState(state);
        }
    }

    @JsonIgnore
    public int getNumSubdomainBoundaries() {
        return this._subDomainBoundaryList.size();
    }

    public void loadFlowTable(Path flowTablePath, int unitSystem) throws WQException {
        if (flowTablePath != null) {
            if (unitSystem == 2) {
                try {
                    this._topWidthUnits = new Units("m");
                    this._areaUnits = new Units("m2");
                    this._flowUnits = new Units("cms");
                }
                catch (DataSetIllegalArgumentException dsiae) {
                    throw new WQException(dsiae.getMessage());
                }
            }
            if (unitSystem == 1) {
                try {
                    this._topWidthUnits = new Units("ft");
                    this._areaUnits = new Units("sq ft");
                    this._flowUnits = new Units("cfs");
                }
                catch (DataSetIllegalArgumentException dsiae) {
                    throw new WQException(dsiae.getMessage());
                }
            }
            try {
                this._flowTable = FlowTable.parseFromPath((Path)flowTablePath);
            }
            catch (IOException | NullPointerException ioe) {
                throw new WQException("Problem loading RAS steady flow table file " + flowTablePath + "\n" + ioe.getMessage());
            }
        }
        throw new WQException("Water Quality RAS steady flow table file not found");
    }

    @JsonIgnore
    public FlowTable getFlowTable() {
        return this._flowTable;
    }

    @JsonIgnore
    public Units getFlowUnits() {
        return this._flowUnits;
    }

    public double getRASSteadyFlowXSArea(String river, String reach, String station, double flow) throws WQException {
        if (this._flowTable == null) {
            throw new WQException("RAS Steady flow table not found");
        }
        return this._flowTable.getFlowArea(river, reach, station, flow, this._areaUnits, this._flowUnits);
    }

    public double getRASSteadyFlowTopWidth(String river, String reach, String station, double flow) throws WQException {
        if (this._flowTable == null) {
            throw new WQException("RAS Steady flow table not found");
        }
        return this._flowTable.getTopWidth(river, reach, station, flow, this._topWidthUnits, this._flowUnits);
    }

    public List<SubDomainBoundary> getBoundaries(BoundaryType type) {
        List<Object> retval;
        if (type != null) {
            List<SubDomainBoundary> boundaries = this.getBoundariesList();
            retval = boundaries.stream().filter(b -> type.equals((Object)b.getBoundaryType())).collect(Collectors.toList());
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public List<SubDomainBoundary> getBoundaries(Collection<BoundaryType> types) {
        List<Object> retval;
        if (types != null) {
            List<SubDomainBoundary> boundaries = this.getBoundariesList();
            retval = boundaries.stream().filter(b -> types.contains(b.getBoundaryType())).collect(Collectors.toList());
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public List<SubDomainBoundary> getBoundariesUnique(Collection<BoundaryType> types) {
        List<SubDomainBoundary> origList = this.getBoundaries(types);
        ArrayList<SubDomainBoundary> uniqueJnctList = new ArrayList<SubDomainBoundary>();
        HashSet<Integer> jnctIdSet = new HashSet<Integer>();
        for (SubDomainBoundary sdb : origList) {
            int jnctId = sdb.getJnctId();
            if (!sdb.getInExtent() || jnctIdSet.contains(jnctId)) continue;
            jnctIdSet.add(jnctId);
            uniqueJnctList.add(sdb);
        }
        return uniqueJnctList;
    }

    public List<SubDomainBoundary> getBoundariesResOutflowUnique(Collection<BoundaryType> types) {
        List<SubDomainBoundary> origList = this.getBoundaries(types);
        ArrayList<SubDomainBoundary> uniqueJnctList = new ArrayList<SubDomainBoundary>();
        HashSet<Integer> jnctIdSet = new HashSet<Integer>();
        for (SubDomainBoundary sdb : origList) {
            int jnctId = sdb.getJnctId();
            if (!sdb.getInExtent() || jnctIdSet.contains(jnctId)) continue;
            jnctIdSet.add(jnctId);
            uniqueJnctList.add(sdb);
        }
        return uniqueJnctList;
    }

    public Map<Integer, Integer> getDownstreamSubDomainIds(Collection<Integer> boundaryIds) {
        List<SubDomainBoundary> boundaries = this.getBoundariesList();
        return boundaries.stream().filter(b -> boundaryIds.contains(b.getId())).collect(Collectors.toMap(b -> b.getId(), b -> b.getDownstreamSubDomainId()));
    }

    public Map<Integer, SubDomain> getDownstreamSubDomains(Collection<Integer> boundaryIds) {
        LinkedHashMap<Integer, SubDomain> retval = new LinkedHashMap<Integer, SubDomain>();
        Map<Integer, Integer> boundaryIdToSubDomainId = this.getDownstreamSubDomainIds(boundaryIds);
        for (Map.Entry<Integer, Integer> entry : boundaryIdToSubDomainId.entrySet()) {
            Integer boundaryId = entry.getKey();
            Integer subDomainId = entry.getValue();
            WQGeoSubDomain subDomain = this.getSubDomain(subDomainId);
            if (subDomain == null) continue;
            retval.put(boundaryId, subDomain);
        }
        return retval;
    }

    public WQGeoSubDomain getDownstreamSubDomain(int subDomainBoundaryId) {
        WQGeoSubDomain retval = null;
        WQGeoSubDomainBoundary boundary = this.getBoundary(subDomainBoundaryId);
        if (boundary != null) {
            retval = this.getSubDomain(boundary.getDownstreamSubDomainId());
        }
        return retval;
    }

    @JsonIgnore
    public Collection<SubDomain> getReservoirs() {
        Extent extent = this.getGeometryExtent();
        return this.getSubDomainList().stream().filter(d -> extent.contains(d.getRef())).filter(d -> d.getType() == SubDomainType.RESERVOIR_1DV).collect(Collectors.toList());
    }

    @JsonIgnore
    public Collection<SubDomain> getReaches() {
        Extent extent = this.getGeometryExtent();
        return this.getSubDomainList().stream().filter(d -> extent.contains(d.getRef())).filter(d -> d.getType() == SubDomainType.REACH_1D).collect(Collectors.toList());
    }

    @JsonIgnore
    public Collection<SubDomainBoundary> getExternalBoundaries() {
        EnumSet<BoundaryType> types = EnumSet.of(BoundaryType.RIVER_INFLOW_IN_NETWORK, BoundaryType.RESERVOIR_INFLOW_IN_NETWORK);
        return this.getBoundaries(types);
    }

    public SubDomain getSubDomain(SubDomainRef ref) {
        return ref.getSubDomain((Geometry)this);
    }

    public SubDomainBoundary getBoundary(SubDomainBoundaryRef ref) {
        return ref.getBoundary((Geometry)this);
    }

    public WQSubDomainRef buildRef(SubDomain domain) {
        return new WQSubDomainRef(this.getId(), domain);
    }

    public WQSubDomainBoundaryRef buildRef(SubDomainBoundary bound) {
        return new WQSubDomainBoundaryRef(this.getId(), bound);
    }

    public WQSubDomainJunctionRef buildRef(SubDomainJunction junction) {
        return new WQSubDomainJunctionRef(this.getId(), junction);
    }

    public WQRegionRef buildRef(Region region) {
        return new WQRegionRef(this.getId(), region);
    }

    @JsonIgnore
    public Extent getGeometryExtent() {
        if (this._extent == null) {
            this._extent = new WQGeometryExtent();
        }
        return this._extent;
    }

    public WQConsistencyCheck checkConsistency(WQConsistencyCheck consistencyCheck, MetStationSet metDataset) {
        if (consistencyCheck == null) {
            String datasetName = "Water Quality Geometry: ";
            consistencyCheck = new WQConsistencyCheck(datasetName);
        }
        if (metDataset != null) {
            List metStations = metDataset.getActiveStations();
            Map<WQSubDomainRef, Integer> metStatMap = this._metAssignmentSet.getMetStationMap(metDataset.getId());
            for (SubDomain subdom : this.getSubDomainsInExtent()) {
                boolean found = false;
                int sdId = subdom.getId();
                block1: for (Map.Entry<WQSubDomainRef, Integer> mapElement : metStatMap.entrySet()) {
                    WQSubDomainRef sdRef = mapElement.getKey();
                    if (sdRef.getId() != sdId) continue;
                    int metStatId = mapElement.getValue();
                    for (MetStation ms : metStations) {
                        if (metStatId != ms.getId()) continue;
                        found = true;
                        break block1;
                    }
                }
                if (found) continue;
                String errorMessage = "Subdomain: " + subdom.getName() + " met station assignment not found in Met Data Set: " + metDataset.getName();
                consistencyCheck.addErrorMessage(errorMessage);
            }
        }
        for (SubDomain subdom : this.getSubDomainsInExtent()) {
            if (subdom.getType() != SubDomainType.RESERVOIR_1DV || subdom.getNumCells() != 1) continue;
            String warningMessage = "Subdomain: " + subdom.getName() + " has only 1 vertical layer";
            consistencyCheck.addWarningMessage(warningMessage);
        }
        return consistencyCheck;
    }

    public int findCellForStreamStation(SubDomain subdom, double streamStation) {
        return 0;
    }

    private class WQGeometryExtent
    implements Extent {
        public Collection<SubDomainRef> getElements() {
            Collection regions = WQGeometry.this._regionSet.getRegions();
            LinkedHashSet<SubDomainRef> elements = new LinkedHashSet<SubDomainRef>();
            for (WQRegion region : regions) {
                elements.addAll(region.getElements());
            }
            return elements;
        }

        public boolean contains(SubDomainRef subDomainRef) {
            return WQGeometry.this._regionSet.contains(subDomainRef);
        }

        public void add(SubDomainRef subDomainRef) {
            WQGeometry.this._regionSet.getDefaultRegion().add(subDomainRef);
        }

        public void remove(SubDomainRef subDomainRef) {
            WQGeometry.this._regionSet.remove(subDomainRef);
        }
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQGeometry.class);
        }
    }
}

