/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.MetAssignmentSet;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQStationSetAssignments;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQMetAssignmentSet
implements MetAssignmentSet {
    private Map<Integer, WQStationSetAssignments> _mappings = new LinkedHashMap<Integer, WQStationSetAssignments>();

    public Integer getMetStationId(int stationSetId, SubDomainRef ref) {
        Integer retval = null;
        WQStationSetAssignments assignments = this._mappings.get(stationSetId);
        if (assignments != null) {
            retval = assignments.getMetStationId(ref);
        }
        return retval;
    }

    public void setMetStationId(int stationSetId, WQSubDomainRef ref, Integer id) {
        if (ref != null) {
            WQStationSetAssignments assignments = this._mappings.computeIfAbsent(stationSetId, v -> new WQStationSetAssignments());
            assignments.setMetStationId(ref, id);
        }
    }

    public Map<WQSubDomainRef, Integer> getMetStationMap(int stationSetId) {
        WQStationSetAssignments assignments = this._mappings.computeIfAbsent(stationSetId, v -> new WQStationSetAssignments());
        return assignments.getMetStationMap();
    }

    public void setMetStationMap(int stationSetId, Map<WQSubDomainRef, Integer> associations) {
        if (associations == null || associations.isEmpty()) {
            this._mappings.remove(stationSetId);
        } else {
            this._mappings.put(stationSetId, new WQStationSetAssignments(associations));
        }
    }

    @JsonIgnore
    public Set<Integer> getMetStationSetIds() {
        return Collections.unmodifiableSet(this._mappings.keySet());
    }

    public void setEntries(List<Entry<Integer, WQStationSetAssignments>> entries) {
        Entry.setEntries(this._mappings, entries);
    }

    public List<Entry<Integer, WQStationSetAssignments>> getEntries() {
        return Entry.fromMapEntries(this._mappings.entrySet());
    }

    public Set<WQSubDomainRef> getSubDomainRefs(int stationSetId) {
        Set<WQSubDomainRef> retval = Collections.emptySet();
        WQStationSetAssignments assignments = this._mappings.get(stationSetId);
        if (assignments != null) {
            retval = assignments.getSubDomainRefs();
        }
        return retval;
    }

    @JsonIgnore
    public Set<WQSubDomainRef> getSubDomainRefs() {
        LinkedHashSet<WQSubDomainRef> retval = new LinkedHashSet<WQSubDomainRef>();
        for (Integer stationSetId : this._mappings.keySet()) {
            retval.addAll(this.getSubDomainRefs(stationSetId));
        }
        return retval;
    }

    @JsonIgnore
    public Set<Integer> getStationSetIds() {
        return this._mappings.keySet();
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQMetAssignmentSet.class);
        }
    }
}

