/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Region;
import hec.wqenginecore.RegionSet;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.region.WQRegionSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQRegionRef
implements RegionRef {
    private final int _id;
    private final int _geometryId;
    private final String _name;

    @JsonCreator
    public WQRegionRef(@JsonProperty(value="geometryId") int geometryId, @JsonProperty(value="id") int id, @JsonProperty(value="name") String name) {
        this._geometryId = geometryId;
        this._id = id;
        this._name = name;
    }

    public WQRegionRef(int geoId, Region r) {
        this._geometryId = geoId;
        this._id = r.getId();
        this._name = r.getName();
    }

    public int getId() {
        return this._id;
    }

    public int getGeometryId() {
        return this._geometryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WQRegionRef that = (WQRegionRef)o;
        return this._id == that._id && this._geometryId == that._geometryId && Objects.equals(this._name, that._name);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._geometryId, this._name);
    }

    public String getName() {
        return this._name;
    }

    public Region getRegion(RegionSet set) {
        Region retval = null;
        if (set instanceof WQRegionSet) {
            List namesMatch;
            WQRegionSet wqSet = (WQRegionSet)set;
            int origGeoId = wqSet.getGeometryId();
            retval = this.getGeometryId() == origGeoId ? set.getRegion(this.getId()) : ((namesMatch = set.getRegions().stream().filter(r -> Objects.equals(r.getName(), this.getName())).collect(Collectors.toList())).size() == 1 ? (Region)namesMatch.get(0) : (Region)namesMatch.stream().filter(r -> r.getId() == this.getId()).findFirst().orElse(null));
        }
        return retval;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQRegionRef.class);
        }
    }
}

