/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQStationSetAssignments {
    private Map<WQSubDomainRef, Integer> _assignments = new LinkedHashMap<WQSubDomainRef, Integer>();

    public WQStationSetAssignments(Map<? extends WQSubDomainRef, Integer> associations) {
        this._assignments.putAll(associations);
    }

    public WQStationSetAssignments() {
    }

    @JsonIgnore
    public Map<WQSubDomainRef, Integer> getMetStationMap() {
        return this._assignments;
    }

    public Integer getMetStationId(SubDomainRef ref) {
        return this._assignments.get(ref);
    }

    public void setMetStationId(WQSubDomainRef ref, Integer stationId) {
        if (stationId == null) {
            this._assignments.remove(ref);
        } else {
            this._assignments.put(ref, stationId);
        }
    }

    @JsonIgnore
    public Set<WQSubDomainRef> getSubDomainRefs() {
        return Collections.unmodifiableSet(this._assignments.keySet());
    }

    @JsonGetter
    public List<Entry<WQSubDomainRef, Integer>> getEntries() {
        return Entry.fromMapEntries(this._assignments.entrySet());
    }

    @JsonSetter
    public void setEntries(List<Entry<WQSubDomainRef, Integer>> entries) {
        Entry.setEntries(this._assignments, entries);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQStationSetAssignments.class);
        }
    }
}

